/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCorsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCorsConfiguration> {
    private static final SdkField<List<String>> ALLOW_ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowOrigins").getter(AwsCorsConfiguration.getter(AwsCorsConfiguration::allowOrigins)).setter(AwsCorsConfiguration.setter(Builder::allowOrigins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowOrigins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOW_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowCredentials").getter(AwsCorsConfiguration.getter(AwsCorsConfiguration::allowCredentials)).setter(AwsCorsConfiguration.setter(Builder::allowCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCredentials").build()}).build();
    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExposeHeaders").getter(AwsCorsConfiguration.getter(AwsCorsConfiguration::exposeHeaders)).setter(AwsCorsConfiguration.setter(Builder::exposeHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExposeHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_AGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAge").getter(AwsCorsConfiguration.getter(AwsCorsConfiguration::maxAge)).setter(AwsCorsConfiguration.setter(Builder::maxAge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAge").build()}).build();
    private static final SdkField<List<String>> ALLOW_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowMethods").getter(AwsCorsConfiguration.getter(AwsCorsConfiguration::allowMethods)).setter(AwsCorsConfiguration.setter(Builder::allowMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowHeaders").getter(AwsCorsConfiguration.getter(AwsCorsConfiguration::allowHeaders)).setter(AwsCorsConfiguration.setter(Builder::allowHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_ORIGINS_FIELD, ALLOW_CREDENTIALS_FIELD, EXPOSE_HEADERS_FIELD, MAX_AGE_FIELD, ALLOW_METHODS_FIELD, ALLOW_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsCorsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allowOrigins;
    private final Boolean allowCredentials;
    private final List<String> exposeHeaders;
    private final Integer maxAge;
    private final List<String> allowMethods;
    private final List<String> allowHeaders;

    private AwsCorsConfiguration(BuilderImpl builder) {
        this.allowOrigins = builder.allowOrigins;
        this.allowCredentials = builder.allowCredentials;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAge = builder.maxAge;
        this.allowMethods = builder.allowMethods;
        this.allowHeaders = builder.allowHeaders;
    }

    public final boolean hasAllowOrigins() {
        return this.allowOrigins != null && !(this.allowOrigins instanceof SdkAutoConstructList);
    }

    public final List<String> allowOrigins() {
        return this.allowOrigins;
    }

    public final Boolean allowCredentials() {
        return this.allowCredentials;
    }

    public final boolean hasExposeHeaders() {
        return this.exposeHeaders != null && !(this.exposeHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public final Integer maxAge() {
        return this.maxAge;
    }

    public final boolean hasAllowMethods() {
        return this.allowMethods != null && !(this.allowMethods instanceof SdkAutoConstructList);
    }

    public final List<String> allowMethods() {
        return this.allowMethods;
    }

    public final boolean hasAllowHeaders() {
        return this.allowHeaders != null && !(this.allowHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> allowHeaders() {
        return this.allowHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowOrigins() ? this.allowOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExposeHeaders() ? this.exposeHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAge());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowMethods() ? this.allowMethods() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowHeaders() ? this.allowHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCorsConfiguration)) {
            return false;
        }
        AwsCorsConfiguration other = (AwsCorsConfiguration)obj;
        return this.hasAllowOrigins() == other.hasAllowOrigins() && Objects.equals(this.allowOrigins(), other.allowOrigins()) && Objects.equals(this.allowCredentials(), other.allowCredentials()) && this.hasExposeHeaders() == other.hasExposeHeaders() && Objects.equals(this.exposeHeaders(), other.exposeHeaders()) && Objects.equals(this.maxAge(), other.maxAge()) && this.hasAllowMethods() == other.hasAllowMethods() && Objects.equals(this.allowMethods(), other.allowMethods()) && this.hasAllowHeaders() == other.hasAllowHeaders() && Objects.equals(this.allowHeaders(), other.allowHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCorsConfiguration").add("AllowOrigins", this.hasAllowOrigins() ? this.allowOrigins() : null).add("AllowCredentials", (Object)this.allowCredentials()).add("ExposeHeaders", this.hasExposeHeaders() ? this.exposeHeaders() : null).add("MaxAge", (Object)this.maxAge()).add("AllowMethods", this.hasAllowMethods() ? this.allowMethods() : null).add("AllowHeaders", this.hasAllowHeaders() ? this.allowHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowOrigins": {
                return Optional.ofNullable(clazz.cast(this.allowOrigins()));
            }
            case "AllowCredentials": {
                return Optional.ofNullable(clazz.cast(this.allowCredentials()));
            }
            case "ExposeHeaders": {
                return Optional.ofNullable(clazz.cast(this.exposeHeaders()));
            }
            case "MaxAge": {
                return Optional.ofNullable(clazz.cast(this.maxAge()));
            }
            case "AllowMethods": {
                return Optional.ofNullable(clazz.cast(this.allowMethods()));
            }
            case "AllowHeaders": {
                return Optional.ofNullable(clazz.cast(this.allowHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllowOrigins", ALLOW_ORIGINS_FIELD);
        map.put("AllowCredentials", ALLOW_CREDENTIALS_FIELD);
        map.put("ExposeHeaders", EXPOSE_HEADERS_FIELD);
        map.put("MaxAge", MAX_AGE_FIELD);
        map.put("AllowMethods", ALLOW_METHODS_FIELD);
        map.put("AllowHeaders", ALLOW_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCorsConfiguration, T> g) {
        return obj -> g.apply((AwsCorsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowOrigins = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowCredentials;
        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAge;
        private List<String> allowMethods = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCorsConfiguration model) {
            this.allowOrigins(model.allowOrigins);
            this.allowCredentials(model.allowCredentials);
            this.exposeHeaders(model.exposeHeaders);
            this.maxAge(model.maxAge);
            this.allowMethods(model.allowMethods);
            this.allowHeaders(model.allowHeaders);
        }

        public final Collection<String> getAllowOrigins() {
            if (this.allowOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowOrigins;
        }

        public final void setAllowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = NonEmptyStringListCopier.copy(allowOrigins);
        }

        @Override
        public final Builder allowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = NonEmptyStringListCopier.copy(allowOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowOrigins(String ... allowOrigins) {
            this.allowOrigins(Arrays.asList(allowOrigins));
            return this;
        }

        public final Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        public final void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        @Override
        public final Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public final Collection<String> getExposeHeaders() {
            if (this.exposeHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exposeHeaders;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = NonEmptyStringListCopier.copy(exposeHeaders);
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = NonEmptyStringListCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String ... exposeHeaders) {
            this.exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final Integer getMaxAge() {
            return this.maxAge;
        }

        public final void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        @Override
        public final Builder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public final Collection<String> getAllowMethods() {
            if (this.allowMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowMethods;
        }

        public final void setAllowMethods(Collection<String> allowMethods) {
            this.allowMethods = NonEmptyStringListCopier.copy(allowMethods);
        }

        @Override
        public final Builder allowMethods(Collection<String> allowMethods) {
            this.allowMethods = NonEmptyStringListCopier.copy(allowMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowMethods(String ... allowMethods) {
            this.allowMethods(Arrays.asList(allowMethods));
            return this;
        }

        public final Collection<String> getAllowHeaders() {
            if (this.allowHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowHeaders;
        }

        public final void setAllowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = NonEmptyStringListCopier.copy(allowHeaders);
        }

        @Override
        public final Builder allowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = NonEmptyStringListCopier.copy(allowHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowHeaders(String ... allowHeaders) {
            this.allowHeaders(Arrays.asList(allowHeaders));
            return this;
        }

        public AwsCorsConfiguration build() {
            return new AwsCorsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCorsConfiguration> {
        public Builder allowOrigins(Collection<String> var1);

        public Builder allowOrigins(String ... var1);

        public Builder allowCredentials(Boolean var1);

        public Builder exposeHeaders(Collection<String> var1);

        public Builder exposeHeaders(String ... var1);

        public Builder maxAge(Integer var1);

        public Builder allowMethods(Collection<String> var1);

        public Builder allowMethods(String ... var1);

        public Builder allowHeaders(Collection<String> var1);

        public Builder allowHeaders(String ... var1);
    }
}

