/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ActionListCopier;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesAction;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters;
import software.amazon.awssdk.services.securityhub.model.RuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomationRulesRequestItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateAutomationRulesRequestItem> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::ruleArn)).setter(UpdateAutomationRulesRequestItem.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::ruleStatusAsString)).setter(UpdateAutomationRulesRequestItem.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<Integer> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleOrder").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::ruleOrder)).setter(UpdateAutomationRulesRequestItem.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::description)).setter(UpdateAutomationRulesRequestItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::ruleName)).setter(UpdateAutomationRulesRequestItem.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTerminal").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::isTerminal)).setter(UpdateAutomationRulesRequestItem.setter(Builder::isTerminal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTerminal").build()}).build();
    private static final SdkField<AutomationRulesFindingFilters> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Criteria").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::criteria)).setter(UpdateAutomationRulesRequestItem.setter(Builder::criteria)).constructor(AutomationRulesFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()}).build();
    private static final SdkField<List<AutomationRulesAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(UpdateAutomationRulesRequestItem.getter(UpdateAutomationRulesRequestItem::actions)).setter(UpdateAutomationRulesRequestItem.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD, RULE_STATUS_FIELD, RULE_ORDER_FIELD, DESCRIPTION_FIELD, RULE_NAME_FIELD, IS_TERMINAL_FIELD, CRITERIA_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomationRulesRequestItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleArn;
    private final String ruleStatus;
    private final Integer ruleOrder;
    private final String description;
    private final String ruleName;
    private final Boolean isTerminal;
    private final AutomationRulesFindingFilters criteria;
    private final List<AutomationRulesAction> actions;

    private UpdateAutomationRulesRequestItem(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.description = builder.description;
        this.ruleName = builder.ruleName;
        this.isTerminal = builder.isTerminal;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final RuleStatus ruleStatus() {
        return RuleStatus.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final Integer ruleOrder() {
        return this.ruleOrder;
    }

    public final String description() {
        return this.description;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final Boolean isTerminal() {
        return this.isTerminal;
    }

    public final AutomationRulesFindingFilters criteria() {
        return this.criteria;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesAction> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomationRulesRequestItem)) {
            return false;
        }
        UpdateAutomationRulesRequestItem other = (UpdateAutomationRulesRequestItem)obj;
        return Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.isTerminal(), other.isTerminal()) && Objects.equals(this.criteria(), other.criteria()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomationRulesRequestItem").add("RuleArn", (Object)this.ruleArn()).add("RuleStatus", (Object)this.ruleStatusAsString()).add("RuleOrder", (Object)this.ruleOrder()).add("Description", (Object)this.description()).add("RuleName", (Object)this.ruleName()).add("IsTerminal", (Object)this.isTerminal()).add("Criteria", (Object)this.criteria()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "IsTerminal": {
                return Optional.ofNullable(clazz.cast(this.isTerminal()));
            }
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("RuleStatus", RULE_STATUS_FIELD);
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("IsTerminal", IS_TERMINAL_FIELD);
        map.put("Criteria", CRITERIA_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomationRulesRequestItem, T> g) {
        return obj -> g.apply((UpdateAutomationRulesRequestItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private String ruleStatus;
        private Integer ruleOrder;
        private String description;
        private String ruleName;
        private Boolean isTerminal;
        private AutomationRulesFindingFilters criteria;
        private List<AutomationRulesAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomationRulesRequestItem model) {
            this.ruleArn(model.ruleArn);
            this.ruleStatus(model.ruleStatus);
            this.ruleOrder(model.ruleOrder);
            this.description(model.description);
            this.ruleName(model.ruleName);
            this.isTerminal(model.isTerminal);
            this.criteria(model.criteria);
            this.actions(model.actions);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Integer getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final AutomationRulesFindingFilters.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(AutomationRulesFindingFilters.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(AutomationRulesFindingFilters criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesAction.Builder> getActions() {
            List<AutomationRulesAction.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesAction.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesAction> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (AutomationRulesAction)((AutomationRulesAction.Builder)AutomationRulesAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UpdateAutomationRulesRequestItem build() {
            return new UpdateAutomationRulesRequestItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateAutomationRulesRequestItem> {
        public Builder ruleArn(String var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatus var1);

        public Builder ruleOrder(Integer var1);

        public Builder description(String var1);

        public Builder ruleName(String var1);

        public Builder isTerminal(Boolean var1);

        public Builder criteria(AutomationRulesFindingFilters var1);

        default public Builder criteria(Consumer<AutomationRulesFindingFilters.Builder> criteria) {
            return this.criteria((AutomationRulesFindingFilters)((AutomationRulesFindingFilters.Builder)AutomationRulesFindingFilters.builder().applyMutation(criteria)).build());
        }

        public Builder actions(Collection<AutomationRulesAction> var1);

        public Builder actions(AutomationRulesAction ... var1);

        public Builder actions(Consumer<AutomationRulesAction.Builder> ... var1);
    }
}

