/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptAdministratorInvitationRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, AcceptAdministratorInvitationRequest> {
    private static final SdkField<String> ADMINISTRATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministratorId").getter(AcceptAdministratorInvitationRequest.getter(AcceptAdministratorInvitationRequest::administratorId)).setter(AcceptAdministratorInvitationRequest.setter(Builder::administratorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministratorId").build()}).build();
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvitationId").getter(AcceptAdministratorInvitationRequest.getter(AcceptAdministratorInvitationRequest::invitationId)).setter(AcceptAdministratorInvitationRequest.setter(Builder::invitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMINISTRATOR_ID_FIELD, INVITATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceptAdministratorInvitationRequest.memberNameToFieldInitializer();
    private final String administratorId;
    private final String invitationId;

    private AcceptAdministratorInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.administratorId = builder.administratorId;
        this.invitationId = builder.invitationId;
    }

    public final String administratorId() {
        return this.administratorId;
    }

    public final String invitationId() {
        return this.invitationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptAdministratorInvitationRequest)) {
            return false;
        }
        AcceptAdministratorInvitationRequest other = (AcceptAdministratorInvitationRequest)((Object)obj);
        return Objects.equals(this.administratorId(), other.administratorId()) && Objects.equals(this.invitationId(), other.invitationId());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptAdministratorInvitationRequest").add("AdministratorId", (Object)this.administratorId()).add("InvitationId", (Object)this.invitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdministratorId": {
                return Optional.ofNullable(clazz.cast(this.administratorId()));
            }
            case "InvitationId": {
                return Optional.ofNullable(clazz.cast(this.invitationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AdministratorId", ADMINISTRATOR_ID_FIELD);
        map.put("InvitationId", INVITATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptAdministratorInvitationRequest, T> g) {
        return obj -> g.apply((AcceptAdministratorInvitationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String administratorId;
        private String invitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptAdministratorInvitationRequest model) {
            super(model);
            this.administratorId(model.administratorId);
            this.invitationId(model.invitationId);
        }

        public final String getAdministratorId() {
            return this.administratorId;
        }

        public final void setAdministratorId(String administratorId) {
            this.administratorId = administratorId;
        }

        @Override
        public final Builder administratorId(String administratorId) {
            this.administratorId = administratorId;
            return this;
        }

        public final String getInvitationId() {
            return this.invitationId;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptAdministratorInvitationRequest build() {
            return new AcceptAdministratorInvitationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptAdministratorInvitationRequest> {
        public Builder administratorId(String var1);

        public Builder invitationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

