/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Cvss;
import software.amazon.awssdk.services.securityhub.model.CvssListCopier;
import software.amazon.awssdk.services.securityhub.model.SoftwarePackage;
import software.amazon.awssdk.services.securityhub.model.SoftwarePackageListCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilities;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityCodeVulnerabilitiesListCopier;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityExploitAvailable;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vulnerability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vulnerability> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Vulnerability.getter(Vulnerability::id)).setter(Vulnerability.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<SoftwarePackage>> VULNERABLE_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VulnerablePackages").getter(Vulnerability.getter(Vulnerability::vulnerablePackages)).setter(Vulnerability.setter(Builder::vulnerablePackages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VulnerablePackages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SoftwarePackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Cvss>> CVSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cvss").getter(Vulnerability.getter(Vulnerability::cvss)).setter(Vulnerability.setter(Builder::cvss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cvss").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cvss::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedVulnerabilities").getter(Vulnerability.getter(Vulnerability::relatedVulnerabilities)).setter(Vulnerability.setter(Builder::relatedVulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedVulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VulnerabilityVendor> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vendor").getter(Vulnerability.getter(Vulnerability::vendor)).setter(Vulnerability.setter(Builder::vendor)).constructor(VulnerabilityVendor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceUrls").getter(Vulnerability.getter(Vulnerability::referenceUrls)).setter(Vulnerability.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixAvailable").getter(Vulnerability.getter(Vulnerability::fixAvailableAsString)).setter(Vulnerability.setter(Builder::fixAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixAvailable").build()}).build();
    private static final SdkField<Double> EPSS_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EpssScore").getter(Vulnerability.getter(Vulnerability::epssScore)).setter(Vulnerability.setter(Builder::epssScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EpssScore").build()}).build();
    private static final SdkField<String> EXPLOIT_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExploitAvailable").getter(Vulnerability.getter(Vulnerability::exploitAvailableAsString)).setter(Vulnerability.setter(Builder::exploitAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExploitAvailable").build()}).build();
    private static final SdkField<String> LAST_KNOWN_EXPLOIT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastKnownExploitAt").getter(Vulnerability.getter(Vulnerability::lastKnownExploitAt)).setter(Vulnerability.setter(Builder::lastKnownExploitAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastKnownExploitAt").build()}).build();
    private static final SdkField<List<VulnerabilityCodeVulnerabilities>> CODE_VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CodeVulnerabilities").getter(Vulnerability.getter(Vulnerability::codeVulnerabilities)).setter(Vulnerability.setter(Builder::codeVulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeVulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VulnerabilityCodeVulnerabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VULNERABLE_PACKAGES_FIELD, CVSS_FIELD, RELATED_VULNERABILITIES_FIELD, VENDOR_FIELD, REFERENCE_URLS_FIELD, FIX_AVAILABLE_FIELD, EPSS_SCORE_FIELD, EXPLOIT_AVAILABLE_FIELD, LAST_KNOWN_EXPLOIT_AT_FIELD, CODE_VULNERABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Vulnerability.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<SoftwarePackage> vulnerablePackages;
    private final List<Cvss> cvss;
    private final List<String> relatedVulnerabilities;
    private final VulnerabilityVendor vendor;
    private final List<String> referenceUrls;
    private final String fixAvailable;
    private final Double epssScore;
    private final String exploitAvailable;
    private final String lastKnownExploitAt;
    private final List<VulnerabilityCodeVulnerabilities> codeVulnerabilities;

    private Vulnerability(BuilderImpl builder) {
        this.id = builder.id;
        this.vulnerablePackages = builder.vulnerablePackages;
        this.cvss = builder.cvss;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.vendor = builder.vendor;
        this.referenceUrls = builder.referenceUrls;
        this.fixAvailable = builder.fixAvailable;
        this.epssScore = builder.epssScore;
        this.exploitAvailable = builder.exploitAvailable;
        this.lastKnownExploitAt = builder.lastKnownExploitAt;
        this.codeVulnerabilities = builder.codeVulnerabilities;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasVulnerablePackages() {
        return this.vulnerablePackages != null && !(this.vulnerablePackages instanceof SdkAutoConstructList);
    }

    public final List<SoftwarePackage> vulnerablePackages() {
        return this.vulnerablePackages;
    }

    public final boolean hasCvss() {
        return this.cvss != null && !(this.cvss instanceof SdkAutoConstructList);
    }

    public final List<Cvss> cvss() {
        return this.cvss;
    }

    public final boolean hasRelatedVulnerabilities() {
        return this.relatedVulnerabilities != null && !(this.relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<String> relatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public final VulnerabilityVendor vendor() {
        return this.vendor;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final VulnerabilityFixAvailable fixAvailable() {
        return VulnerabilityFixAvailable.fromValue(this.fixAvailable);
    }

    public final String fixAvailableAsString() {
        return this.fixAvailable;
    }

    public final Double epssScore() {
        return this.epssScore;
    }

    public final VulnerabilityExploitAvailable exploitAvailable() {
        return VulnerabilityExploitAvailable.fromValue(this.exploitAvailable);
    }

    public final String exploitAvailableAsString() {
        return this.exploitAvailable;
    }

    public final String lastKnownExploitAt() {
        return this.lastKnownExploitAt;
    }

    public final boolean hasCodeVulnerabilities() {
        return this.codeVulnerabilities != null && !(this.codeVulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<VulnerabilityCodeVulnerabilities> codeVulnerabilities() {
        return this.codeVulnerabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerablePackages() ? this.vulnerablePackages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCvss() ? this.cvss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.epssScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitAvailableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastKnownExploitAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeVulnerabilities() ? this.codeVulnerabilities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return Objects.equals(this.id(), other.id()) && this.hasVulnerablePackages() == other.hasVulnerablePackages() && Objects.equals(this.vulnerablePackages(), other.vulnerablePackages()) && this.hasCvss() == other.hasCvss() && Objects.equals(this.cvss(), other.cvss()) && this.hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities() && Objects.equals(this.relatedVulnerabilities(), other.relatedVulnerabilities()) && Objects.equals(this.vendor(), other.vendor()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && Objects.equals(this.fixAvailableAsString(), other.fixAvailableAsString()) && Objects.equals(this.epssScore(), other.epssScore()) && Objects.equals(this.exploitAvailableAsString(), other.exploitAvailableAsString()) && Objects.equals(this.lastKnownExploitAt(), other.lastKnownExploitAt()) && this.hasCodeVulnerabilities() == other.hasCodeVulnerabilities() && Objects.equals(this.codeVulnerabilities(), other.codeVulnerabilities());
    }

    public final String toString() {
        return ToString.builder((String)"Vulnerability").add("Id", (Object)this.id()).add("VulnerablePackages", this.hasVulnerablePackages() ? this.vulnerablePackages() : null).add("Cvss", this.hasCvss() ? this.cvss() : null).add("RelatedVulnerabilities", this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null).add("Vendor", (Object)this.vendor()).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("FixAvailable", (Object)this.fixAvailableAsString()).add("EpssScore", (Object)this.epssScore()).add("ExploitAvailable", (Object)this.exploitAvailableAsString()).add("LastKnownExploitAt", (Object)this.lastKnownExploitAt()).add("CodeVulnerabilities", this.hasCodeVulnerabilities() ? this.codeVulnerabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "VulnerablePackages": {
                return Optional.ofNullable(clazz.cast(this.vulnerablePackages()));
            }
            case "Cvss": {
                return Optional.ofNullable(clazz.cast(this.cvss()));
            }
            case "RelatedVulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.relatedVulnerabilities()));
            }
            case "Vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "ReferenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "FixAvailable": {
                return Optional.ofNullable(clazz.cast(this.fixAvailableAsString()));
            }
            case "EpssScore": {
                return Optional.ofNullable(clazz.cast(this.epssScore()));
            }
            case "ExploitAvailable": {
                return Optional.ofNullable(clazz.cast(this.exploitAvailableAsString()));
            }
            case "LastKnownExploitAt": {
                return Optional.ofNullable(clazz.cast(this.lastKnownExploitAt()));
            }
            case "CodeVulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.codeVulnerabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("VulnerablePackages", VULNERABLE_PACKAGES_FIELD);
        map.put("Cvss", CVSS_FIELD);
        map.put("RelatedVulnerabilities", RELATED_VULNERABILITIES_FIELD);
        map.put("Vendor", VENDOR_FIELD);
        map.put("ReferenceUrls", REFERENCE_URLS_FIELD);
        map.put("FixAvailable", FIX_AVAILABLE_FIELD);
        map.put("EpssScore", EPSS_SCORE_FIELD);
        map.put("ExploitAvailable", EXPLOIT_AVAILABLE_FIELD);
        map.put("LastKnownExploitAt", LAST_KNOWN_EXPLOIT_AT_FIELD);
        map.put("CodeVulnerabilities", CODE_VULNERABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Vulnerability, T> g) {
        return obj -> g.apply((Vulnerability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<SoftwarePackage> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();
        private List<Cvss> cvss = DefaultSdkAutoConstructList.getInstance();
        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();
        private VulnerabilityVendor vendor;
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private String fixAvailable;
        private Double epssScore;
        private String exploitAvailable;
        private String lastKnownExploitAt;
        private List<VulnerabilityCodeVulnerabilities> codeVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Vulnerability model) {
            this.id(model.id);
            this.vulnerablePackages(model.vulnerablePackages);
            this.cvss(model.cvss);
            this.relatedVulnerabilities(model.relatedVulnerabilities);
            this.vendor(model.vendor);
            this.referenceUrls(model.referenceUrls);
            this.fixAvailable(model.fixAvailable);
            this.epssScore(model.epssScore);
            this.exploitAvailable(model.exploitAvailable);
            this.lastKnownExploitAt(model.lastKnownExploitAt);
            this.codeVulnerabilities(model.codeVulnerabilities);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<SoftwarePackage.Builder> getVulnerablePackages() {
            List<SoftwarePackage.Builder> result = SoftwarePackageListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerablePackages(Collection<SoftwarePackage.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = SoftwarePackageListCopier.copyFromBuilder(vulnerablePackages);
        }

        @Override
        public final Builder vulnerablePackages(Collection<SoftwarePackage> vulnerablePackages) {
            this.vulnerablePackages = SoftwarePackageListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(SoftwarePackage ... vulnerablePackages) {
            this.vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<SoftwarePackage.Builder> ... vulnerablePackages) {
            this.vulnerablePackages(Stream.of(vulnerablePackages).map(c -> (SoftwarePackage)((SoftwarePackage.Builder)SoftwarePackage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Cvss.Builder> getCvss() {
            List<Cvss.Builder> result = CvssListCopier.copyToBuilder(this.cvss);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCvss(Collection<Cvss.BuilderImpl> cvss) {
            this.cvss = CvssListCopier.copyFromBuilder(cvss);
        }

        @Override
        public final Builder cvss(Collection<Cvss> cvss) {
            this.cvss = CvssListCopier.copy(cvss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Cvss ... cvss) {
            this.cvss(Arrays.asList(cvss));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Consumer<Cvss.Builder> ... cvss) {
            this.cvss(Stream.of(cvss).map(c -> (Cvss)((Cvss.Builder)Cvss.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (this.relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringListCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String ... relatedVulnerabilities) {
            this.relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final VulnerabilityVendor.Builder getVendor() {
            return this.vendor != null ? this.vendor.toBuilder() : null;
        }

        public final void setVendor(VulnerabilityVendor.BuilderImpl vendor) {
            this.vendor = vendor != null ? vendor.build() : null;
        }

        @Override
        public final Builder vendor(VulnerabilityVendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = StringListCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = StringListCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final String getFixAvailable() {
            return this.fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        @Override
        public final Builder fixAvailable(VulnerabilityFixAvailable fixAvailable) {
            this.fixAvailable(fixAvailable == null ? null : fixAvailable.toString());
            return this;
        }

        public final Double getEpssScore() {
            return this.epssScore;
        }

        public final void setEpssScore(Double epssScore) {
            this.epssScore = epssScore;
        }

        @Override
        public final Builder epssScore(Double epssScore) {
            this.epssScore = epssScore;
            return this;
        }

        public final String getExploitAvailable() {
            return this.exploitAvailable;
        }

        public final void setExploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
        }

        @Override
        public final Builder exploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
            return this;
        }

        @Override
        public final Builder exploitAvailable(VulnerabilityExploitAvailable exploitAvailable) {
            this.exploitAvailable(exploitAvailable == null ? null : exploitAvailable.toString());
            return this;
        }

        public final String getLastKnownExploitAt() {
            return this.lastKnownExploitAt;
        }

        public final void setLastKnownExploitAt(String lastKnownExploitAt) {
            this.lastKnownExploitAt = lastKnownExploitAt;
        }

        @Override
        public final Builder lastKnownExploitAt(String lastKnownExploitAt) {
            this.lastKnownExploitAt = lastKnownExploitAt;
            return this;
        }

        public final List<VulnerabilityCodeVulnerabilities.Builder> getCodeVulnerabilities() {
            List<VulnerabilityCodeVulnerabilities.Builder> result = VulnerabilityCodeVulnerabilitiesListCopier.copyToBuilder(this.codeVulnerabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeVulnerabilities(Collection<VulnerabilityCodeVulnerabilities.BuilderImpl> codeVulnerabilities) {
            this.codeVulnerabilities = VulnerabilityCodeVulnerabilitiesListCopier.copyFromBuilder(codeVulnerabilities);
        }

        @Override
        public final Builder codeVulnerabilities(Collection<VulnerabilityCodeVulnerabilities> codeVulnerabilities) {
            this.codeVulnerabilities = VulnerabilityCodeVulnerabilitiesListCopier.copy(codeVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeVulnerabilities(VulnerabilityCodeVulnerabilities ... codeVulnerabilities) {
            this.codeVulnerabilities(Arrays.asList(codeVulnerabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeVulnerabilities(Consumer<VulnerabilityCodeVulnerabilities.Builder> ... codeVulnerabilities) {
            this.codeVulnerabilities(Stream.of(codeVulnerabilities).map(c -> (VulnerabilityCodeVulnerabilities)((VulnerabilityCodeVulnerabilities.Builder)VulnerabilityCodeVulnerabilities.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Vulnerability build() {
            return new Vulnerability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vulnerability> {
        public Builder id(String var1);

        public Builder vulnerablePackages(Collection<SoftwarePackage> var1);

        public Builder vulnerablePackages(SoftwarePackage ... var1);

        public Builder vulnerablePackages(Consumer<SoftwarePackage.Builder> ... var1);

        public Builder cvss(Collection<Cvss> var1);

        public Builder cvss(Cvss ... var1);

        public Builder cvss(Consumer<Cvss.Builder> ... var1);

        public Builder relatedVulnerabilities(Collection<String> var1);

        public Builder relatedVulnerabilities(String ... var1);

        public Builder vendor(VulnerabilityVendor var1);

        default public Builder vendor(Consumer<VulnerabilityVendor.Builder> vendor) {
            return this.vendor((VulnerabilityVendor)((VulnerabilityVendor.Builder)VulnerabilityVendor.builder().applyMutation(vendor)).build());
        }

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder fixAvailable(String var1);

        public Builder fixAvailable(VulnerabilityFixAvailable var1);

        public Builder epssScore(Double var1);

        public Builder exploitAvailable(String var1);

        public Builder exploitAvailable(VulnerabilityExploitAvailable var1);

        public Builder lastKnownExploitAt(String var1);

        public Builder codeVulnerabilities(Collection<VulnerabilityCodeVulnerabilities> var1);

        public Builder codeVulnerabilities(VulnerabilityCodeVulnerabilities ... var1);

        public Builder codeVulnerabilities(Consumer<VulnerabilityCodeVulnerabilities.Builder> ... var1);
    }
}

