/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicate;
import software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleMatchPredicateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafRateBasedRuleDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafRateBasedRuleDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AwsWafRateBasedRuleDetails.getter(AwsWafRateBasedRuleDetails::metricName)).setter(AwsWafRateBasedRuleDetails.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafRateBasedRuleDetails.getter(AwsWafRateBasedRuleDetails::name)).setter(AwsWafRateBasedRuleDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateKey").getter(AwsWafRateBasedRuleDetails.getter(AwsWafRateBasedRuleDetails::rateKey)).setter(AwsWafRateBasedRuleDetails.setter(Builder::rateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateKey").build()}).build();
    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RateLimit").getter(AwsWafRateBasedRuleDetails.getter(AwsWafRateBasedRuleDetails::rateLimit)).setter(AwsWafRateBasedRuleDetails.setter(Builder::rateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(AwsWafRateBasedRuleDetails.getter(AwsWafRateBasedRuleDetails::ruleId)).setter(AwsWafRateBasedRuleDetails.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<List<AwsWafRateBasedRuleMatchPredicate>> MATCH_PREDICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchPredicates").getter(AwsWafRateBasedRuleDetails.getter(AwsWafRateBasedRuleDetails::matchPredicates)).setter(AwsWafRateBasedRuleDetails.setter(Builder::matchPredicates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPredicates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafRateBasedRuleMatchPredicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD, RATE_KEY_FIELD, RATE_LIMIT_FIELD, RULE_ID_FIELD, MATCH_PREDICATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsWafRateBasedRuleDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String name;
    private final String rateKey;
    private final Long rateLimit;
    private final String ruleId;
    private final List<AwsWafRateBasedRuleMatchPredicate> matchPredicates;

    private AwsWafRateBasedRuleDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.rateKey = builder.rateKey;
        this.rateLimit = builder.rateLimit;
        this.ruleId = builder.ruleId;
        this.matchPredicates = builder.matchPredicates;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String name() {
        return this.name;
    }

    public final String rateKey() {
        return this.rateKey;
    }

    public final Long rateLimit() {
        return this.rateLimit;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final boolean hasMatchPredicates() {
        return this.matchPredicates != null && !(this.matchPredicates instanceof SdkAutoConstructList);
    }

    public final List<AwsWafRateBasedRuleMatchPredicate> matchPredicates() {
        return this.matchPredicates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchPredicates() ? this.matchPredicates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRateBasedRuleDetails)) {
            return false;
        }
        AwsWafRateBasedRuleDetails other = (AwsWafRateBasedRuleDetails)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.rateKey(), other.rateKey()) && Objects.equals(this.rateLimit(), other.rateLimit()) && Objects.equals(this.ruleId(), other.ruleId()) && this.hasMatchPredicates() == other.hasMatchPredicates() && Objects.equals(this.matchPredicates(), other.matchPredicates());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafRateBasedRuleDetails").add("MetricName", (Object)this.metricName()).add("Name", (Object)this.name()).add("RateKey", (Object)this.rateKey()).add("RateLimit", (Object)this.rateLimit()).add("RuleId", (Object)this.ruleId()).add("MatchPredicates", this.hasMatchPredicates() ? this.matchPredicates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RateKey": {
                return Optional.ofNullable(clazz.cast(this.rateKey()));
            }
            case "RateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "MatchPredicates": {
                return Optional.ofNullable(clazz.cast(this.matchPredicates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RateKey", RATE_KEY_FIELD);
        map.put("RateLimit", RATE_LIMIT_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("MatchPredicates", MATCH_PREDICATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRateBasedRuleDetails, T> g) {
        return obj -> g.apply((AwsWafRateBasedRuleDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String name;
        private String rateKey;
        private Long rateLimit;
        private String ruleId;
        private List<AwsWafRateBasedRuleMatchPredicate> matchPredicates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRateBasedRuleDetails model) {
            this.metricName(model.metricName);
            this.name(model.name);
            this.rateKey(model.rateKey);
            this.rateLimit(model.rateLimit);
            this.ruleId(model.ruleId);
            this.matchPredicates(model.matchPredicates);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRateKey() {
            return this.rateKey;
        }

        public final void setRateKey(String rateKey) {
            this.rateKey = rateKey;
        }

        @Override
        public final Builder rateKey(String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final List<AwsWafRateBasedRuleMatchPredicate.Builder> getMatchPredicates() {
            List<AwsWafRateBasedRuleMatchPredicate.Builder> result = AwsWafRateBasedRuleMatchPredicateListCopier.copyToBuilder(this.matchPredicates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchPredicates(Collection<AwsWafRateBasedRuleMatchPredicate.BuilderImpl> matchPredicates) {
            this.matchPredicates = AwsWafRateBasedRuleMatchPredicateListCopier.copyFromBuilder(matchPredicates);
        }

        @Override
        public final Builder matchPredicates(Collection<AwsWafRateBasedRuleMatchPredicate> matchPredicates) {
            this.matchPredicates = AwsWafRateBasedRuleMatchPredicateListCopier.copy(matchPredicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(AwsWafRateBasedRuleMatchPredicate ... matchPredicates) {
            this.matchPredicates(Arrays.asList(matchPredicates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(Consumer<AwsWafRateBasedRuleMatchPredicate.Builder> ... matchPredicates) {
            this.matchPredicates(Stream.of(matchPredicates).map(c -> (AwsWafRateBasedRuleMatchPredicate)((AwsWafRateBasedRuleMatchPredicate.Builder)AwsWafRateBasedRuleMatchPredicate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsWafRateBasedRuleDetails build() {
            return new AwsWafRateBasedRuleDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafRateBasedRuleDetails> {
        public Builder metricName(String var1);

        public Builder name(String var1);

        public Builder rateKey(String var1);

        public Builder rateLimit(Long var1);

        public Builder ruleId(String var1);

        public Builder matchPredicates(Collection<AwsWafRateBasedRuleMatchPredicate> var1);

        public Builder matchPredicates(AwsWafRateBasedRuleMatchPredicate ... var1);

        public Builder matchPredicates(Consumer<AwsWafRateBasedRuleMatchPredicate.Builder> ... var1);
    }
}

