/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersion;
import software.amazon.awssdk.services.securityhub.model.AwsIamPolicyVersionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsIamPolicyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsIamPolicyDetails> {
    private static final SdkField<Integer> ATTACHMENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AttachmentCount").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::attachmentCount)).setter(AwsIamPolicyDetails.setter(Builder::attachmentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentCount").build()}).build();
    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateDate").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::createDate)).setter(AwsIamPolicyDetails.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultVersionId").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::defaultVersionId)).setter(AwsIamPolicyDetails.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::description)).setter(AwsIamPolicyDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> IS_ATTACHABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsAttachable").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::isAttachable)).setter(AwsIamPolicyDetails.setter(Builder::isAttachable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAttachable").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::path)).setter(AwsIamPolicyDetails.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Integer> PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PermissionsBoundaryUsageCount").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::permissionsBoundaryUsageCount)).setter(AwsIamPolicyDetails.setter(Builder::permissionsBoundaryUsageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryUsageCount").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::policyId)).setter(AwsIamPolicyDetails.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::policyName)).setter(AwsIamPolicyDetails.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<List<AwsIamPolicyVersion>> POLICY_VERSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyVersionList").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::policyVersionList)).setter(AwsIamPolicyDetails.setter(Builder::policyVersionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsIamPolicyVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateDate").getter(AwsIamPolicyDetails.getter(AwsIamPolicyDetails::updateDate)).setter(AwsIamPolicyDetails.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_COUNT_FIELD, CREATE_DATE_FIELD, DEFAULT_VERSION_ID_FIELD, DESCRIPTION_FIELD, IS_ATTACHABLE_FIELD, PATH_FIELD, PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD, POLICY_ID_FIELD, POLICY_NAME_FIELD, POLICY_VERSION_LIST_FIELD, UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsIamPolicyDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer attachmentCount;
    private final String createDate;
    private final String defaultVersionId;
    private final String description;
    private final Boolean isAttachable;
    private final String path;
    private final Integer permissionsBoundaryUsageCount;
    private final String policyId;
    private final String policyName;
    private final List<AwsIamPolicyVersion> policyVersionList;
    private final String updateDate;

    private AwsIamPolicyDetails(BuilderImpl builder) {
        this.attachmentCount = builder.attachmentCount;
        this.createDate = builder.createDate;
        this.defaultVersionId = builder.defaultVersionId;
        this.description = builder.description;
        this.isAttachable = builder.isAttachable;
        this.path = builder.path;
        this.permissionsBoundaryUsageCount = builder.permissionsBoundaryUsageCount;
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.policyVersionList = builder.policyVersionList;
        this.updateDate = builder.updateDate;
    }

    public final Integer attachmentCount() {
        return this.attachmentCount;
    }

    public final String createDate() {
        return this.createDate;
    }

    public final String defaultVersionId() {
        return this.defaultVersionId;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isAttachable() {
        return this.isAttachable;
    }

    public final String path() {
        return this.path;
    }

    public final Integer permissionsBoundaryUsageCount() {
        return this.permissionsBoundaryUsageCount;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final boolean hasPolicyVersionList() {
        return this.policyVersionList != null && !(this.policyVersionList instanceof SdkAutoConstructList);
    }

    public final List<AwsIamPolicyVersion> policyVersionList() {
        return this.policyVersionList;
    }

    public final String updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttachable());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundaryUsageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyVersionList() ? this.policyVersionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamPolicyDetails)) {
            return false;
        }
        AwsIamPolicyDetails other = (AwsIamPolicyDetails)obj;
        return Objects.equals(this.attachmentCount(), other.attachmentCount()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isAttachable(), other.isAttachable()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.permissionsBoundaryUsageCount(), other.permissionsBoundaryUsageCount()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyName(), other.policyName()) && this.hasPolicyVersionList() == other.hasPolicyVersionList() && Objects.equals(this.policyVersionList(), other.policyVersionList()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public final String toString() {
        return ToString.builder((String)"AwsIamPolicyDetails").add("AttachmentCount", (Object)this.attachmentCount()).add("CreateDate", (Object)this.createDate()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("Description", (Object)this.description()).add("IsAttachable", (Object)this.isAttachable()).add("Path", (Object)this.path()).add("PermissionsBoundaryUsageCount", (Object)this.permissionsBoundaryUsageCount()).add("PolicyId", (Object)this.policyId()).add("PolicyName", (Object)this.policyName()).add("PolicyVersionList", this.hasPolicyVersionList() ? this.policyVersionList() : null).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentCount": {
                return Optional.ofNullable(clazz.cast(this.attachmentCount()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "DefaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IsAttachable": {
                return Optional.ofNullable(clazz.cast(this.isAttachable()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "PermissionsBoundaryUsageCount": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundaryUsageCount()));
            }
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyVersionList": {
                return Optional.ofNullable(clazz.cast(this.policyVersionList()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentCount", ATTACHMENT_COUNT_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("DefaultVersionId", DEFAULT_VERSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IsAttachable", IS_ATTACHABLE_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("PermissionsBoundaryUsageCount", PERMISSIONS_BOUNDARY_USAGE_COUNT_FIELD);
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyVersionList", POLICY_VERSION_LIST_FIELD);
        map.put("UpdateDate", UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsIamPolicyDetails, T> g) {
        return obj -> g.apply((AwsIamPolicyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer attachmentCount;
        private String createDate;
        private String defaultVersionId;
        private String description;
        private Boolean isAttachable;
        private String path;
        private Integer permissionsBoundaryUsageCount;
        private String policyId;
        private String policyName;
        private List<AwsIamPolicyVersion> policyVersionList = DefaultSdkAutoConstructList.getInstance();
        private String updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamPolicyDetails model) {
            this.attachmentCount(model.attachmentCount);
            this.createDate(model.createDate);
            this.defaultVersionId(model.defaultVersionId);
            this.description(model.description);
            this.isAttachable(model.isAttachable);
            this.path(model.path);
            this.permissionsBoundaryUsageCount(model.permissionsBoundaryUsageCount);
            this.policyId(model.policyId);
            this.policyName(model.policyName);
            this.policyVersionList(model.policyVersionList);
            this.updateDate(model.updateDate);
        }

        public final Integer getAttachmentCount() {
            return this.attachmentCount;
        }

        public final void setAttachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
        }

        @Override
        public final Builder attachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
            return this;
        }

        public final String getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsAttachable() {
            return this.isAttachable;
        }

        public final void setIsAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
        }

        @Override
        public final Builder isAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getPermissionsBoundaryUsageCount() {
            return this.permissionsBoundaryUsageCount;
        }

        public final void setPermissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount) {
            this.permissionsBoundaryUsageCount = permissionsBoundaryUsageCount;
        }

        @Override
        public final Builder permissionsBoundaryUsageCount(Integer permissionsBoundaryUsageCount) {
            this.permissionsBoundaryUsageCount = permissionsBoundaryUsageCount;
            return this;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final List<AwsIamPolicyVersion.Builder> getPolicyVersionList() {
            List<AwsIamPolicyVersion.Builder> result = AwsIamPolicyVersionListCopier.copyToBuilder(this.policyVersionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyVersionList(Collection<AwsIamPolicyVersion.BuilderImpl> policyVersionList) {
            this.policyVersionList = AwsIamPolicyVersionListCopier.copyFromBuilder(policyVersionList);
        }

        @Override
        public final Builder policyVersionList(Collection<AwsIamPolicyVersion> policyVersionList) {
            this.policyVersionList = AwsIamPolicyVersionListCopier.copy(policyVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(AwsIamPolicyVersion ... policyVersionList) {
            this.policyVersionList(Arrays.asList(policyVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersionList(Consumer<AwsIamPolicyVersion.Builder> ... policyVersionList) {
            this.policyVersionList(Stream.of(policyVersionList).map(c -> (AwsIamPolicyVersion)((AwsIamPolicyVersion.Builder)AwsIamPolicyVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(String updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(String updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public AwsIamPolicyDetails build() {
            return new AwsIamPolicyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsIamPolicyDetails> {
        public Builder attachmentCount(Integer var1);

        public Builder createDate(String var1);

        public Builder defaultVersionId(String var1);

        public Builder description(String var1);

        public Builder isAttachable(Boolean var1);

        public Builder path(String var1);

        public Builder permissionsBoundaryUsageCount(Integer var1);

        public Builder policyId(String var1);

        public Builder policyName(String var1);

        public Builder policyVersionList(Collection<AwsIamPolicyVersion> var1);

        public Builder policyVersionList(AwsIamPolicyVersion ... var1);

        public Builder policyVersionList(Consumer<AwsIamPolicyVersion.Builder> ... var1);

        public Builder updateDate(String var1);
    }
}

