/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiLogConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAppSyncGraphQlApiDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAppSyncGraphQlApiDetails> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::apiId)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::id)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenIdConnectConfig").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::openIdConnectConfig)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::openIdConnectConfig)).constructor(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIdConnectConfig").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::name)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaAuthorizerConfig").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::lambdaAuthorizerConfig)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::lambdaAuthorizerConfig)).constructor(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaAuthorizerConfig").build()}).build();
    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("XrayEnabled").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::xrayEnabled)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::xrayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XrayEnabled").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::arn)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<AwsAppSyncGraphQlApiUserPoolConfigDetails> USER_POOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserPoolConfig").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::userPoolConfig)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::userPoolConfig)).constructor(AwsAppSyncGraphQlApiUserPoolConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolConfig").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::authenticationType)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<AwsAppSyncGraphQlApiLogConfigDetails> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfig").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::logConfig)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::logConfig)).constructor(AwsAppSyncGraphQlApiLogConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfig").build()}).build();
    private static final SdkField<List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAuthenticationProviders").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::additionalAuthenticationProviders)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::additionalAuthenticationProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAuthenticationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WAF_WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WafWebAclArn").getter(AwsAppSyncGraphQlApiDetails.getter(AwsAppSyncGraphQlApiDetails::wafWebAclArn)).setter(AwsAppSyncGraphQlApiDetails.setter(Builder::wafWebAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WafWebAclArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, ID_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, NAME_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD, XRAY_ENABLED_FIELD, ARN_FIELD, USER_POOL_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD, LOG_CONFIG_FIELD, ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, WAF_WEB_ACL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsAppSyncGraphQlApiDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String apiId;
    private final String id;
    private final AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig;
    private final String name;
    private final AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig;
    private final Boolean xrayEnabled;
    private final String arn;
    private final AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig;
    private final String authenticationType;
    private final AwsAppSyncGraphQlApiLogConfigDetails logConfig;
    private final List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders;
    private final String wafWebAclArn;

    private AwsAppSyncGraphQlApiDetails(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.id = builder.id;
        this.openIdConnectConfig = builder.openIdConnectConfig;
        this.name = builder.name;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
        this.xrayEnabled = builder.xrayEnabled;
        this.arn = builder.arn;
        this.userPoolConfig = builder.userPoolConfig;
        this.authenticationType = builder.authenticationType;
        this.logConfig = builder.logConfig;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.wafWebAclArn = builder.wafWebAclArn;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String id() {
        return this.id;
    }

    public final AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig() {
        return this.openIdConnectConfig;
    }

    public final String name() {
        return this.name;
    }

    public final AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig() {
        return this.lambdaAuthorizerConfig;
    }

    public final Boolean xrayEnabled() {
        return this.xrayEnabled;
    }

    public final String arn() {
        return this.arn;
    }

    public final AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig() {
        return this.userPoolConfig;
    }

    public final String authenticationType() {
        return this.authenticationType;
    }

    public final AwsAppSyncGraphQlApiLogConfigDetails logConfig() {
        return this.logConfig;
    }

    public final boolean hasAdditionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders != null && !(this.additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    public final List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders() {
        return this.additionalAuthenticationProviders;
    }

    public final String wafWebAclArn() {
        return this.wafWebAclArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIdConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAuthorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAuthenticationProviders() ? this.additionalAuthenticationProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.wafWebAclArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAppSyncGraphQlApiDetails)) {
            return false;
        }
        AwsAppSyncGraphQlApiDetails other = (AwsAppSyncGraphQlApiDetails)obj;
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.openIdConnectConfig(), other.openIdConnectConfig()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig()) && Objects.equals(this.xrayEnabled(), other.xrayEnabled()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.userPoolConfig(), other.userPoolConfig()) && Objects.equals(this.authenticationType(), other.authenticationType()) && Objects.equals(this.logConfig(), other.logConfig()) && this.hasAdditionalAuthenticationProviders() == other.hasAdditionalAuthenticationProviders() && Objects.equals(this.additionalAuthenticationProviders(), other.additionalAuthenticationProviders()) && Objects.equals(this.wafWebAclArn(), other.wafWebAclArn());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAppSyncGraphQlApiDetails").add("ApiId", (Object)this.apiId()).add("Id", (Object)this.id()).add("OpenIdConnectConfig", (Object)this.openIdConnectConfig()).add("Name", (Object)this.name()).add("LambdaAuthorizerConfig", (Object)this.lambdaAuthorizerConfig()).add("XrayEnabled", (Object)this.xrayEnabled()).add("Arn", (Object)this.arn()).add("UserPoolConfig", (Object)this.userPoolConfig()).add("AuthenticationType", (Object)this.authenticationType()).add("LogConfig", (Object)this.logConfig()).add("AdditionalAuthenticationProviders", this.hasAdditionalAuthenticationProviders() ? this.additionalAuthenticationProviders() : null).add("WafWebAclArn", (Object)this.wafWebAclArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OpenIdConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.openIdConnectConfig()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LambdaAuthorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaAuthorizerConfig()));
            }
            case "XrayEnabled": {
                return Optional.ofNullable(clazz.cast(this.xrayEnabled()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "UserPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.userPoolConfig()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationType()));
            }
            case "LogConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
            case "AdditionalAuthenticationProviders": {
                return Optional.ofNullable(clazz.cast(this.additionalAuthenticationProviders()));
            }
            case "WafWebAclArn": {
                return Optional.ofNullable(clazz.cast(this.wafWebAclArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApiId", API_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("OpenIdConnectConfig", OPEN_ID_CONNECT_CONFIG_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("LambdaAuthorizerConfig", LAMBDA_AUTHORIZER_CONFIG_FIELD);
        map.put("XrayEnabled", XRAY_ENABLED_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("UserPoolConfig", USER_POOL_CONFIG_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("LogConfig", LOG_CONFIG_FIELD);
        map.put("AdditionalAuthenticationProviders", ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD);
        map.put("WafWebAclArn", WAF_WEB_ACL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAppSyncGraphQlApiDetails, T> g) {
        return obj -> g.apply((AwsAppSyncGraphQlApiDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String id;
        private AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig;
        private String name;
        private AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig;
        private Boolean xrayEnabled;
        private String arn;
        private AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig;
        private String authenticationType;
        private AwsAppSyncGraphQlApiLogConfigDetails logConfig;
        private List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders = DefaultSdkAutoConstructList.getInstance();
        private String wafWebAclArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAppSyncGraphQlApiDetails model) {
            this.apiId(model.apiId);
            this.id(model.id);
            this.openIdConnectConfig(model.openIdConnectConfig);
            this.name(model.name);
            this.lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
            this.xrayEnabled(model.xrayEnabled);
            this.arn(model.arn);
            this.userPoolConfig(model.userPoolConfig);
            this.authenticationType(model.authenticationType);
            this.logConfig(model.logConfig);
            this.additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            this.wafWebAclArn(model.wafWebAclArn);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder getOpenIdConnectConfig() {
            return this.openIdConnectConfig != null ? this.openIdConnectConfig.toBuilder() : null;
        }

        public final void setOpenIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.BuilderImpl openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig != null ? openIdConnectConfig.build() : null;
        }

        @Override
        public final Builder openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        public final Boolean getXrayEnabled() {
            return this.xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder getUserPoolConfig() {
            return this.userPoolConfig != null ? this.userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public final Builder userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public final AwsAppSyncGraphQlApiLogConfigDetails.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        public final void setLogConfig(AwsAppSyncGraphQlApiLogConfigDetails.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(AwsAppSyncGraphQlApiLogConfigDetails logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder> getAdditionalAuthenticationProviders() {
            List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder> result = AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier.copyToBuilder(this.additionalAuthenticationProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAuthenticationProviders(Collection<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier.copyFromBuilder(additionalAuthenticationProviders);
        }

        @Override
        public final Builder additionalAuthenticationProviders(Collection<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier.copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails ... additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(Consumer<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder> ... additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders).map(c -> (AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails)((AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder)AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWafWebAclArn() {
            return this.wafWebAclArn;
        }

        public final void setWafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
        }

        @Override
        public final Builder wafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
            return this;
        }

        public AwsAppSyncGraphQlApiDetails build() {
            return new AwsAppSyncGraphQlApiDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAppSyncGraphQlApiDetails> {
        public Builder apiId(String var1);

        public Builder id(String var1);

        public Builder openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails var1);

        default public Builder openIdConnectConfig(Consumer<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder> openIdConnectConfig) {
            return this.openIdConnectConfig((AwsAppSyncGraphQlApiOpenIdConnectConfigDetails)((AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder)AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.builder().applyMutation(openIdConnectConfig)).build());
        }

        public Builder name(String var1);

        public Builder lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails var1);

        default public Builder lambdaAuthorizerConfig(Consumer<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder> lambdaAuthorizerConfig) {
            return this.lambdaAuthorizerConfig((AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails)((AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder)AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.builder().applyMutation(lambdaAuthorizerConfig)).build());
        }

        public Builder xrayEnabled(Boolean var1);

        public Builder arn(String var1);

        public Builder userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails var1);

        default public Builder userPoolConfig(Consumer<AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder> userPoolConfig) {
            return this.userPoolConfig((AwsAppSyncGraphQlApiUserPoolConfigDetails)((AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder)AwsAppSyncGraphQlApiUserPoolConfigDetails.builder().applyMutation(userPoolConfig)).build());
        }

        public Builder authenticationType(String var1);

        public Builder logConfig(AwsAppSyncGraphQlApiLogConfigDetails var1);

        default public Builder logConfig(Consumer<AwsAppSyncGraphQlApiLogConfigDetails.Builder> logConfig) {
            return this.logConfig((AwsAppSyncGraphQlApiLogConfigDetails)((AwsAppSyncGraphQlApiLogConfigDetails.Builder)AwsAppSyncGraphQlApiLogConfigDetails.builder().applyMutation(logConfig)).build());
        }

        public Builder additionalAuthenticationProviders(Collection<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> var1);

        public Builder additionalAuthenticationProviders(AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails ... var1);

        public Builder additionalAuthenticationProviders(Consumer<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder> ... var1);

        public Builder wafWebAclArn(String var1);
    }
}

