/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VolumeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VolumeDetails> {
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateTime").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::createTime)).setter(AwsEc2VolumeDetails.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::deviceName)).setter(AwsEc2VolumeDetails.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::encrypted)).setter(AwsEc2VolumeDetails.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::size)).setter(AwsEc2VolumeDetails.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::snapshotId)).setter(AwsEc2VolumeDetails.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::status)).setter(AwsEc2VolumeDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::kmsKeyId)).setter(AwsEc2VolumeDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<AwsEc2VolumeAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::attachments)).setter(AwsEc2VolumeDetails.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2VolumeAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::volumeId)).setter(AwsEc2VolumeDetails.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::volumeType)).setter(AwsEc2VolumeDetails.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<String> VOLUME_SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeScanStatus").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::volumeScanStatus)).setter(AwsEc2VolumeDetails.setter(Builder::volumeScanStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeScanStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, DEVICE_NAME_FIELD, ENCRYPTED_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, STATUS_FIELD, KMS_KEY_ID_FIELD, ATTACHMENTS_FIELD, VOLUME_ID_FIELD, VOLUME_TYPE_FIELD, VOLUME_SCAN_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEc2VolumeDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String createTime;
    private final String deviceName;
    private final Boolean encrypted;
    private final Integer size;
    private final String snapshotId;
    private final String status;
    private final String kmsKeyId;
    private final List<AwsEc2VolumeAttachment> attachments;
    private final String volumeId;
    private final String volumeType;
    private final String volumeScanStatus;

    private AwsEc2VolumeDetails(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.deviceName = builder.deviceName;
        this.encrypted = builder.encrypted;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.attachments = builder.attachments;
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.volumeScanStatus = builder.volumeScanStatus;
    }

    public final String createTime() {
        return this.createTime;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final Integer size() {
        return this.size;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String status() {
        return this.status;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2VolumeAttachment> attachments() {
        return this.attachments;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final String volumeType() {
        return this.volumeType;
    }

    public final String volumeScanStatus() {
        return this.volumeScanStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeScanStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VolumeDetails)) {
            return false;
        }
        AwsEc2VolumeDetails other = (AwsEc2VolumeDetails)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.volumeScanStatus(), other.volumeScanStatus());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VolumeDetails").add("CreateTime", (Object)this.createTime()).add("DeviceName", (Object)this.deviceName()).add("Encrypted", (Object)this.encrypted()).add("Size", (Object)this.size()).add("SnapshotId", (Object)this.snapshotId()).add("Status", (Object)this.status()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("VolumeId", (Object)this.volumeId()).add("VolumeType", (Object)this.volumeType()).add("VolumeScanStatus", (Object)this.volumeScanStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "VolumeScanStatus": {
                return Optional.ofNullable(clazz.cast(this.volumeScanStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("VolumeScanStatus", VOLUME_SCAN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VolumeDetails, T> g) {
        return obj -> g.apply((AwsEc2VolumeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createTime;
        private String deviceName;
        private Boolean encrypted;
        private Integer size;
        private String snapshotId;
        private String status;
        private String kmsKeyId;
        private List<AwsEc2VolumeAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String volumeId;
        private String volumeType;
        private String volumeScanStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VolumeDetails model) {
            this.createTime(model.createTime);
            this.deviceName(model.deviceName);
            this.encrypted(model.encrypted);
            this.size(model.size);
            this.snapshotId(model.snapshotId);
            this.status(model.status);
            this.kmsKeyId(model.kmsKeyId);
            this.attachments(model.attachments);
            this.volumeId(model.volumeId);
            this.volumeType(model.volumeType);
            this.volumeScanStatus(model.volumeScanStatus);
        }

        public final String getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<AwsEc2VolumeAttachment.Builder> getAttachments() {
            List<AwsEc2VolumeAttachment.Builder> result = AwsEc2VolumeAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AwsEc2VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AwsEc2VolumeAttachment> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AwsEc2VolumeAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AwsEc2VolumeAttachment)((AwsEc2VolumeAttachment.Builder)AwsEc2VolumeAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final String getVolumeScanStatus() {
            return this.volumeScanStatus;
        }

        public final void setVolumeScanStatus(String volumeScanStatus) {
            this.volumeScanStatus = volumeScanStatus;
        }

        @Override
        public final Builder volumeScanStatus(String volumeScanStatus) {
            this.volumeScanStatus = volumeScanStatus;
            return this;
        }

        public AwsEc2VolumeDetails build() {
            return new AwsEc2VolumeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VolumeDetails> {
        public Builder createTime(String var1);

        public Builder deviceName(String var1);

        public Builder encrypted(Boolean var1);

        public Builder size(Integer var1);

        public Builder snapshotId(String var1);

        public Builder status(String var1);

        public Builder kmsKeyId(String var1);

        public Builder attachments(Collection<AwsEc2VolumeAttachment> var1);

        public Builder attachments(AwsEc2VolumeAttachment ... var1);

        public Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder> ... var1);

        public Builder volumeId(String var1);

        public Builder volumeType(String var1);

        public Builder volumeScanStatus(String var1);
    }
}

