/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEfsAccessPointPosixUserDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEfsAccessPointPosixUserDetails> {
    private static final SdkField<String> GID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Gid").getter(AwsEfsAccessPointPosixUserDetails.getter(AwsEfsAccessPointPosixUserDetails::gid)).setter(AwsEfsAccessPointPosixUserDetails.setter(Builder::gid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()}).build();
    private static final SdkField<List<String>> SECONDARY_GIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondaryGids").getter(AwsEfsAccessPointPosixUserDetails.getter(AwsEfsAccessPointPosixUserDetails::secondaryGids)).setter(AwsEfsAccessPointPosixUserDetails.setter(Builder::secondaryGids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryGids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(AwsEfsAccessPointPosixUserDetails.getter(AwsEfsAccessPointPosixUserDetails::uid)).setter(AwsEfsAccessPointPosixUserDetails.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GID_FIELD, SECONDARY_GIDS_FIELD, UID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEfsAccessPointPosixUserDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gid;
    private final List<String> secondaryGids;
    private final String uid;

    private AwsEfsAccessPointPosixUserDetails(BuilderImpl builder) {
        this.gid = builder.gid;
        this.secondaryGids = builder.secondaryGids;
        this.uid = builder.uid;
    }

    public final String gid() {
        return this.gid;
    }

    public final boolean hasSecondaryGids() {
        return this.secondaryGids != null && !(this.secondaryGids instanceof SdkAutoConstructList);
    }

    public final List<String> secondaryGids() {
        return this.secondaryGids;
    }

    public final String uid() {
        return this.uid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryGids() ? this.secondaryGids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEfsAccessPointPosixUserDetails)) {
            return false;
        }
        AwsEfsAccessPointPosixUserDetails other = (AwsEfsAccessPointPosixUserDetails)obj;
        return Objects.equals(this.gid(), other.gid()) && this.hasSecondaryGids() == other.hasSecondaryGids() && Objects.equals(this.secondaryGids(), other.secondaryGids()) && Objects.equals(this.uid(), other.uid());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEfsAccessPointPosixUserDetails").add("Gid", (Object)this.gid()).add("SecondaryGids", this.hasSecondaryGids() ? this.secondaryGids() : null).add("Uid", (Object)this.uid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gid": {
                return Optional.ofNullable(clazz.cast(this.gid()));
            }
            case "SecondaryGids": {
                return Optional.ofNullable(clazz.cast(this.secondaryGids()));
            }
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Gid", GID_FIELD);
        map.put("SecondaryGids", SECONDARY_GIDS_FIELD);
        map.put("Uid", UID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEfsAccessPointPosixUserDetails, T> g) {
        return obj -> g.apply((AwsEfsAccessPointPosixUserDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gid;
        private List<String> secondaryGids = DefaultSdkAutoConstructList.getInstance();
        private String uid;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEfsAccessPointPosixUserDetails model) {
            this.gid(model.gid);
            this.secondaryGids(model.secondaryGids);
            this.uid(model.uid);
        }

        public final String getGid() {
            return this.gid;
        }

        public final void setGid(String gid) {
            this.gid = gid;
        }

        @Override
        public final Builder gid(String gid) {
            this.gid = gid;
            return this;
        }

        public final Collection<String> getSecondaryGids() {
            if (this.secondaryGids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.secondaryGids;
        }

        public final void setSecondaryGids(Collection<String> secondaryGids) {
            this.secondaryGids = NonEmptyStringListCopier.copy(secondaryGids);
        }

        @Override
        public final Builder secondaryGids(Collection<String> secondaryGids) {
            this.secondaryGids = NonEmptyStringListCopier.copy(secondaryGids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryGids(String ... secondaryGids) {
            this.secondaryGids(Arrays.asList(secondaryGids));
            return this;
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public AwsEfsAccessPointPosixUserDetails build() {
            return new AwsEfsAccessPointPosixUserDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEfsAccessPointPosixUserDetails> {
        public Builder gid(String var1);

        public Builder secondaryGids(Collection<String> var1);

        public Builder secondaryGids(String ... var1);

        public Builder uid(String var1);
    }
}

