/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.Policy;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationPolicyRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationPolicyRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateConfigurationPolicyRequest.getter(UpdateConfigurationPolicyRequest::identifier)).setter(UpdateConfigurationPolicyRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateConfigurationPolicyRequest.getter(UpdateConfigurationPolicyRequest::name)).setter(UpdateConfigurationPolicyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateConfigurationPolicyRequest.getter(UpdateConfigurationPolicyRequest::description)).setter(UpdateConfigurationPolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> UPDATED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedReason").getter(UpdateConfigurationPolicyRequest.getter(UpdateConfigurationPolicyRequest::updatedReason)).setter(UpdateConfigurationPolicyRequest.setter(Builder::updatedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedReason").build()}).build();
    private static final SdkField<Policy> CONFIGURATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationPolicy").getter(UpdateConfigurationPolicyRequest.getter(UpdateConfigurationPolicyRequest::configurationPolicy)).setter(UpdateConfigurationPolicyRequest.setter(Builder::configurationPolicy)).constructor(Policy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, UPDATED_REASON_FIELD, CONFIGURATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("UpdatedReason", UPDATED_REASON_FIELD);
            this.put("ConfigurationPolicy", CONFIGURATION_POLICY_FIELD);
        }
    });
    private final String identifier;
    private final String name;
    private final String description;
    private final String updatedReason;
    private final Policy configurationPolicy;

    private UpdateConfigurationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.description = builder.description;
        this.updatedReason = builder.updatedReason;
        this.configurationPolicy = builder.configurationPolicy;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String updatedReason() {
        return this.updatedReason;
    }

    public final Policy configurationPolicy() {
        return this.configurationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationPolicyRequest)) {
            return false;
        }
        UpdateConfigurationPolicyRequest other = (UpdateConfigurationPolicyRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updatedReason(), other.updatedReason()) && Objects.equals(this.configurationPolicy(), other.configurationPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfigurationPolicyRequest").add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("UpdatedReason", (Object)this.updatedReason()).add("ConfigurationPolicy", (Object)this.configurationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UpdatedReason": {
                return Optional.ofNullable(clazz.cast(this.updatedReason()));
            }
            case "ConfigurationPolicy": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationPolicyRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String name;
        private String description;
        private String updatedReason;
        private Policy configurationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationPolicyRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.name(model.name);
            this.description(model.description);
            this.updatedReason(model.updatedReason);
            this.configurationPolicy(model.configurationPolicy);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUpdatedReason() {
            return this.updatedReason;
        }

        public final void setUpdatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
        }

        @Override
        public final Builder updatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
            return this;
        }

        public final Policy.Builder getConfigurationPolicy() {
            return this.configurationPolicy != null ? this.configurationPolicy.toBuilder() : null;
        }

        public final void setConfigurationPolicy(Policy.BuilderImpl configurationPolicy) {
            this.configurationPolicy = configurationPolicy != null ? configurationPolicy.build() : null;
        }

        @Override
        public final Builder configurationPolicy(Policy configurationPolicy) {
            this.configurationPolicy = configurationPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationPolicyRequest build() {
            return new UpdateConfigurationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfigurationPolicyRequest> {
        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder updatedReason(String var1);

        public Builder configurationPolicy(Policy var1);

        default public Builder configurationPolicy(Consumer<Policy.Builder> configurationPolicy) {
            return this.configurationPolicy((Policy)((Policy.Builder)Policy.builder().applyMutation(configurationPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

