/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ParameterValue;
import software.amazon.awssdk.services.securityhub.model.ParameterValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterConfiguration> {
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(ParameterConfiguration.getter(ParameterConfiguration::valueTypeAsString)).setter(ParameterConfiguration.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<ParameterValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(ParameterConfiguration.getter(ParameterConfiguration::value)).setter(ParameterConfiguration.setter(Builder::value)).constructor(ParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_TYPE_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParameterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String valueType;
    private final ParameterValue value;

    private ParameterConfiguration(BuilderImpl builder) {
        this.valueType = builder.valueType;
        this.value = builder.value;
    }

    public final ParameterValueType valueType() {
        return ParameterValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final ParameterValue value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConfiguration)) {
            return false;
        }
        ParameterConfiguration other = (ParameterConfiguration)obj;
        return Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterConfiguration").add("ValueType", (Object)this.valueTypeAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterConfiguration, T> g) {
        return obj -> g.apply((ParameterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String valueType;
        private ParameterValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConfiguration model) {
            this.valueType(model.valueType);
            this.value(model.value);
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(ParameterValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final ParameterValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(ParameterValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(ParameterValue value) {
            this.value = value;
            return this;
        }

        public ParameterConfiguration build() {
            return new ParameterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterConfiguration> {
        public Builder valueType(String var1);

        public Builder valueType(ParameterValueType var1);

        public Builder value(ParameterValue var1);

        default public Builder value(Consumer<ParameterValue.Builder> value) {
            return this.value((ParameterValue)((ParameterValue.Builder)ParameterValue.builder().applyMutation(value)).build());
        }
    }
}

