/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation;
import software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2SubnetDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2SubnetDetails> {
    private static final SdkField<Boolean> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssignIpv6AddressOnCreation").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::assignIpv6AddressOnCreation)).setter(AwsEc2SubnetDetails.setter(Builder::assignIpv6AddressOnCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::availabilityZone)).setter(AwsEc2SubnetDetails.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::availabilityZoneId)).setter(AwsEc2SubnetDetails.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<Integer> AVAILABLE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableIpAddressCount").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::availableIpAddressCount)).setter(AwsEc2SubnetDetails.setter(Builder::availableIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableIpAddressCount").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::cidrBlock)).setter(AwsEc2SubnetDetails.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()}).build();
    private static final SdkField<Boolean> DEFAULT_FOR_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultForAz").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::defaultForAz)).setter(AwsEc2SubnetDetails.setter(Builder::defaultForAz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultForAz").build()}).build();
    private static final SdkField<Boolean> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MapPublicIpOnLaunch").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::mapPublicIpOnLaunch)).setter(AwsEc2SubnetDetails.setter(Builder::mapPublicIpOnLaunch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::ownerId)).setter(AwsEc2SubnetDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::state)).setter(AwsEc2SubnetDetails.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::subnetArn)).setter(AwsEc2SubnetDetails.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::subnetId)).setter(AwsEc2SubnetDetails.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::vpcId)).setter(AwsEc2SubnetDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<Ipv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrBlockAssociationSet").getter(AwsEc2SubnetDetails.getter(AwsEc2SubnetDetails::ipv6CidrBlockAssociationSet)).setter(AwsEc2SubnetDetails.setter(Builder::ipv6CidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABLE_IP_ADDRESS_COUNT_FIELD, CIDR_BLOCK_FIELD, DEFAULT_FOR_AZ_FIELD, MAP_PUBLIC_IP_ON_LAUNCH_FIELD, OWNER_ID_FIELD, STATE_FIELD, SUBNET_ARN_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssignIpv6AddressOnCreation", ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD);
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
            this.put("AvailableIpAddressCount", AVAILABLE_IP_ADDRESS_COUNT_FIELD);
            this.put("CidrBlock", CIDR_BLOCK_FIELD);
            this.put("DefaultForAz", DEFAULT_FOR_AZ_FIELD);
            this.put("MapPublicIpOnLaunch", MAP_PUBLIC_IP_ON_LAUNCH_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("State", STATE_FIELD);
            this.put("SubnetArn", SUBNET_ARN_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("Ipv6CidrBlockAssociationSet", IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean assignIpv6AddressOnCreation;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Integer availableIpAddressCount;
    private final String cidrBlock;
    private final Boolean defaultForAz;
    private final Boolean mapPublicIpOnLaunch;
    private final String ownerId;
    private final String state;
    private final String subnetArn;
    private final String subnetId;
    private final String vpcId;
    private final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private AwsEc2SubnetDetails(BuilderImpl builder) {
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.subnetArn = builder.subnetArn;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
    }

    public final Boolean assignIpv6AddressOnCreation() {
        return this.assignIpv6AddressOnCreation;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Integer availableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final Boolean defaultForAz() {
        return this.defaultForAz;
    }

    public final Boolean mapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String state() {
        return this.state;
    }

    public final String subnetArn() {
        return this.subnetArn;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasIpv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet != null && !(this.ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    public final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultForAz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SubnetDetails)) {
            return false;
        }
        AwsEc2SubnetDetails other = (AwsEc2SubnetDetails)obj;
        return Objects.equals(this.assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.availableIpAddressCount(), other.availableIpAddressCount()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.defaultForAz(), other.defaultForAz()) && Objects.equals(this.mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.subnetArn(), other.subnetArn()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet() && Objects.equals(this.ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2SubnetDetails").add("AssignIpv6AddressOnCreation", (Object)this.assignIpv6AddressOnCreation()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AvailableIpAddressCount", (Object)this.availableIpAddressCount()).add("CidrBlock", (Object)this.cidrBlock()).add("DefaultForAz", (Object)this.defaultForAz()).add("MapPublicIpOnLaunch", (Object)this.mapPublicIpOnLaunch()).add("OwnerId", (Object)this.ownerId()).add("State", (Object)this.state()).add("SubnetArn", (Object)this.subnetArn()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("Ipv6CidrBlockAssociationSet", this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignIpv6AddressOnCreation": {
                return Optional.ofNullable(clazz.cast(this.assignIpv6AddressOnCreation()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AvailableIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.availableIpAddressCount()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "DefaultForAz": {
                return Optional.ofNullable(clazz.cast(this.defaultForAz()));
            }
            case "MapPublicIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapPublicIpOnLaunch()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Ipv6CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociationSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SubnetDetails, T> g) {
        return obj -> g.apply((AwsEc2SubnetDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean assignIpv6AddressOnCreation;
        private String availabilityZone;
        private String availabilityZoneId;
        private Integer availableIpAddressCount;
        private String cidrBlock;
        private Boolean defaultForAz;
        private Boolean mapPublicIpOnLaunch;
        private String ownerId;
        private String state;
        private String subnetArn;
        private String subnetId;
        private String vpcId;
        private List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SubnetDetails model) {
            this.assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.availableIpAddressCount(model.availableIpAddressCount);
            this.cidrBlock(model.cidrBlock);
            this.defaultForAz(model.defaultForAz);
            this.mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            this.ownerId(model.ownerId);
            this.state(model.state);
            this.subnetArn(model.subnetArn);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Integer getAvailableIpAddressCount() {
            return this.availableIpAddressCount;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final Boolean getDefaultForAz() {
            return this.defaultForAz;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Ipv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<Ipv6CidrBlockAssociation.Builder> result = Ipv6CidrBlockAssociationListCopier.copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Consumer<Ipv6CidrBlockAssociation.Builder> ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet).map(c -> (Ipv6CidrBlockAssociation)((Ipv6CidrBlockAssociation.Builder)Ipv6CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEc2SubnetDetails build() {
            return new AwsEc2SubnetDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2SubnetDetails> {
        public Builder assignIpv6AddressOnCreation(Boolean var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder availableIpAddressCount(Integer var1);

        public Builder cidrBlock(String var1);

        public Builder defaultForAz(Boolean var1);

        public Builder mapPublicIpOnLaunch(Boolean var1);

        public Builder ownerId(String var1);

        public Builder state(String var1);

        public Builder subnetArn(String var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation ... var1);

        public Builder ipv6CidrBlockAssociationSet(Consumer<Ipv6CidrBlockAssociation.Builder> ... var1);
    }
}

