/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscription;

public class GetEnabledStandardsPublisher
implements SdkPublisher<GetEnabledStandardsResponse> {
    private final SecurityHubAsyncClient client;
    private final GetEnabledStandardsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEnabledStandardsPublisher(SecurityHubAsyncClient client, GetEnabledStandardsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEnabledStandardsPublisher(SecurityHubAsyncClient client, GetEnabledStandardsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEnabledStandardsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEnabledStandardsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StandardsSubscription> standardsSubscriptions() {
        Function<GetEnabledStandardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.standardsSubscriptions() != null) {
                return response.standardsSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetEnabledStandardsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetEnabledStandardsResponseFetcher
    implements AsyncPageFetcher<GetEnabledStandardsResponse> {
        private GetEnabledStandardsResponseFetcher() {
        }

        public boolean hasNextPage(GetEnabledStandardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEnabledStandardsResponse> nextPage(GetEnabledStandardsResponse previousPage) {
            if (previousPage == null) {
                return GetEnabledStandardsPublisher.this.client.getEnabledStandards(GetEnabledStandardsPublisher.this.firstRequest);
            }
            return GetEnabledStandardsPublisher.this.client.getEnabledStandards((GetEnabledStandardsRequest)((Object)GetEnabledStandardsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

