/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.NetworkAutonomousSystem;
import software.amazon.awssdk.services.securityhub.model.NetworkConnection;
import software.amazon.awssdk.services.securityhub.model.NetworkGeoLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(NetworkEndpoint.getter(NetworkEndpoint::id)).setter(NetworkEndpoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(NetworkEndpoint.getter(NetworkEndpoint::ip)).setter(NetworkEndpoint.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(NetworkEndpoint.getter(NetworkEndpoint::domain)).setter(NetworkEndpoint.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(NetworkEndpoint.getter(NetworkEndpoint::port)).setter(NetworkEndpoint.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<NetworkGeoLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(NetworkEndpoint.getter(NetworkEndpoint::location)).setter(NetworkEndpoint.setter(Builder::location)).constructor(NetworkGeoLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<NetworkAutonomousSystem> AUTONOMOUS_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutonomousSystem").getter(NetworkEndpoint.getter(NetworkEndpoint::autonomousSystem)).setter(NetworkEndpoint.setter(Builder::autonomousSystem)).constructor(NetworkAutonomousSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutonomousSystem").build()}).build();
    private static final SdkField<NetworkConnection> CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Connection").getter(NetworkEndpoint.getter(NetworkEndpoint::connection)).setter(NetworkEndpoint.setter(Builder::connection)).constructor(NetworkConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IP_FIELD, DOMAIN_FIELD, PORT_FIELD, LOCATION_FIELD, AUTONOMOUS_SYSTEM_FIELD, CONNECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Ip", IP_FIELD);
            this.put("Domain", DOMAIN_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("Location", LOCATION_FIELD);
            this.put("AutonomousSystem", AUTONOMOUS_SYSTEM_FIELD);
            this.put("Connection", CONNECTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String ip;
    private final String domain;
    private final Integer port;
    private final NetworkGeoLocation location;
    private final NetworkAutonomousSystem autonomousSystem;
    private final NetworkConnection connection;

    private NetworkEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.ip = builder.ip;
        this.domain = builder.domain;
        this.port = builder.port;
        this.location = builder.location;
        this.autonomousSystem = builder.autonomousSystem;
        this.connection = builder.connection;
    }

    public final String id() {
        return this.id;
    }

    public final String ip() {
        return this.ip;
    }

    public final String domain() {
        return this.domain;
    }

    public final Integer port() {
        return this.port;
    }

    public final NetworkGeoLocation location() {
        return this.location;
    }

    public final NetworkAutonomousSystem autonomousSystem() {
        return this.autonomousSystem;
    }

    public final NetworkConnection connection() {
        return this.connection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.autonomousSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.connection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkEndpoint)) {
            return false;
        }
        NetworkEndpoint other = (NetworkEndpoint)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ip(), other.ip()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.autonomousSystem(), other.autonomousSystem()) && Objects.equals(this.connection(), other.connection());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkEndpoint").add("Id", (Object)this.id()).add("Ip", (Object)this.ip()).add("Domain", (Object)this.domain()).add("Port", (Object)this.port()).add("Location", (Object)this.location()).add("AutonomousSystem", (Object)this.autonomousSystem()).add("Connection", (Object)this.connection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "AutonomousSystem": {
                return Optional.ofNullable(clazz.cast(this.autonomousSystem()));
            }
            case "Connection": {
                return Optional.ofNullable(clazz.cast(this.connection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkEndpoint, T> g) {
        return obj -> g.apply((NetworkEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String ip;
        private String domain;
        private Integer port;
        private NetworkGeoLocation location;
        private NetworkAutonomousSystem autonomousSystem;
        private NetworkConnection connection;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkEndpoint model) {
            this.id(model.id);
            this.ip(model.ip);
            this.domain(model.domain);
            this.port(model.port);
            this.location(model.location);
            this.autonomousSystem(model.autonomousSystem);
            this.connection(model.connection);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIp() {
            return this.ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final NetworkGeoLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(NetworkGeoLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(NetworkGeoLocation location) {
            this.location = location;
            return this;
        }

        public final NetworkAutonomousSystem.Builder getAutonomousSystem() {
            return this.autonomousSystem != null ? this.autonomousSystem.toBuilder() : null;
        }

        public final void setAutonomousSystem(NetworkAutonomousSystem.BuilderImpl autonomousSystem) {
            this.autonomousSystem = autonomousSystem != null ? autonomousSystem.build() : null;
        }

        @Override
        public final Builder autonomousSystem(NetworkAutonomousSystem autonomousSystem) {
            this.autonomousSystem = autonomousSystem;
            return this;
        }

        public final NetworkConnection.Builder getConnection() {
            return this.connection != null ? this.connection.toBuilder() : null;
        }

        public final void setConnection(NetworkConnection.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(NetworkConnection connection) {
            this.connection = connection;
            return this;
        }

        public NetworkEndpoint build() {
            return new NetworkEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkEndpoint> {
        public Builder id(String var1);

        public Builder ip(String var1);

        public Builder domain(String var1);

        public Builder port(Integer var1);

        public Builder location(NetworkGeoLocation var1);

        default public Builder location(Consumer<NetworkGeoLocation.Builder> location) {
            return this.location((NetworkGeoLocation)((NetworkGeoLocation.Builder)NetworkGeoLocation.builder().applyMutation(location)).build());
        }

        public Builder autonomousSystem(NetworkAutonomousSystem var1);

        default public Builder autonomousSystem(Consumer<NetworkAutonomousSystem.Builder> autonomousSystem) {
            return this.autonomousSystem((NetworkAutonomousSystem)((NetworkAutonomousSystem.Builder)NetworkAutonomousSystem.builder().applyMutation(autonomousSystem)).build());
        }

        public Builder connection(NetworkConnection var1);

        default public Builder connection(Consumer<NetworkConnection.Builder> connection) {
            return this.connection((NetworkConnection)((NetworkConnection.Builder)NetworkConnection.builder().applyMutation(connection)).build());
        }
    }
}

