/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationId;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetStandardsControlAssociationsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchGetStandardsControlAssociationsRequest> {
    private static final SdkField<List<StandardsControlAssociationId>> STANDARDS_CONTROL_ASSOCIATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsControlAssociationIds").getter(BatchGetStandardsControlAssociationsRequest.getter(BatchGetStandardsControlAssociationsRequest::standardsControlAssociationIds)).setter(BatchGetStandardsControlAssociationsRequest.setter(Builder::standardsControlAssociationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandardsControlAssociationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ASSOCIATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StandardsControlAssociationIds", STANDARDS_CONTROL_ASSOCIATION_IDS_FIELD);
        }
    });
    private final List<StandardsControlAssociationId> standardsControlAssociationIds;

    private BatchGetStandardsControlAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.standardsControlAssociationIds = builder.standardsControlAssociationIds;
    }

    public final boolean hasStandardsControlAssociationIds() {
        return this.standardsControlAssociationIds != null && !(this.standardsControlAssociationIds instanceof SdkAutoConstructList);
    }

    public final List<StandardsControlAssociationId> standardsControlAssociationIds() {
        return this.standardsControlAssociationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsControlAssociationIds() ? this.standardsControlAssociationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStandardsControlAssociationsRequest)) {
            return false;
        }
        BatchGetStandardsControlAssociationsRequest other = (BatchGetStandardsControlAssociationsRequest)((Object)obj);
        return this.hasStandardsControlAssociationIds() == other.hasStandardsControlAssociationIds() && Objects.equals(this.standardsControlAssociationIds(), other.standardsControlAssociationIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetStandardsControlAssociationsRequest").add("StandardsControlAssociationIds", this.hasStandardsControlAssociationIds() ? this.standardsControlAssociationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlAssociationIds": {
                return Optional.ofNullable(clazz.cast(this.standardsControlAssociationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStandardsControlAssociationsRequest, T> g) {
        return obj -> g.apply((BatchGetStandardsControlAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<StandardsControlAssociationId> standardsControlAssociationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStandardsControlAssociationsRequest model) {
            super(model);
            this.standardsControlAssociationIds(model.standardsControlAssociationIds);
        }

        public final List<StandardsControlAssociationId.Builder> getStandardsControlAssociationIds() {
            List<StandardsControlAssociationId.Builder> result = StandardsControlAssociationIdsCopier.copyToBuilder(this.standardsControlAssociationIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandardsControlAssociationIds(Collection<StandardsControlAssociationId.BuilderImpl> standardsControlAssociationIds) {
            this.standardsControlAssociationIds = StandardsControlAssociationIdsCopier.copyFromBuilder(standardsControlAssociationIds);
        }

        @Override
        public final Builder standardsControlAssociationIds(Collection<StandardsControlAssociationId> standardsControlAssociationIds) {
            this.standardsControlAssociationIds = StandardsControlAssociationIdsCopier.copy(standardsControlAssociationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationIds(StandardsControlAssociationId ... standardsControlAssociationIds) {
            this.standardsControlAssociationIds(Arrays.asList(standardsControlAssociationIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationIds(Consumer<StandardsControlAssociationId.Builder> ... standardsControlAssociationIds) {
            this.standardsControlAssociationIds(Stream.of(standardsControlAssociationIds).map(c -> (StandardsControlAssociationId)((StandardsControlAssociationId.Builder)StandardsControlAssociationId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetStandardsControlAssociationsRequest build() {
            return new BatchGetStandardsControlAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetStandardsControlAssociationsRequest> {
        public Builder standardsControlAssociationIds(Collection<StandardsControlAssociationId> var1);

        public Builder standardsControlAssociationIds(StandardsControlAssociationId ... var1);

        public Builder standardsControlAssociationIds(Consumer<StandardsControlAssociationId.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

