/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AvailabilityZone;
import software.amazon.awssdk.services.securityhub.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttribute;
import software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerAttributesCopier;
import software.amazon.awssdk.services.securityhub.model.LoadBalancerState;
import software.amazon.awssdk.services.securityhub.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbv2LoadBalancerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbv2LoadBalancerDetails> {
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::availabilityZones)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CANONICAL_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanonicalHostedZoneId").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::canonicalHostedZoneId)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::canonicalHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneId").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::createdTime)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::dnsName)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::ipAddressType)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scheme").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::scheme)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::securityGroups)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LoadBalancerState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::state)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::state)).constructor(LoadBalancerState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::type)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::vpcId)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<AwsElbv2LoadBalancerAttribute>> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerAttributes").getter(AwsElbv2LoadBalancerDetails.getter(AwsElbv2LoadBalancerDetails::loadBalancerAttributes)).setter(AwsElbv2LoadBalancerDetails.setter(Builder::loadBalancerAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbv2LoadBalancerAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, CANONICAL_HOSTED_ZONE_ID_FIELD, CREATED_TIME_FIELD, DNS_NAME_FIELD, IP_ADDRESS_TYPE_FIELD, SCHEME_FIELD, SECURITY_GROUPS_FIELD, STATE_FIELD, TYPE_FIELD, VPC_ID_FIELD, LOAD_BALANCER_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
            this.put("CanonicalHostedZoneId", CANONICAL_HOSTED_ZONE_ID_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("DNSName", DNS_NAME_FIELD);
            this.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
            this.put("Scheme", SCHEME_FIELD);
            this.put("SecurityGroups", SECURITY_GROUPS_FIELD);
            this.put("State", STATE_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("LoadBalancerAttributes", LOAD_BALANCER_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AvailabilityZone> availabilityZones;
    private final String canonicalHostedZoneId;
    private final String createdTime;
    private final String dnsName;
    private final String ipAddressType;
    private final String scheme;
    private final List<String> securityGroups;
    private final LoadBalancerState state;
    private final String type;
    private final String vpcId;
    private final List<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes;

    private AwsElbv2LoadBalancerDetails(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.canonicalHostedZoneId = builder.canonicalHostedZoneId;
        this.createdTime = builder.createdTime;
        this.dnsName = builder.dnsName;
        this.ipAddressType = builder.ipAddressType;
        this.scheme = builder.scheme;
        this.securityGroups = builder.securityGroups;
        this.state = builder.state;
        this.type = builder.type;
        this.vpcId = builder.vpcId;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public final String canonicalHostedZoneId() {
        return this.canonicalHostedZoneId;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String ipAddressType() {
        return this.ipAddressType;
    }

    public final String scheme() {
        return this.scheme;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final LoadBalancerState state() {
        return this.state;
    }

    public final String type() {
        return this.type;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasLoadBalancerAttributes() {
        return this.loadBalancerAttributes != null && !(this.loadBalancerAttributes instanceof SdkAutoConstructList);
    }

    public final List<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes() {
        return this.loadBalancerAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerAttributes() ? this.loadBalancerAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbv2LoadBalancerDetails)) {
            return false;
        }
        AwsElbv2LoadBalancerDetails other = (AwsElbv2LoadBalancerDetails)obj;
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.canonicalHostedZoneId(), other.canonicalHostedZoneId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.ipAddressType(), other.ipAddressType()) && Objects.equals(this.scheme(), other.scheme()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasLoadBalancerAttributes() == other.hasLoadBalancerAttributes() && Objects.equals(this.loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbv2LoadBalancerDetails").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("CanonicalHostedZoneId", (Object)this.canonicalHostedZoneId()).add("CreatedTime", (Object)this.createdTime()).add("DNSName", (Object)this.dnsName()).add("IpAddressType", (Object)this.ipAddressType()).add("Scheme", (Object)this.scheme()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("State", (Object)this.state()).add("Type", (Object)this.type()).add("VpcId", (Object)this.vpcId()).add("LoadBalancerAttributes", this.hasLoadBalancerAttributes() ? this.loadBalancerAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "CanonicalHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressType()));
            }
            case "Scheme": {
                return Optional.ofNullable(clazz.cast(this.scheme()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "LoadBalancerAttributes": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbv2LoadBalancerDetails, T> g) {
        return obj -> g.apply((AwsElbv2LoadBalancerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String canonicalHostedZoneId;
        private String createdTime;
        private String dnsName;
        private String ipAddressType;
        private String scheme;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private LoadBalancerState state;
        private String type;
        private String vpcId;
        private List<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbv2LoadBalancerDetails model) {
            this.availabilityZones(model.availabilityZones);
            this.canonicalHostedZoneId(model.canonicalHostedZoneId);
            this.createdTime(model.createdTime);
            this.dnsName(model.dnsName);
            this.ipAddressType(model.ipAddressType);
            this.scheme(model.scheme);
            this.securityGroups(model.securityGroups);
            this.state(model.state);
            this.type(model.type);
            this.vpcId(model.vpcId);
            this.loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZonesCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCanonicalHostedZoneId() {
            return this.canonicalHostedZoneId;
        }

        public final void setCanonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
        }

        @Override
        public final Builder canonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final LoadBalancerState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(LoadBalancerState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state = state;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<AwsElbv2LoadBalancerAttribute.Builder> getLoadBalancerAttributes() {
            List<AwsElbv2LoadBalancerAttribute.Builder> result = AwsElbv2LoadBalancerAttributesCopier.copyToBuilder(this.loadBalancerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerAttributes(Collection<AwsElbv2LoadBalancerAttribute.BuilderImpl> loadBalancerAttributes) {
            this.loadBalancerAttributes = AwsElbv2LoadBalancerAttributesCopier.copyFromBuilder(loadBalancerAttributes);
        }

        @Override
        public final Builder loadBalancerAttributes(Collection<AwsElbv2LoadBalancerAttribute> loadBalancerAttributes) {
            this.loadBalancerAttributes = AwsElbv2LoadBalancerAttributesCopier.copy(loadBalancerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAttributes(AwsElbv2LoadBalancerAttribute ... loadBalancerAttributes) {
            this.loadBalancerAttributes(Arrays.asList(loadBalancerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAttributes(Consumer<AwsElbv2LoadBalancerAttribute.Builder> ... loadBalancerAttributes) {
            this.loadBalancerAttributes(Stream.of(loadBalancerAttributes).map(c -> (AwsElbv2LoadBalancerAttribute)((AwsElbv2LoadBalancerAttribute.Builder)AwsElbv2LoadBalancerAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsElbv2LoadBalancerDetails build() {
            return new AwsElbv2LoadBalancerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbv2LoadBalancerDetails> {
        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder canonicalHostedZoneId(String var1);

        public Builder createdTime(String var1);

        public Builder dnsName(String var1);

        public Builder ipAddressType(String var1);

        public Builder scheme(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder state(LoadBalancerState var1);

        default public Builder state(Consumer<LoadBalancerState.Builder> state) {
            return this.state((LoadBalancerState)((LoadBalancerState.Builder)LoadBalancerState.builder().applyMutation(state)).build());
        }

        public Builder type(String var1);

        public Builder vpcId(String var1);

        public Builder loadBalancerAttributes(Collection<AwsElbv2LoadBalancerAttribute> var1);

        public Builder loadBalancerAttributes(AwsElbv2LoadBalancerAttribute ... var1);

        public Builder loadBalancerAttributes(Consumer<AwsElbv2LoadBalancerAttribute.Builder> ... var1);
    }
}

