/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOptionsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsagesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsage;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsagesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateOptions;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCertificateManagerCertificateDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCertificateManagerCertificateDetails> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::certificateAuthorityArn)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::createdAt)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::domainName)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<AwsCertificateManagerCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainValidationOptions").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::domainValidationOptions)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCertificateManagerCertificateDomainValidationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsCertificateManagerCertificateExtendedKeyUsage>> EXTENDED_KEY_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExtendedKeyUsages").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::extendedKeyUsages)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::extendedKeyUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCertificateManagerCertificateExtendedKeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::failureReason)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> IMPORTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportedAt").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::importedAt)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::importedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedAt").build()}).build();
    private static final SdkField<List<String>> IN_USE_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InUseBy").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::inUseBy)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::inUseBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssuedAt").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::issuedAt)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::issuer)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::keyAlgorithm)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<List<AwsCertificateManagerCertificateKeyUsage>> KEY_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyUsages").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::keyUsages)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::keyUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCertificateManagerCertificateKeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotAfter").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::notAfter)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").build()}).build();
    private static final SdkField<String> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotBefore").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::notBefore)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").build()}).build();
    private static final SdkField<AwsCertificateManagerCertificateOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::options)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::options)).constructor(AwsCertificateManagerCertificateOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<String> RENEWAL_ELIGIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalEligibility").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::renewalEligibility)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::renewalEligibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalEligibility").build()}).build();
    private static final SdkField<AwsCertificateManagerCertificateRenewalSummary> RENEWAL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenewalSummary").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::renewalSummary)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::renewalSummary)).constructor(AwsCertificateManagerCertificateRenewalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalSummary").build()}).build();
    private static final SdkField<String> SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Serial").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::serial)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::serial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serial").build()}).build();
    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignatureAlgorithm").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::signatureAlgorithm)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::signatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignatureAlgorithm").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::status)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::subject)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubjectAlternativeNames").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::subjectAlternativeNames)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::subjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AwsCertificateManagerCertificateDetails.getter(AwsCertificateManagerCertificateDetails::type)).setter(AwsCertificateManagerCertificateDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, CREATED_AT_FIELD, DOMAIN_NAME_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD, EXTENDED_KEY_USAGES_FIELD, FAILURE_REASON_FIELD, IMPORTED_AT_FIELD, IN_USE_BY_FIELD, ISSUED_AT_FIELD, ISSUER_FIELD, KEY_ALGORITHM_FIELD, KEY_USAGES_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, OPTIONS_FIELD, RENEWAL_ELIGIBILITY_FIELD, RENEWAL_SUMMARY_FIELD, SERIAL_FIELD, SIGNATURE_ALGORITHM_FIELD, STATUS_FIELD, SUBJECT_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("DomainValidationOptions", DOMAIN_VALIDATION_OPTIONS_FIELD);
            this.put("ExtendedKeyUsages", EXTENDED_KEY_USAGES_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("ImportedAt", IMPORTED_AT_FIELD);
            this.put("InUseBy", IN_USE_BY_FIELD);
            this.put("IssuedAt", ISSUED_AT_FIELD);
            this.put("Issuer", ISSUER_FIELD);
            this.put("KeyAlgorithm", KEY_ALGORITHM_FIELD);
            this.put("KeyUsages", KEY_USAGES_FIELD);
            this.put("NotAfter", NOT_AFTER_FIELD);
            this.put("NotBefore", NOT_BEFORE_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("RenewalEligibility", RENEWAL_ELIGIBILITY_FIELD);
            this.put("RenewalSummary", RENEWAL_SUMMARY_FIELD);
            this.put("Serial", SERIAL_FIELD);
            this.put("SignatureAlgorithm", SIGNATURE_ALGORITHM_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Subject", SUBJECT_FIELD);
            this.put("SubjectAlternativeNames", SUBJECT_ALTERNATIVE_NAMES_FIELD);
            this.put("Type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityArn;
    private final String createdAt;
    private final String domainName;
    private final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions;
    private final List<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages;
    private final String failureReason;
    private final String importedAt;
    private final List<String> inUseBy;
    private final String issuedAt;
    private final String issuer;
    private final String keyAlgorithm;
    private final List<AwsCertificateManagerCertificateKeyUsage> keyUsages;
    private final String notAfter;
    private final String notBefore;
    private final AwsCertificateManagerCertificateOptions options;
    private final String renewalEligibility;
    private final AwsCertificateManagerCertificateRenewalSummary renewalSummary;
    private final String serial;
    private final String signatureAlgorithm;
    private final String status;
    private final String subject;
    private final List<String> subjectAlternativeNames;
    private final String type;

    private AwsCertificateManagerCertificateDetails(BuilderImpl builder) {
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.createdAt = builder.createdAt;
        this.domainName = builder.domainName;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.extendedKeyUsages = builder.extendedKeyUsages;
        this.failureReason = builder.failureReason;
        this.importedAt = builder.importedAt;
        this.inUseBy = builder.inUseBy;
        this.issuedAt = builder.issuedAt;
        this.issuer = builder.issuer;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyUsages = builder.keyUsages;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.options = builder.options;
        this.renewalEligibility = builder.renewalEligibility;
        this.renewalSummary = builder.renewalSummary;
        this.serial = builder.serial;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.status = builder.status;
        this.subject = builder.subject;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.type = builder.type;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasDomainValidationOptions() {
        return this.domainValidationOptions != null && !(this.domainValidationOptions instanceof SdkAutoConstructList);
    }

    public final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public final boolean hasExtendedKeyUsages() {
        return this.extendedKeyUsages != null && !(this.extendedKeyUsages instanceof SdkAutoConstructList);
    }

    public final List<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages() {
        return this.extendedKeyUsages;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String importedAt() {
        return this.importedAt;
    }

    public final boolean hasInUseBy() {
        return this.inUseBy != null && !(this.inUseBy instanceof SdkAutoConstructList);
    }

    public final List<String> inUseBy() {
        return this.inUseBy;
    }

    public final String issuedAt() {
        return this.issuedAt;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String keyAlgorithm() {
        return this.keyAlgorithm;
    }

    public final boolean hasKeyUsages() {
        return this.keyUsages != null && !(this.keyUsages instanceof SdkAutoConstructList);
    }

    public final List<AwsCertificateManagerCertificateKeyUsage> keyUsages() {
        return this.keyUsages;
    }

    public final String notAfter() {
        return this.notAfter;
    }

    public final String notBefore() {
        return this.notBefore;
    }

    public final AwsCertificateManagerCertificateOptions options() {
        return this.options;
    }

    public final String renewalEligibility() {
        return this.renewalEligibility;
    }

    public final AwsCertificateManagerCertificateRenewalSummary renewalSummary() {
        return this.renewalSummary;
    }

    public final String serial() {
        return this.serial;
    }

    public final String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final String status() {
        return this.status;
    }

    public final String subject() {
        return this.subject;
    }

    public final boolean hasSubjectAlternativeNames() {
        return this.subjectAlternativeNames != null && !(this.subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    public final List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationOptions() ? this.domainValidationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendedKeyUsages() ? this.extendedKeyUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInUseBy() ? this.inUseBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyUsages() ? this.keyUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalEligibility());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.serial());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateDetails)) {
            return false;
        }
        AwsCertificateManagerCertificateDetails other = (AwsCertificateManagerCertificateDetails)obj;
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.domainName(), other.domainName()) && this.hasDomainValidationOptions() == other.hasDomainValidationOptions() && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions()) && this.hasExtendedKeyUsages() == other.hasExtendedKeyUsages() && Objects.equals(this.extendedKeyUsages(), other.extendedKeyUsages()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.importedAt(), other.importedAt()) && this.hasInUseBy() == other.hasInUseBy() && Objects.equals(this.inUseBy(), other.inUseBy()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.keyAlgorithm(), other.keyAlgorithm()) && this.hasKeyUsages() == other.hasKeyUsages() && Objects.equals(this.keyUsages(), other.keyUsages()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.renewalEligibility(), other.renewalEligibility()) && Objects.equals(this.renewalSummary(), other.renewalSummary()) && Objects.equals(this.serial(), other.serial()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.subject(), other.subject()) && this.hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames() && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCertificateManagerCertificateDetails").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("CreatedAt", (Object)this.createdAt()).add("DomainName", (Object)this.domainName()).add("DomainValidationOptions", this.hasDomainValidationOptions() ? this.domainValidationOptions() : null).add("ExtendedKeyUsages", this.hasExtendedKeyUsages() ? this.extendedKeyUsages() : null).add("FailureReason", (Object)this.failureReason()).add("ImportedAt", (Object)this.importedAt()).add("InUseBy", this.hasInUseBy() ? this.inUseBy() : null).add("IssuedAt", (Object)this.issuedAt()).add("Issuer", (Object)this.issuer()).add("KeyAlgorithm", (Object)this.keyAlgorithm()).add("KeyUsages", this.hasKeyUsages() ? this.keyUsages() : null).add("NotAfter", (Object)this.notAfter()).add("NotBefore", (Object)this.notBefore()).add("Options", (Object)this.options()).add("RenewalEligibility", (Object)this.renewalEligibility()).add("RenewalSummary", (Object)this.renewalSummary()).add("Serial", (Object)this.serial()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).add("Status", (Object)this.status()).add("Subject", (Object)this.subject()).add("SubjectAlternativeNames", this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
            case "ExtendedKeyUsages": {
                return Optional.ofNullable(clazz.cast(this.extendedKeyUsages()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ImportedAt": {
                return Optional.ofNullable(clazz.cast(this.importedAt()));
            }
            case "InUseBy": {
                return Optional.ofNullable(clazz.cast(this.inUseBy()));
            }
            case "IssuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithm()));
            }
            case "KeyUsages": {
                return Optional.ofNullable(clazz.cast(this.keyUsages()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "RenewalEligibility": {
                return Optional.ofNullable(clazz.cast(this.renewalEligibility()));
            }
            case "RenewalSummary": {
                return Optional.ofNullable(clazz.cast(this.renewalSummary()));
            }
            case "Serial": {
                return Optional.ofNullable(clazz.cast(this.serial()));
            }
            case "SignatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signatureAlgorithm()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "SubjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateDetails, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private String createdAt;
        private String domainName;
        private List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();
        private List<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages = DefaultSdkAutoConstructList.getInstance();
        private String failureReason;
        private String importedAt;
        private List<String> inUseBy = DefaultSdkAutoConstructList.getInstance();
        private String issuedAt;
        private String issuer;
        private String keyAlgorithm;
        private List<AwsCertificateManagerCertificateKeyUsage> keyUsages = DefaultSdkAutoConstructList.getInstance();
        private String notAfter;
        private String notBefore;
        private AwsCertificateManagerCertificateOptions options;
        private String renewalEligibility;
        private AwsCertificateManagerCertificateRenewalSummary renewalSummary;
        private String serial;
        private String signatureAlgorithm;
        private String status;
        private String subject;
        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateDetails model) {
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.createdAt(model.createdAt);
            this.domainName(model.domainName);
            this.domainValidationOptions(model.domainValidationOptions);
            this.extendedKeyUsages(model.extendedKeyUsages);
            this.failureReason(model.failureReason);
            this.importedAt(model.importedAt);
            this.inUseBy(model.inUseBy);
            this.issuedAt(model.issuedAt);
            this.issuer(model.issuer);
            this.keyAlgorithm(model.keyAlgorithm);
            this.keyUsages(model.keyUsages);
            this.notAfter(model.notAfter);
            this.notBefore(model.notBefore);
            this.options(model.options);
            this.renewalEligibility(model.renewalEligibility);
            this.renewalSummary(model.renewalSummary);
            this.serial(model.serial);
            this.signatureAlgorithm(model.signatureAlgorithm);
            this.status(model.status);
            this.subject(model.subject);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.type(model.type);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<AwsCertificateManagerCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            List<AwsCertificateManagerCertificateDomainValidationOption.Builder> result = AwsCertificateManagerCertificateDomainValidationOptionsCopier.copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier.copyFromBuilder(domainValidationOptions);
        }

        @Override
        public final Builder domainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(AwsCertificateManagerCertificateDomainValidationOption ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (AwsCertificateManagerCertificateDomainValidationOption)((AwsCertificateManagerCertificateDomainValidationOption.Builder)AwsCertificateManagerCertificateDomainValidationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsCertificateManagerCertificateExtendedKeyUsage.Builder> getExtendedKeyUsages() {
            List<AwsCertificateManagerCertificateExtendedKeyUsage.Builder> result = AwsCertificateManagerCertificateExtendedKeyUsagesCopier.copyToBuilder(this.extendedKeyUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtendedKeyUsages(Collection<AwsCertificateManagerCertificateExtendedKeyUsage.BuilderImpl> extendedKeyUsages) {
            this.extendedKeyUsages = AwsCertificateManagerCertificateExtendedKeyUsagesCopier.copyFromBuilder(extendedKeyUsages);
        }

        @Override
        public final Builder extendedKeyUsages(Collection<AwsCertificateManagerCertificateExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = AwsCertificateManagerCertificateExtendedKeyUsagesCopier.copy(extendedKeyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsages(AwsCertificateManagerCertificateExtendedKeyUsage ... extendedKeyUsages) {
            this.extendedKeyUsages(Arrays.asList(extendedKeyUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsages(Consumer<AwsCertificateManagerCertificateExtendedKeyUsage.Builder> ... extendedKeyUsages) {
            this.extendedKeyUsages(Stream.of(extendedKeyUsages).map(c -> (AwsCertificateManagerCertificateExtendedKeyUsage)((AwsCertificateManagerCertificateExtendedKeyUsage.Builder)AwsCertificateManagerCertificateExtendedKeyUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImportedAt() {
            return this.importedAt;
        }

        public final void setImportedAt(String importedAt) {
            this.importedAt = importedAt;
        }

        @Override
        public final Builder importedAt(String importedAt) {
            this.importedAt = importedAt;
            return this;
        }

        public final Collection<String> getInUseBy() {
            if (this.inUseBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inUseBy;
        }

        public final void setInUseBy(Collection<String> inUseBy) {
            this.inUseBy = StringListCopier.copy(inUseBy);
        }

        @Override
        public final Builder inUseBy(Collection<String> inUseBy) {
            this.inUseBy = StringListCopier.copy(inUseBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inUseBy(String ... inUseBy) {
            this.inUseBy(Arrays.asList(inUseBy));
            return this;
        }

        public final String getIssuedAt() {
            return this.issuedAt;
        }

        public final void setIssuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public final List<AwsCertificateManagerCertificateKeyUsage.Builder> getKeyUsages() {
            List<AwsCertificateManagerCertificateKeyUsage.Builder> result = AwsCertificateManagerCertificateKeyUsagesCopier.copyToBuilder(this.keyUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyUsages(Collection<AwsCertificateManagerCertificateKeyUsage.BuilderImpl> keyUsages) {
            this.keyUsages = AwsCertificateManagerCertificateKeyUsagesCopier.copyFromBuilder(keyUsages);
        }

        @Override
        public final Builder keyUsages(Collection<AwsCertificateManagerCertificateKeyUsage> keyUsages) {
            this.keyUsages = AwsCertificateManagerCertificateKeyUsagesCopier.copy(keyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsages(AwsCertificateManagerCertificateKeyUsage ... keyUsages) {
            this.keyUsages(Arrays.asList(keyUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsages(Consumer<AwsCertificateManagerCertificateKeyUsage.Builder> ... keyUsages) {
            this.keyUsages(Stream.of(keyUsages).map(c -> (AwsCertificateManagerCertificateKeyUsage)((AwsCertificateManagerCertificateKeyUsage.Builder)AwsCertificateManagerCertificateKeyUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNotAfter() {
            return this.notAfter;
        }

        public final void setNotAfter(String notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(String notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final String getNotBefore() {
            return this.notBefore;
        }

        public final void setNotBefore(String notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public final Builder notBefore(String notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final AwsCertificateManagerCertificateOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(AwsCertificateManagerCertificateOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(AwsCertificateManagerCertificateOptions options) {
            this.options = options;
            return this;
        }

        public final String getRenewalEligibility() {
            return this.renewalEligibility;
        }

        public final void setRenewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
        }

        @Override
        public final Builder renewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
            return this;
        }

        public final AwsCertificateManagerCertificateRenewalSummary.Builder getRenewalSummary() {
            return this.renewalSummary != null ? this.renewalSummary.toBuilder() : null;
        }

        public final void setRenewalSummary(AwsCertificateManagerCertificateRenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        @Override
        public final Builder renewalSummary(AwsCertificateManagerCertificateRenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final String getSerial() {
            return this.serial;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            if (this.subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subjectAlternativeNames;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public AwsCertificateManagerCertificateDetails build() {
            return new AwsCertificateManagerCertificateDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCertificateManagerCertificateDetails> {
        public Builder certificateAuthorityArn(String var1);

        public Builder createdAt(String var1);

        public Builder domainName(String var1);

        public Builder domainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption> var1);

        public Builder domainValidationOptions(AwsCertificateManagerCertificateDomainValidationOption ... var1);

        public Builder domainValidationOptions(Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder> ... var1);

        public Builder extendedKeyUsages(Collection<AwsCertificateManagerCertificateExtendedKeyUsage> var1);

        public Builder extendedKeyUsages(AwsCertificateManagerCertificateExtendedKeyUsage ... var1);

        public Builder extendedKeyUsages(Consumer<AwsCertificateManagerCertificateExtendedKeyUsage.Builder> ... var1);

        public Builder failureReason(String var1);

        public Builder importedAt(String var1);

        public Builder inUseBy(Collection<String> var1);

        public Builder inUseBy(String ... var1);

        public Builder issuedAt(String var1);

        public Builder issuer(String var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyUsages(Collection<AwsCertificateManagerCertificateKeyUsage> var1);

        public Builder keyUsages(AwsCertificateManagerCertificateKeyUsage ... var1);

        public Builder keyUsages(Consumer<AwsCertificateManagerCertificateKeyUsage.Builder> ... var1);

        public Builder notAfter(String var1);

        public Builder notBefore(String var1);

        public Builder options(AwsCertificateManagerCertificateOptions var1);

        default public Builder options(Consumer<AwsCertificateManagerCertificateOptions.Builder> options) {
            return this.options((AwsCertificateManagerCertificateOptions)((AwsCertificateManagerCertificateOptions.Builder)AwsCertificateManagerCertificateOptions.builder().applyMutation(options)).build());
        }

        public Builder renewalEligibility(String var1);

        public Builder renewalSummary(AwsCertificateManagerCertificateRenewalSummary var1);

        default public Builder renewalSummary(Consumer<AwsCertificateManagerCertificateRenewalSummary.Builder> renewalSummary) {
            return this.renewalSummary((AwsCertificateManagerCertificateRenewalSummary)((AwsCertificateManagerCertificateRenewalSummary.Builder)AwsCertificateManagerCertificateRenewalSummary.builder().applyMutation(renewalSummary)).build());
        }

        public Builder serial(String var1);

        public Builder signatureAlgorithm(String var1);

        public Builder status(String var1);

        public Builder subject(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder type(String var1);
    }
}

