/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Actor;
import software.amazon.awssdk.services.securityhub.model.ActorsListCopier;
import software.amazon.awssdk.services.securityhub.model.Indicator;
import software.amazon.awssdk.services.securityhub.model.IndicatorsListCopier;
import software.amazon.awssdk.services.securityhub.model.NetworkEndpoint;
import software.amazon.awssdk.services.securityhub.model.NetworkEndpointsListCopier;
import software.amazon.awssdk.services.securityhub.model.Signal;
import software.amazon.awssdk.services.securityhub.model.SignalsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sequence
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sequence> {
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(Sequence.getter(Sequence::uid)).setter(Sequence.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()}).build();
    private static final SdkField<List<Actor>> ACTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actors").getter(Sequence.getter(Sequence::actors)).setter(Sequence.setter(Builder::actors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Actor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkEndpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(Sequence.getter(Sequence::endpoints)).setter(Sequence.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Signal>> SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Signals").getter(Sequence.getter(Sequence::signals)).setter(Sequence.setter(Builder::signals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Signal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Indicator>> SEQUENCE_INDICATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SequenceIndicators").getter(Sequence.getter(Sequence::sequenceIndicators)).setter(Sequence.setter(Builder::sequenceIndicators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceIndicators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Indicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, ACTORS_FIELD, ENDPOINTS_FIELD, SIGNALS_FIELD, SEQUENCE_INDICATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Uid", UID_FIELD);
            this.put("Actors", ACTORS_FIELD);
            this.put("Endpoints", ENDPOINTS_FIELD);
            this.put("Signals", SIGNALS_FIELD);
            this.put("SequenceIndicators", SEQUENCE_INDICATORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String uid;
    private final List<Actor> actors;
    private final List<NetworkEndpoint> endpoints;
    private final List<Signal> signals;
    private final List<Indicator> sequenceIndicators;

    private Sequence(BuilderImpl builder) {
        this.uid = builder.uid;
        this.actors = builder.actors;
        this.endpoints = builder.endpoints;
        this.signals = builder.signals;
        this.sequenceIndicators = builder.sequenceIndicators;
    }

    public final String uid() {
        return this.uid;
    }

    public final boolean hasActors() {
        return this.actors != null && !(this.actors instanceof SdkAutoConstructList);
    }

    public final List<Actor> actors() {
        return this.actors;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<NetworkEndpoint> endpoints() {
        return this.endpoints;
    }

    public final boolean hasSignals() {
        return this.signals != null && !(this.signals instanceof SdkAutoConstructList);
    }

    public final List<Signal> signals() {
        return this.signals;
    }

    public final boolean hasSequenceIndicators() {
        return this.sequenceIndicators != null && !(this.sequenceIndicators instanceof SdkAutoConstructList);
    }

    public final List<Indicator> sequenceIndicators() {
        return this.sequenceIndicators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActors() ? this.actors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignals() ? this.signals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSequenceIndicators() ? this.sequenceIndicators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)obj;
        return Objects.equals(this.uid(), other.uid()) && this.hasActors() == other.hasActors() && Objects.equals(this.actors(), other.actors()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && this.hasSignals() == other.hasSignals() && Objects.equals(this.signals(), other.signals()) && this.hasSequenceIndicators() == other.hasSequenceIndicators() && Objects.equals(this.sequenceIndicators(), other.sequenceIndicators());
    }

    public final String toString() {
        return ToString.builder((String)"Sequence").add("Uid", (Object)this.uid()).add("Actors", this.hasActors() ? this.actors() : null).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("Signals", this.hasSignals() ? this.signals() : null).add("SequenceIndicators", this.hasSequenceIndicators() ? this.sequenceIndicators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Actors": {
                return Optional.ofNullable(clazz.cast(this.actors()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "Signals": {
                return Optional.ofNullable(clazz.cast(this.signals()));
            }
            case "SequenceIndicators": {
                return Optional.ofNullable(clazz.cast(this.sequenceIndicators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Sequence, T> g) {
        return obj -> g.apply((Sequence)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uid;
        private List<Actor> actors = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();
        private List<Signal> signals = DefaultSdkAutoConstructList.getInstance();
        private List<Indicator> sequenceIndicators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Sequence model) {
            this.uid(model.uid);
            this.actors(model.actors);
            this.endpoints(model.endpoints);
            this.signals(model.signals);
            this.sequenceIndicators(model.sequenceIndicators);
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final List<Actor.Builder> getActors() {
            List<Actor.Builder> result = ActorsListCopier.copyToBuilder(this.actors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActors(Collection<Actor.BuilderImpl> actors) {
            this.actors = ActorsListCopier.copyFromBuilder(actors);
        }

        @Override
        public final Builder actors(Collection<Actor> actors) {
            this.actors = ActorsListCopier.copy(actors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actors(Actor ... actors) {
            this.actors(Arrays.asList(actors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actors(Consumer<Actor.Builder> ... actors) {
            this.actors(Stream.of(actors).map(c -> (Actor)((Actor.Builder)Actor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkEndpoint.Builder> getEndpoints() {
            List<NetworkEndpoint.Builder> result = NetworkEndpointsListCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<NetworkEndpoint.BuilderImpl> endpoints) {
            this.endpoints = NetworkEndpointsListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<NetworkEndpoint> endpoints) {
            this.endpoints = NetworkEndpointsListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(NetworkEndpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<NetworkEndpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (NetworkEndpoint)((NetworkEndpoint.Builder)NetworkEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Signal.Builder> getSignals() {
            List<Signal.Builder> result = SignalsListCopier.copyToBuilder(this.signals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignals(Collection<Signal.BuilderImpl> signals) {
            this.signals = SignalsListCopier.copyFromBuilder(signals);
        }

        @Override
        public final Builder signals(Collection<Signal> signals) {
            this.signals = SignalsListCopier.copy(signals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signals(Signal ... signals) {
            this.signals(Arrays.asList(signals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signals(Consumer<Signal.Builder> ... signals) {
            this.signals(Stream.of(signals).map(c -> (Signal)((Signal.Builder)Signal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Indicator.Builder> getSequenceIndicators() {
            List<Indicator.Builder> result = IndicatorsListCopier.copyToBuilder(this.sequenceIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSequenceIndicators(Collection<Indicator.BuilderImpl> sequenceIndicators) {
            this.sequenceIndicators = IndicatorsListCopier.copyFromBuilder(sequenceIndicators);
        }

        @Override
        public final Builder sequenceIndicators(Collection<Indicator> sequenceIndicators) {
            this.sequenceIndicators = IndicatorsListCopier.copy(sequenceIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceIndicators(Indicator ... sequenceIndicators) {
            this.sequenceIndicators(Arrays.asList(sequenceIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceIndicators(Consumer<Indicator.Builder> ... sequenceIndicators) {
            this.sequenceIndicators(Stream.of(sequenceIndicators).map(c -> (Indicator)((Indicator.Builder)Indicator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Sequence build() {
            return new Sequence(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sequence> {
        public Builder uid(String var1);

        public Builder actors(Collection<Actor> var1);

        public Builder actors(Actor ... var1);

        public Builder actors(Consumer<Actor.Builder> ... var1);

        public Builder endpoints(Collection<NetworkEndpoint> var1);

        public Builder endpoints(NetworkEndpoint ... var1);

        public Builder endpoints(Consumer<NetworkEndpoint.Builder> ... var1);

        public Builder signals(Collection<Signal> var1);

        public Builder signals(Signal ... var1);

        public Builder signals(Consumer<Signal.Builder> ... var1);

        public Builder sequenceIndicators(Collection<Indicator> var1);

        public Builder sequenceIndicators(Indicator ... var1);

        public Builder sequenceIndicators(Consumer<Indicator.Builder> ... var1);
    }
}

