/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.StandardsManagedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Standard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Standard> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsArn").getter(Standard.getter(Standard::standardsArn)).setter(Standard.setter(Builder::standardsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Standard.getter(Standard::name)).setter(Standard.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Standard.getter(Standard::description)).setter(Standard.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> ENABLED_BY_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnabledByDefault").getter(Standard.getter(Standard::enabledByDefault)).setter(Standard.setter(Builder::enabledByDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledByDefault").build()}).build();
    private static final SdkField<StandardsManagedBy> STANDARDS_MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StandardsManagedBy").getter(Standard.getter(Standard::standardsManagedBy)).setter(Standard.setter(Builder::standardsManagedBy)).constructor(StandardsManagedBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsManagedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENABLED_BY_DEFAULT_FIELD, STANDARDS_MANAGED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StandardsArn", STANDARDS_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("EnabledByDefault", ENABLED_BY_DEFAULT_FIELD);
            this.put("StandardsManagedBy", STANDARDS_MANAGED_BY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String standardsArn;
    private final String name;
    private final String description;
    private final Boolean enabledByDefault;
    private final StandardsManagedBy standardsManagedBy;

    private Standard(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.name = builder.name;
        this.description = builder.description;
        this.enabledByDefault = builder.enabledByDefault;
        this.standardsManagedBy = builder.standardsManagedBy;
    }

    public final String standardsArn() {
        return this.standardsArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean enabledByDefault() {
        return this.enabledByDefault;
    }

    public final StandardsManagedBy standardsManagedBy() {
        return this.standardsManagedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledByDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsManagedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Standard)) {
            return false;
        }
        Standard other = (Standard)obj;
        return Objects.equals(this.standardsArn(), other.standardsArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabledByDefault(), other.enabledByDefault()) && Objects.equals(this.standardsManagedBy(), other.standardsManagedBy());
    }

    public final String toString() {
        return ToString.builder((String)"Standard").add("StandardsArn", (Object)this.standardsArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EnabledByDefault", (Object)this.enabledByDefault()).add("StandardsManagedBy", (Object)this.standardsManagedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsArn": {
                return Optional.ofNullable(clazz.cast(this.standardsArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EnabledByDefault": {
                return Optional.ofNullable(clazz.cast(this.enabledByDefault()));
            }
            case "StandardsManagedBy": {
                return Optional.ofNullable(clazz.cast(this.standardsManagedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Standard, T> g) {
        return obj -> g.apply((Standard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standardsArn;
        private String name;
        private String description;
        private Boolean enabledByDefault;
        private StandardsManagedBy standardsManagedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Standard model) {
            this.standardsArn(model.standardsArn);
            this.name(model.name);
            this.description(model.description);
            this.enabledByDefault(model.enabledByDefault);
            this.standardsManagedBy(model.standardsManagedBy);
        }

        public final String getStandardsArn() {
            return this.standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabledByDefault() {
            return this.enabledByDefault;
        }

        public final void setEnabledByDefault(Boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        @Override
        public final Builder enabledByDefault(Boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
            return this;
        }

        public final StandardsManagedBy.Builder getStandardsManagedBy() {
            return this.standardsManagedBy != null ? this.standardsManagedBy.toBuilder() : null;
        }

        public final void setStandardsManagedBy(StandardsManagedBy.BuilderImpl standardsManagedBy) {
            this.standardsManagedBy = standardsManagedBy != null ? standardsManagedBy.build() : null;
        }

        @Override
        public final Builder standardsManagedBy(StandardsManagedBy standardsManagedBy) {
            this.standardsManagedBy = standardsManagedBy;
            return this;
        }

        public Standard build() {
            return new Standard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Standard> {
        public Builder standardsArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enabledByDefault(Boolean var1);

        public Builder standardsManagedBy(StandardsManagedBy var1);

        default public Builder standardsManagedBy(Consumer<StandardsManagedBy.Builder> standardsManagedBy) {
            return this.standardsManagedBy((StandardsManagedBy)((StandardsManagedBy.Builder)StandardsManagedBy.builder().applyMutation(standardsManagedBy)).build());
        }
    }
}

