/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEksClusterResourcesVpcConfigDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEksClusterResourcesVpcConfigDetails> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(AwsEksClusterResourcesVpcConfigDetails.getter(AwsEksClusterResourcesVpcConfigDetails::securityGroupIds)).setter(AwsEksClusterResourcesVpcConfigDetails.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(AwsEksClusterResourcesVpcConfigDetails.getter(AwsEksClusterResourcesVpcConfigDetails::subnetIds)).setter(AwsEksClusterResourcesVpcConfigDetails.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENDPOINT_PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EndpointPublicAccess").getter(AwsEksClusterResourcesVpcConfigDetails.getter(AwsEksClusterResourcesVpcConfigDetails::endpointPublicAccess)).setter(AwsEksClusterResourcesVpcConfigDetails.setter(Builder::endpointPublicAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointPublicAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, ENDPOINT_PUBLIC_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
            this.put("SubnetIds", SUBNET_IDS_FIELD);
            this.put("EndpointPublicAccess", ENDPOINT_PUBLIC_ACCESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;
    private final Boolean endpointPublicAccess;

    private AwsEksClusterResourcesVpcConfigDetails(BuilderImpl builder) {
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.endpointPublicAccess = builder.endpointPublicAccess;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final Boolean endpointPublicAccess() {
        return this.endpointPublicAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointPublicAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEksClusterResourcesVpcConfigDetails)) {
            return false;
        }
        AwsEksClusterResourcesVpcConfigDetails other = (AwsEksClusterResourcesVpcConfigDetails)obj;
        return this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.endpointPublicAccess(), other.endpointPublicAccess());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEksClusterResourcesVpcConfigDetails").add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("EndpointPublicAccess", (Object)this.endpointPublicAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "EndpointPublicAccess": {
                return Optional.ofNullable(clazz.cast(this.endpointPublicAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEksClusterResourcesVpcConfigDetails, T> g) {
        return obj -> g.apply((AwsEksClusterResourcesVpcConfigDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean endpointPublicAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEksClusterResourcesVpcConfigDetails model) {
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
            this.endpointPublicAccess(model.endpointPublicAccess);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = NonEmptyStringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = NonEmptyStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = NonEmptyStringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = NonEmptyStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Boolean getEndpointPublicAccess() {
            return this.endpointPublicAccess;
        }

        public final void setEndpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
        }

        @Override
        public final Builder endpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        public AwsEksClusterResourcesVpcConfigDetails build() {
            return new AwsEksClusterResourcesVpcConfigDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEksClusterResourcesVpcConfigDetails> {
        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder endpointPublicAccess(Boolean var1);
    }
}

