/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.UserAccount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActorUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActorUser> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ActorUser.getter(ActorUser::name)).setter(ActorUser.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(ActorUser.getter(ActorUser::uid)).setter(ActorUser.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ActorUser.getter(ActorUser::type)).setter(ActorUser.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CREDENTIAL_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialUid").getter(ActorUser.getter(ActorUser::credentialUid)).setter(ActorUser.setter(Builder::credentialUid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialUid").build()}).build();
    private static final SdkField<UserAccount> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Account").getter(ActorUser.getter(ActorUser::account)).setter(ActorUser.setter(Builder::account)).constructor(UserAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, UID_FIELD, TYPE_FIELD, CREDENTIAL_UID_FIELD, ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Uid", UID_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("CredentialUid", CREDENTIAL_UID_FIELD);
            this.put("Account", ACCOUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String uid;
    private final String type;
    private final String credentialUid;
    private final UserAccount account;

    private ActorUser(BuilderImpl builder) {
        this.name = builder.name;
        this.uid = builder.uid;
        this.type = builder.type;
        this.credentialUid = builder.credentialUid;
        this.account = builder.account;
    }

    public final String name() {
        return this.name;
    }

    public final String uid() {
        return this.uid;
    }

    public final String type() {
        return this.type;
    }

    public final String credentialUid() {
        return this.credentialUid;
    }

    public final UserAccount account() {
        return this.account;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialUid());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActorUser)) {
            return false;
        }
        ActorUser other = (ActorUser)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.uid(), other.uid()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.credentialUid(), other.credentialUid()) && Objects.equals(this.account(), other.account());
    }

    public final String toString() {
        return ToString.builder((String)"ActorUser").add("Name", (Object)this.name()).add("Uid", (Object)this.uid()).add("Type", (Object)this.type()).add("CredentialUid", (Object)this.credentialUid()).add("Account", (Object)this.account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "CredentialUid": {
                return Optional.ofNullable(clazz.cast(this.credentialUid()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActorUser, T> g) {
        return obj -> g.apply((ActorUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String uid;
        private String type;
        private String credentialUid;
        private UserAccount account;

        private BuilderImpl() {
        }

        private BuilderImpl(ActorUser model) {
            this.name(model.name);
            this.uid(model.uid);
            this.type(model.type);
            this.credentialUid(model.credentialUid);
            this.account(model.account);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getCredentialUid() {
            return this.credentialUid;
        }

        public final void setCredentialUid(String credentialUid) {
            this.credentialUid = credentialUid;
        }

        @Override
        public final Builder credentialUid(String credentialUid) {
            this.credentialUid = credentialUid;
            return this;
        }

        public final UserAccount.Builder getAccount() {
            return this.account != null ? this.account.toBuilder() : null;
        }

        public final void setAccount(UserAccount.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(UserAccount account) {
            this.account = account;
            return this;
        }

        public ActorUser build() {
            return new ActorUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActorUser> {
        public Builder name(String var1);

        public Builder uid(String var1);

        public Builder type(String var1);

        public Builder credentialUid(String var1);

        public Builder account(UserAccount var1);

        default public Builder account(Consumer<UserAccount.Builder> account) {
            return this.account((UserAccount)((UserAccount.Builder)UserAccount.builder().applyMutation(account)).build());
        }
    }
}

