/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2RulesListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2VisibilityConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclActionDetails;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2WebAclCaptchaConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafv2WebAclDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafv2WebAclDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::name)).setter(AwsWafv2WebAclDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::arn)).setter(AwsWafv2WebAclDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Boolean> MANAGEDBY_FIREWALL_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagedbyFirewallManager").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::managedbyFirewallManager)).setter(AwsWafv2WebAclDetails.setter(Builder::managedbyFirewallManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedbyFirewallManager").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::id)).setter(AwsWafv2WebAclDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Long> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Capacity").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::capacity)).setter(AwsWafv2WebAclDetails.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<AwsWafv2WebAclCaptchaConfigDetails> CAPTCHA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CaptchaConfig").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::captchaConfig)).setter(AwsWafv2WebAclDetails.setter(Builder::captchaConfig)).constructor(AwsWafv2WebAclCaptchaConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptchaConfig").build()}).build();
    private static final SdkField<AwsWafv2WebAclActionDetails> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultAction").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::defaultAction)).setter(AwsWafv2WebAclDetails.setter(Builder::defaultAction)).constructor(AwsWafv2WebAclActionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::description)).setter(AwsWafv2WebAclDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<AwsWafv2RulesDetails>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::rules)).setter(AwsWafv2WebAclDetails.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafv2RulesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsWafv2VisibilityConfigDetails> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(AwsWafv2WebAclDetails.getter(AwsWafv2WebAclDetails::visibilityConfig)).setter(AwsWafv2WebAclDetails.setter(Builder::visibilityConfig)).constructor(AwsWafv2VisibilityConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, MANAGEDBY_FIREWALL_MANAGER_FIELD, ID_FIELD, CAPACITY_FIELD, CAPTCHA_CONFIG_FIELD, DEFAULT_ACTION_FIELD, DESCRIPTION_FIELD, RULES_FIELD, VISIBILITY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("ManagedbyFirewallManager", MANAGEDBY_FIREWALL_MANAGER_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Capacity", CAPACITY_FIELD);
            this.put("CaptchaConfig", CAPTCHA_CONFIG_FIELD);
            this.put("DefaultAction", DEFAULT_ACTION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Rules", RULES_FIELD);
            this.put("VisibilityConfig", VISIBILITY_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Boolean managedbyFirewallManager;
    private final String id;
    private final Long capacity;
    private final AwsWafv2WebAclCaptchaConfigDetails captchaConfig;
    private final AwsWafv2WebAclActionDetails defaultAction;
    private final String description;
    private final List<AwsWafv2RulesDetails> rules;
    private final AwsWafv2VisibilityConfigDetails visibilityConfig;

    private AwsWafv2WebAclDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.managedbyFirewallManager = builder.managedbyFirewallManager;
        this.id = builder.id;
        this.capacity = builder.capacity;
        this.captchaConfig = builder.captchaConfig;
        this.defaultAction = builder.defaultAction;
        this.description = builder.description;
        this.rules = builder.rules;
        this.visibilityConfig = builder.visibilityConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean managedbyFirewallManager() {
        return this.managedbyFirewallManager;
    }

    public final String id() {
        return this.id;
    }

    public final Long capacity() {
        return this.capacity;
    }

    public final AwsWafv2WebAclCaptchaConfigDetails captchaConfig() {
        return this.captchaConfig;
    }

    public final AwsWafv2WebAclActionDetails defaultAction() {
        return this.defaultAction;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AwsWafv2RulesDetails> rules() {
        return this.rules;
    }

    public final AwsWafv2VisibilityConfigDetails visibilityConfig() {
        return this.visibilityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedbyFirewallManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.captchaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2WebAclDetails)) {
            return false;
        }
        AwsWafv2WebAclDetails other = (AwsWafv2WebAclDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.managedbyFirewallManager(), other.managedbyFirewallManager()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.captchaConfig(), other.captchaConfig()) && Objects.equals(this.defaultAction(), other.defaultAction()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafv2WebAclDetails").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("ManagedbyFirewallManager", (Object)this.managedbyFirewallManager()).add("Id", (Object)this.id()).add("Capacity", (Object)this.capacity()).add("CaptchaConfig", (Object)this.captchaConfig()).add("DefaultAction", (Object)this.defaultAction()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).add("VisibilityConfig", (Object)this.visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ManagedbyFirewallManager": {
                return Optional.ofNullable(clazz.cast(this.managedbyFirewallManager()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "CaptchaConfig": {
                return Optional.ofNullable(clazz.cast(this.captchaConfig()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2WebAclDetails, T> g) {
        return obj -> g.apply((AwsWafv2WebAclDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Boolean managedbyFirewallManager;
        private String id;
        private Long capacity;
        private AwsWafv2WebAclCaptchaConfigDetails captchaConfig;
        private AwsWafv2WebAclActionDetails defaultAction;
        private String description;
        private List<AwsWafv2RulesDetails> rules = DefaultSdkAutoConstructList.getInstance();
        private AwsWafv2VisibilityConfigDetails visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2WebAclDetails model) {
            this.name(model.name);
            this.arn(model.arn);
            this.managedbyFirewallManager(model.managedbyFirewallManager);
            this.id(model.id);
            this.capacity(model.capacity);
            this.captchaConfig(model.captchaConfig);
            this.defaultAction(model.defaultAction);
            this.description(model.description);
            this.rules(model.rules);
            this.visibilityConfig(model.visibilityConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getManagedbyFirewallManager() {
            return this.managedbyFirewallManager;
        }

        public final void setManagedbyFirewallManager(Boolean managedbyFirewallManager) {
            this.managedbyFirewallManager = managedbyFirewallManager;
        }

        @Override
        public final Builder managedbyFirewallManager(Boolean managedbyFirewallManager) {
            this.managedbyFirewallManager = managedbyFirewallManager;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final AwsWafv2WebAclCaptchaConfigDetails.Builder getCaptchaConfig() {
            return this.captchaConfig != null ? this.captchaConfig.toBuilder() : null;
        }

        public final void setCaptchaConfig(AwsWafv2WebAclCaptchaConfigDetails.BuilderImpl captchaConfig) {
            this.captchaConfig = captchaConfig != null ? captchaConfig.build() : null;
        }

        @Override
        public final Builder captchaConfig(AwsWafv2WebAclCaptchaConfigDetails captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        public final AwsWafv2WebAclActionDetails.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(AwsWafv2WebAclActionDetails.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        public final Builder defaultAction(AwsWafv2WebAclActionDetails defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AwsWafv2RulesDetails.Builder> getRules() {
            List<AwsWafv2RulesDetails.Builder> result = AwsWafv2RulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafv2RulesDetails.BuilderImpl> rules) {
            this.rules = AwsWafv2RulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AwsWafv2RulesDetails> rules) {
            this.rules = AwsWafv2RulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafv2RulesDetails ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafv2RulesDetails.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AwsWafv2RulesDetails)((AwsWafv2RulesDetails.Builder)AwsWafv2RulesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsWafv2VisibilityConfigDetails.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(AwsWafv2VisibilityConfigDetails.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public AwsWafv2WebAclDetails build() {
            return new AwsWafv2WebAclDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafv2WebAclDetails> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder managedbyFirewallManager(Boolean var1);

        public Builder id(String var1);

        public Builder capacity(Long var1);

        public Builder captchaConfig(AwsWafv2WebAclCaptchaConfigDetails var1);

        default public Builder captchaConfig(Consumer<AwsWafv2WebAclCaptchaConfigDetails.Builder> captchaConfig) {
            return this.captchaConfig((AwsWafv2WebAclCaptchaConfigDetails)((AwsWafv2WebAclCaptchaConfigDetails.Builder)AwsWafv2WebAclCaptchaConfigDetails.builder().applyMutation(captchaConfig)).build());
        }

        public Builder defaultAction(AwsWafv2WebAclActionDetails var1);

        default public Builder defaultAction(Consumer<AwsWafv2WebAclActionDetails.Builder> defaultAction) {
            return this.defaultAction((AwsWafv2WebAclActionDetails)((AwsWafv2WebAclActionDetails.Builder)AwsWafv2WebAclActionDetails.builder().applyMutation(defaultAction)).build());
        }

        public Builder description(String var1);

        public Builder rules(Collection<AwsWafv2RulesDetails> var1);

        public Builder rules(AwsWafv2RulesDetails ... var1);

        public Builder rules(Consumer<AwsWafv2RulesDetails.Builder> ... var1);

        public Builder visibilityConfig(AwsWafv2VisibilityConfigDetails var1);

        default public Builder visibilityConfig(Consumer<AwsWafv2VisibilityConfigDetails.Builder> visibilityConfig) {
            return this.visibilityConfig((AwsWafv2VisibilityConfigDetails)((AwsWafv2VisibilityConfigDetails.Builder)AwsWafv2VisibilityConfigDetails.builder().applyMutation(visibilityConfig)).build());
        }
    }
}

