/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription;
import software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsSnsTopicDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsSnsTopicDetails> {
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsMasterKeyId").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::kmsMasterKeyId)).setter(AwsSnsTopicDetails.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()}).build();
    private static final SdkField<List<AwsSnsTopicSubscription>> SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscription").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::subscription)).setter(AwsSnsTopicDetails.setter(Builder::subscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscription").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsSnsTopicSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::topicName)).setter(AwsSnsTopicDetails.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::owner)).setter(AwsSnsTopicDetails.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> SQS_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqsSuccessFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::sqsSuccessFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::sqsSuccessFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsSuccessFeedbackRoleArn").build()}).build();
    private static final SdkField<String> SQS_FAILURE_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqsFailureFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::sqsFailureFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::sqsFailureFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsFailureFeedbackRoleArn").build()}).build();
    private static final SdkField<String> APPLICATION_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationSuccessFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::applicationSuccessFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::applicationSuccessFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSuccessFeedbackRoleArn").build()}).build();
    private static final SdkField<String> FIREHOSE_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirehoseSuccessFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::firehoseSuccessFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::firehoseSuccessFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseSuccessFeedbackRoleArn").build()}).build();
    private static final SdkField<String> FIREHOSE_FAILURE_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirehoseFailureFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::firehoseFailureFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::firehoseFailureFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseFailureFeedbackRoleArn").build()}).build();
    private static final SdkField<String> HTTP_SUCCESS_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpSuccessFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::httpSuccessFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::httpSuccessFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpSuccessFeedbackRoleArn").build()}).build();
    private static final SdkField<String> HTTP_FAILURE_FEEDBACK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpFailureFeedbackRoleArn").getter(AwsSnsTopicDetails.getter(AwsSnsTopicDetails::httpFailureFeedbackRoleArn)).setter(AwsSnsTopicDetails.setter(Builder::httpFailureFeedbackRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpFailureFeedbackRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MASTER_KEY_ID_FIELD, SUBSCRIPTION_FIELD, TOPIC_NAME_FIELD, OWNER_FIELD, SQS_SUCCESS_FEEDBACK_ROLE_ARN_FIELD, SQS_FAILURE_FEEDBACK_ROLE_ARN_FIELD, APPLICATION_SUCCESS_FEEDBACK_ROLE_ARN_FIELD, FIREHOSE_SUCCESS_FEEDBACK_ROLE_ARN_FIELD, FIREHOSE_FAILURE_FEEDBACK_ROLE_ARN_FIELD, HTTP_SUCCESS_FEEDBACK_ROLE_ARN_FIELD, HTTP_FAILURE_FEEDBACK_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KmsMasterKeyId", KMS_MASTER_KEY_ID_FIELD);
            this.put("Subscription", SUBSCRIPTION_FIELD);
            this.put("TopicName", TOPIC_NAME_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("SqsSuccessFeedbackRoleArn", SQS_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
            this.put("SqsFailureFeedbackRoleArn", SQS_FAILURE_FEEDBACK_ROLE_ARN_FIELD);
            this.put("ApplicationSuccessFeedbackRoleArn", APPLICATION_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
            this.put("FirehoseSuccessFeedbackRoleArn", FIREHOSE_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
            this.put("FirehoseFailureFeedbackRoleArn", FIREHOSE_FAILURE_FEEDBACK_ROLE_ARN_FIELD);
            this.put("HttpSuccessFeedbackRoleArn", HTTP_SUCCESS_FEEDBACK_ROLE_ARN_FIELD);
            this.put("HttpFailureFeedbackRoleArn", HTTP_FAILURE_FEEDBACK_ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String kmsMasterKeyId;
    private final List<AwsSnsTopicSubscription> subscription;
    private final String topicName;
    private final String owner;
    private final String sqsSuccessFeedbackRoleArn;
    private final String sqsFailureFeedbackRoleArn;
    private final String applicationSuccessFeedbackRoleArn;
    private final String firehoseSuccessFeedbackRoleArn;
    private final String firehoseFailureFeedbackRoleArn;
    private final String httpSuccessFeedbackRoleArn;
    private final String httpFailureFeedbackRoleArn;

    private AwsSnsTopicDetails(BuilderImpl builder) {
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.subscription = builder.subscription;
        this.topicName = builder.topicName;
        this.owner = builder.owner;
        this.sqsSuccessFeedbackRoleArn = builder.sqsSuccessFeedbackRoleArn;
        this.sqsFailureFeedbackRoleArn = builder.sqsFailureFeedbackRoleArn;
        this.applicationSuccessFeedbackRoleArn = builder.applicationSuccessFeedbackRoleArn;
        this.firehoseSuccessFeedbackRoleArn = builder.firehoseSuccessFeedbackRoleArn;
        this.firehoseFailureFeedbackRoleArn = builder.firehoseFailureFeedbackRoleArn;
        this.httpSuccessFeedbackRoleArn = builder.httpSuccessFeedbackRoleArn;
        this.httpFailureFeedbackRoleArn = builder.httpFailureFeedbackRoleArn;
    }

    public final String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public final boolean hasSubscription() {
        return this.subscription != null && !(this.subscription instanceof SdkAutoConstructList);
    }

    public final List<AwsSnsTopicSubscription> subscription() {
        return this.subscription;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final String owner() {
        return this.owner;
    }

    public final String sqsSuccessFeedbackRoleArn() {
        return this.sqsSuccessFeedbackRoleArn;
    }

    public final String sqsFailureFeedbackRoleArn() {
        return this.sqsFailureFeedbackRoleArn;
    }

    public final String applicationSuccessFeedbackRoleArn() {
        return this.applicationSuccessFeedbackRoleArn;
    }

    public final String firehoseSuccessFeedbackRoleArn() {
        return this.firehoseSuccessFeedbackRoleArn;
    }

    public final String firehoseFailureFeedbackRoleArn() {
        return this.firehoseFailureFeedbackRoleArn;
    }

    public final String httpSuccessFeedbackRoleArn() {
        return this.httpSuccessFeedbackRoleArn;
    }

    public final String httpFailureFeedbackRoleArn() {
        return this.httpFailureFeedbackRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscription() ? this.subscription() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsFailureFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseFailureFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpSuccessFeedbackRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpFailureFeedbackRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSnsTopicDetails)) {
            return false;
        }
        AwsSnsTopicDetails other = (AwsSnsTopicDetails)obj;
        return Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && this.hasSubscription() == other.hasSubscription() && Objects.equals(this.subscription(), other.subscription()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.sqsSuccessFeedbackRoleArn(), other.sqsSuccessFeedbackRoleArn()) && Objects.equals(this.sqsFailureFeedbackRoleArn(), other.sqsFailureFeedbackRoleArn()) && Objects.equals(this.applicationSuccessFeedbackRoleArn(), other.applicationSuccessFeedbackRoleArn()) && Objects.equals(this.firehoseSuccessFeedbackRoleArn(), other.firehoseSuccessFeedbackRoleArn()) && Objects.equals(this.firehoseFailureFeedbackRoleArn(), other.firehoseFailureFeedbackRoleArn()) && Objects.equals(this.httpSuccessFeedbackRoleArn(), other.httpSuccessFeedbackRoleArn()) && Objects.equals(this.httpFailureFeedbackRoleArn(), other.httpFailureFeedbackRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AwsSnsTopicDetails").add("KmsMasterKeyId", (Object)this.kmsMasterKeyId()).add("Subscription", this.hasSubscription() ? this.subscription() : null).add("TopicName", (Object)this.topicName()).add("Owner", (Object)this.owner()).add("SqsSuccessFeedbackRoleArn", (Object)this.sqsSuccessFeedbackRoleArn()).add("SqsFailureFeedbackRoleArn", (Object)this.sqsFailureFeedbackRoleArn()).add("ApplicationSuccessFeedbackRoleArn", (Object)this.applicationSuccessFeedbackRoleArn()).add("FirehoseSuccessFeedbackRoleArn", (Object)this.firehoseSuccessFeedbackRoleArn()).add("FirehoseFailureFeedbackRoleArn", (Object)this.firehoseFailureFeedbackRoleArn()).add("HttpSuccessFeedbackRoleArn", (Object)this.httpSuccessFeedbackRoleArn()).add("HttpFailureFeedbackRoleArn", (Object)this.httpFailureFeedbackRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "Subscription": {
                return Optional.ofNullable(clazz.cast(this.subscription()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "SqsSuccessFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sqsSuccessFeedbackRoleArn()));
            }
            case "SqsFailureFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.sqsFailureFeedbackRoleArn()));
            }
            case "ApplicationSuccessFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.applicationSuccessFeedbackRoleArn()));
            }
            case "FirehoseSuccessFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.firehoseSuccessFeedbackRoleArn()));
            }
            case "FirehoseFailureFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.firehoseFailureFeedbackRoleArn()));
            }
            case "HttpSuccessFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.httpSuccessFeedbackRoleArn()));
            }
            case "HttpFailureFeedbackRoleArn": {
                return Optional.ofNullable(clazz.cast(this.httpFailureFeedbackRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsSnsTopicDetails, T> g) {
        return obj -> g.apply((AwsSnsTopicDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsMasterKeyId;
        private List<AwsSnsTopicSubscription> subscription = DefaultSdkAutoConstructList.getInstance();
        private String topicName;
        private String owner;
        private String sqsSuccessFeedbackRoleArn;
        private String sqsFailureFeedbackRoleArn;
        private String applicationSuccessFeedbackRoleArn;
        private String firehoseSuccessFeedbackRoleArn;
        private String firehoseFailureFeedbackRoleArn;
        private String httpSuccessFeedbackRoleArn;
        private String httpFailureFeedbackRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSnsTopicDetails model) {
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.subscription(model.subscription);
            this.topicName(model.topicName);
            this.owner(model.owner);
            this.sqsSuccessFeedbackRoleArn(model.sqsSuccessFeedbackRoleArn);
            this.sqsFailureFeedbackRoleArn(model.sqsFailureFeedbackRoleArn);
            this.applicationSuccessFeedbackRoleArn(model.applicationSuccessFeedbackRoleArn);
            this.firehoseSuccessFeedbackRoleArn(model.firehoseSuccessFeedbackRoleArn);
            this.firehoseFailureFeedbackRoleArn(model.firehoseFailureFeedbackRoleArn);
            this.httpSuccessFeedbackRoleArn(model.httpSuccessFeedbackRoleArn);
            this.httpFailureFeedbackRoleArn(model.httpFailureFeedbackRoleArn);
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final List<AwsSnsTopicSubscription.Builder> getSubscription() {
            List<AwsSnsTopicSubscription.Builder> result = AwsSnsTopicSubscriptionListCopier.copyToBuilder(this.subscription);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscription(Collection<AwsSnsTopicSubscription.BuilderImpl> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copyFromBuilder(subscription);
        }

        @Override
        public final Builder subscription(Collection<AwsSnsTopicSubscription> subscription) {
            this.subscription = AwsSnsTopicSubscriptionListCopier.copy(subscription);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(AwsSnsTopicSubscription ... subscription) {
            this.subscription(Arrays.asList(subscription));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscription(Consumer<AwsSnsTopicSubscription.Builder> ... subscription) {
            this.subscription(Stream.of(subscription).map(c -> (AwsSnsTopicSubscription)((AwsSnsTopicSubscription.Builder)AwsSnsTopicSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getSqsSuccessFeedbackRoleArn() {
            return this.sqsSuccessFeedbackRoleArn;
        }

        public final void setSqsSuccessFeedbackRoleArn(String sqsSuccessFeedbackRoleArn) {
            this.sqsSuccessFeedbackRoleArn = sqsSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder sqsSuccessFeedbackRoleArn(String sqsSuccessFeedbackRoleArn) {
            this.sqsSuccessFeedbackRoleArn = sqsSuccessFeedbackRoleArn;
            return this;
        }

        public final String getSqsFailureFeedbackRoleArn() {
            return this.sqsFailureFeedbackRoleArn;
        }

        public final void setSqsFailureFeedbackRoleArn(String sqsFailureFeedbackRoleArn) {
            this.sqsFailureFeedbackRoleArn = sqsFailureFeedbackRoleArn;
        }

        @Override
        public final Builder sqsFailureFeedbackRoleArn(String sqsFailureFeedbackRoleArn) {
            this.sqsFailureFeedbackRoleArn = sqsFailureFeedbackRoleArn;
            return this;
        }

        public final String getApplicationSuccessFeedbackRoleArn() {
            return this.applicationSuccessFeedbackRoleArn;
        }

        public final void setApplicationSuccessFeedbackRoleArn(String applicationSuccessFeedbackRoleArn) {
            this.applicationSuccessFeedbackRoleArn = applicationSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder applicationSuccessFeedbackRoleArn(String applicationSuccessFeedbackRoleArn) {
            this.applicationSuccessFeedbackRoleArn = applicationSuccessFeedbackRoleArn;
            return this;
        }

        public final String getFirehoseSuccessFeedbackRoleArn() {
            return this.firehoseSuccessFeedbackRoleArn;
        }

        public final void setFirehoseSuccessFeedbackRoleArn(String firehoseSuccessFeedbackRoleArn) {
            this.firehoseSuccessFeedbackRoleArn = firehoseSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder firehoseSuccessFeedbackRoleArn(String firehoseSuccessFeedbackRoleArn) {
            this.firehoseSuccessFeedbackRoleArn = firehoseSuccessFeedbackRoleArn;
            return this;
        }

        public final String getFirehoseFailureFeedbackRoleArn() {
            return this.firehoseFailureFeedbackRoleArn;
        }

        public final void setFirehoseFailureFeedbackRoleArn(String firehoseFailureFeedbackRoleArn) {
            this.firehoseFailureFeedbackRoleArn = firehoseFailureFeedbackRoleArn;
        }

        @Override
        public final Builder firehoseFailureFeedbackRoleArn(String firehoseFailureFeedbackRoleArn) {
            this.firehoseFailureFeedbackRoleArn = firehoseFailureFeedbackRoleArn;
            return this;
        }

        public final String getHttpSuccessFeedbackRoleArn() {
            return this.httpSuccessFeedbackRoleArn;
        }

        public final void setHttpSuccessFeedbackRoleArn(String httpSuccessFeedbackRoleArn) {
            this.httpSuccessFeedbackRoleArn = httpSuccessFeedbackRoleArn;
        }

        @Override
        public final Builder httpSuccessFeedbackRoleArn(String httpSuccessFeedbackRoleArn) {
            this.httpSuccessFeedbackRoleArn = httpSuccessFeedbackRoleArn;
            return this;
        }

        public final String getHttpFailureFeedbackRoleArn() {
            return this.httpFailureFeedbackRoleArn;
        }

        public final void setHttpFailureFeedbackRoleArn(String httpFailureFeedbackRoleArn) {
            this.httpFailureFeedbackRoleArn = httpFailureFeedbackRoleArn;
        }

        @Override
        public final Builder httpFailureFeedbackRoleArn(String httpFailureFeedbackRoleArn) {
            this.httpFailureFeedbackRoleArn = httpFailureFeedbackRoleArn;
            return this;
        }

        public AwsSnsTopicDetails build() {
            return new AwsSnsTopicDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsSnsTopicDetails> {
        public Builder kmsMasterKeyId(String var1);

        public Builder subscription(Collection<AwsSnsTopicSubscription> var1);

        public Builder subscription(AwsSnsTopicSubscription ... var1);

        public Builder subscription(Consumer<AwsSnsTopicSubscription.Builder> ... var1);

        public Builder topicName(String var1);

        public Builder owner(String var1);

        public Builder sqsSuccessFeedbackRoleArn(String var1);

        public Builder sqsFailureFeedbackRoleArn(String var1);

        public Builder applicationSuccessFeedbackRoleArn(String var1);

        public Builder firehoseSuccessFeedbackRoleArn(String var1);

        public Builder firehoseFailureFeedbackRoleArn(String var1);

        public Builder httpSuccessFeedbackRoleArn(String var1);

        public Builder httpFailureFeedbackRoleArn(String var1);
    }
}

