/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader;
import software.amazon.awssdk.services.securityhub.model.AwsWafv2InsertHeadersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafv2CustomResponseDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafv2CustomResponseDetails> {
    private static final SdkField<String> CUSTOM_RESPONSE_BODY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomResponseBodyKey").getter(AwsWafv2CustomResponseDetails.getter(AwsWafv2CustomResponseDetails::customResponseBodyKey)).setter(AwsWafv2CustomResponseDetails.setter(Builder::customResponseBodyKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodyKey").build()}).build();
    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResponseCode").getter(AwsWafv2CustomResponseDetails.getter(AwsWafv2CustomResponseDetails::responseCode)).setter(AwsWafv2CustomResponseDetails.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()}).build();
    private static final SdkField<List<AwsWafv2CustomHttpHeader>> RESPONSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponseHeaders").getter(AwsWafv2CustomResponseDetails.getter(AwsWafv2CustomResponseDetails::responseHeaders)).setter(AwsWafv2CustomResponseDetails.setter(Builder::responseHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafv2CustomHttpHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_RESPONSE_BODY_KEY_FIELD, RESPONSE_CODE_FIELD, RESPONSE_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomResponseBodyKey", CUSTOM_RESPONSE_BODY_KEY_FIELD);
            this.put("ResponseCode", RESPONSE_CODE_FIELD);
            this.put("ResponseHeaders", RESPONSE_HEADERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customResponseBodyKey;
    private final Integer responseCode;
    private final List<AwsWafv2CustomHttpHeader> responseHeaders;

    private AwsWafv2CustomResponseDetails(BuilderImpl builder) {
        this.customResponseBodyKey = builder.customResponseBodyKey;
        this.responseCode = builder.responseCode;
        this.responseHeaders = builder.responseHeaders;
    }

    public final String customResponseBodyKey() {
        return this.customResponseBodyKey;
    }

    public final Integer responseCode() {
        return this.responseCode;
    }

    public final boolean hasResponseHeaders() {
        return this.responseHeaders != null && !(this.responseHeaders instanceof SdkAutoConstructList);
    }

    public final List<AwsWafv2CustomHttpHeader> responseHeaders() {
        return this.responseHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customResponseBodyKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseHeaders() ? this.responseHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2CustomResponseDetails)) {
            return false;
        }
        AwsWafv2CustomResponseDetails other = (AwsWafv2CustomResponseDetails)obj;
        return Objects.equals(this.customResponseBodyKey(), other.customResponseBodyKey()) && Objects.equals(this.responseCode(), other.responseCode()) && this.hasResponseHeaders() == other.hasResponseHeaders() && Objects.equals(this.responseHeaders(), other.responseHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafv2CustomResponseDetails").add("CustomResponseBodyKey", (Object)this.customResponseBodyKey()).add("ResponseCode", (Object)this.responseCode()).add("ResponseHeaders", this.hasResponseHeaders() ? this.responseHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomResponseBodyKey": {
                return Optional.ofNullable(clazz.cast(this.customResponseBodyKey()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "ResponseHeaders": {
                return Optional.ofNullable(clazz.cast(this.responseHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2CustomResponseDetails, T> g) {
        return obj -> g.apply((AwsWafv2CustomResponseDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customResponseBodyKey;
        private Integer responseCode;
        private List<AwsWafv2CustomHttpHeader> responseHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2CustomResponseDetails model) {
            this.customResponseBodyKey(model.customResponseBodyKey);
            this.responseCode(model.responseCode);
            this.responseHeaders(model.responseHeaders);
        }

        public final String getCustomResponseBodyKey() {
            return this.customResponseBodyKey;
        }

        public final void setCustomResponseBodyKey(String customResponseBodyKey) {
            this.customResponseBodyKey = customResponseBodyKey;
        }

        @Override
        public final Builder customResponseBodyKey(String customResponseBodyKey) {
            this.customResponseBodyKey = customResponseBodyKey;
            return this;
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final List<AwsWafv2CustomHttpHeader.Builder> getResponseHeaders() {
            List<AwsWafv2CustomHttpHeader.Builder> result = AwsWafv2InsertHeadersListCopier.copyToBuilder(this.responseHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseHeaders(Collection<AwsWafv2CustomHttpHeader.BuilderImpl> responseHeaders) {
            this.responseHeaders = AwsWafv2InsertHeadersListCopier.copyFromBuilder(responseHeaders);
        }

        @Override
        public final Builder responseHeaders(Collection<AwsWafv2CustomHttpHeader> responseHeaders) {
            this.responseHeaders = AwsWafv2InsertHeadersListCopier.copy(responseHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseHeaders(AwsWafv2CustomHttpHeader ... responseHeaders) {
            this.responseHeaders(Arrays.asList(responseHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseHeaders(Consumer<AwsWafv2CustomHttpHeader.Builder> ... responseHeaders) {
            this.responseHeaders(Stream.of(responseHeaders).map(c -> (AwsWafv2CustomHttpHeader)((AwsWafv2CustomHttpHeader.Builder)AwsWafv2CustomHttpHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsWafv2CustomResponseDetails build() {
            return new AwsWafv2CustomResponseDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafv2CustomResponseDetails> {
        public Builder customResponseBodyKey(String var1);

        public Builder responseCode(Integer var1);

        public Builder responseHeaders(Collection<AwsWafv2CustomHttpHeader> var1);

        public Builder responseHeaders(AwsWafv2CustomHttpHeader ... var1);

        public Builder responseHeaders(Consumer<AwsWafv2CustomHttpHeader.Builder> ... var1);
    }
}

