/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRedshiftClusterLoggingStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRedshiftClusterLoggingStatus> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(AwsRedshiftClusterLoggingStatus.getter(AwsRedshiftClusterLoggingStatus::bucketName)).setter(AwsRedshiftClusterLoggingStatus.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailureMessage").getter(AwsRedshiftClusterLoggingStatus.getter(AwsRedshiftClusterLoggingStatus::lastFailureMessage)).setter(AwsRedshiftClusterLoggingStatus.setter(Builder::lastFailureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build()}).build();
    private static final SdkField<String> LAST_FAILURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailureTime").getter(AwsRedshiftClusterLoggingStatus.getter(AwsRedshiftClusterLoggingStatus::lastFailureTime)).setter(AwsRedshiftClusterLoggingStatus.setter(Builder::lastFailureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureTime").build()}).build();
    private static final SdkField<String> LAST_SUCCESSFUL_DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSuccessfulDeliveryTime").getter(AwsRedshiftClusterLoggingStatus.getter(AwsRedshiftClusterLoggingStatus::lastSuccessfulDeliveryTime)).setter(AwsRedshiftClusterLoggingStatus.setter(Builder::lastSuccessfulDeliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDeliveryTime").build()}).build();
    private static final SdkField<Boolean> LOGGING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LoggingEnabled").getter(AwsRedshiftClusterLoggingStatus.getter(AwsRedshiftClusterLoggingStatus::loggingEnabled)).setter(AwsRedshiftClusterLoggingStatus.setter(Builder::loggingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingEnabled").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(AwsRedshiftClusterLoggingStatus.getter(AwsRedshiftClusterLoggingStatus::s3KeyPrefix)).setter(AwsRedshiftClusterLoggingStatus.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, LAST_FAILURE_MESSAGE_FIELD, LAST_FAILURE_TIME_FIELD, LAST_SUCCESSFUL_DELIVERY_TIME_FIELD, LOGGING_ENABLED_FIELD, S3_KEY_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BucketName", BUCKET_NAME_FIELD);
            this.put("LastFailureMessage", LAST_FAILURE_MESSAGE_FIELD);
            this.put("LastFailureTime", LAST_FAILURE_TIME_FIELD);
            this.put("LastSuccessfulDeliveryTime", LAST_SUCCESSFUL_DELIVERY_TIME_FIELD);
            this.put("LoggingEnabled", LOGGING_ENABLED_FIELD);
            this.put("S3KeyPrefix", S3_KEY_PREFIX_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String lastFailureMessage;
    private final String lastFailureTime;
    private final String lastSuccessfulDeliveryTime;
    private final Boolean loggingEnabled;
    private final String s3KeyPrefix;

    private AwsRedshiftClusterLoggingStatus(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.lastFailureTime = builder.lastFailureTime;
        this.lastSuccessfulDeliveryTime = builder.lastSuccessfulDeliveryTime;
        this.loggingEnabled = builder.loggingEnabled;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public final String lastFailureTime() {
        return this.lastFailureTime;
    }

    public final String lastSuccessfulDeliveryTime() {
        return this.lastSuccessfulDeliveryTime;
    }

    public final Boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterLoggingStatus)) {
            return false;
        }
        AwsRedshiftClusterLoggingStatus other = (AwsRedshiftClusterLoggingStatus)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage()) && Objects.equals(this.lastFailureTime(), other.lastFailureTime()) && Objects.equals(this.lastSuccessfulDeliveryTime(), other.lastSuccessfulDeliveryTime()) && Objects.equals(this.loggingEnabled(), other.loggingEnabled()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRedshiftClusterLoggingStatus").add("BucketName", (Object)this.bucketName()).add("LastFailureMessage", (Object)this.lastFailureMessage()).add("LastFailureTime", (Object)this.lastFailureTime()).add("LastSuccessfulDeliveryTime", (Object)this.lastSuccessfulDeliveryTime()).add("LoggingEnabled", (Object)this.loggingEnabled()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
            case "LastFailureTime": {
                return Optional.ofNullable(clazz.cast(this.lastFailureTime()));
            }
            case "LastSuccessfulDeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulDeliveryTime()));
            }
            case "LoggingEnabled": {
                return Optional.ofNullable(clazz.cast(this.loggingEnabled()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterLoggingStatus, T> g) {
        return obj -> g.apply((AwsRedshiftClusterLoggingStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String lastFailureMessage;
        private String lastFailureTime;
        private String lastSuccessfulDeliveryTime;
        private Boolean loggingEnabled;
        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterLoggingStatus model) {
            this.bucketName(model.bucketName);
            this.lastFailureMessage(model.lastFailureMessage);
            this.lastFailureTime(model.lastFailureTime);
            this.lastSuccessfulDeliveryTime(model.lastSuccessfulDeliveryTime);
            this.loggingEnabled(model.loggingEnabled);
            this.s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final String getLastFailureTime() {
            return this.lastFailureTime;
        }

        public final void setLastFailureTime(String lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
        }

        @Override
        public final Builder lastFailureTime(String lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
            return this;
        }

        public final String getLastSuccessfulDeliveryTime() {
            return this.lastSuccessfulDeliveryTime;
        }

        public final void setLastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
        }

        @Override
        public final Builder lastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
            return this;
        }

        public final Boolean getLoggingEnabled() {
            return this.loggingEnabled;
        }

        public final void setLoggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
        }

        @Override
        public final Builder loggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public AwsRedshiftClusterLoggingStatus build() {
            return new AwsRedshiftClusterLoggingStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRedshiftClusterLoggingStatus> {
        public Builder bucketName(String var1);

        public Builder lastFailureMessage(String var1);

        public Builder lastFailureTime(String var1);

        public Builder lastSuccessfulDeliveryTime(String var1);

        public Builder loggingEnabled(Boolean var1);

        public Builder s3KeyPrefix(String var1);
    }
}

