/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociation;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetConfigurationPolicyAssociationsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchGetConfigurationPolicyAssociationsRequest> {
    private static final SdkField<List<ConfigurationPolicyAssociation>> CONFIGURATION_POLICY_ASSOCIATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationPolicyAssociationIdentifiers").getter(BatchGetConfigurationPolicyAssociationsRequest.getter(BatchGetConfigurationPolicyAssociationsRequest::configurationPolicyAssociationIdentifiers)).setter(BatchGetConfigurationPolicyAssociationsRequest.setter(Builder::configurationPolicyAssociationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyAssociationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationPolicyAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ASSOCIATION_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationPolicyAssociationIdentifiers", CONFIGURATION_POLICY_ASSOCIATION_IDENTIFIERS_FIELD);
        }
    });
    private final List<ConfigurationPolicyAssociation> configurationPolicyAssociationIdentifiers;

    private BatchGetConfigurationPolicyAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyAssociationIdentifiers = builder.configurationPolicyAssociationIdentifiers;
    }

    public final boolean hasConfigurationPolicyAssociationIdentifiers() {
        return this.configurationPolicyAssociationIdentifiers != null && !(this.configurationPolicyAssociationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationPolicyAssociation> configurationPolicyAssociationIdentifiers() {
        return this.configurationPolicyAssociationIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationPolicyAssociationIdentifiers() ? this.configurationPolicyAssociationIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetConfigurationPolicyAssociationsRequest)) {
            return false;
        }
        BatchGetConfigurationPolicyAssociationsRequest other = (BatchGetConfigurationPolicyAssociationsRequest)((Object)obj);
        return this.hasConfigurationPolicyAssociationIdentifiers() == other.hasConfigurationPolicyAssociationIdentifiers() && Objects.equals(this.configurationPolicyAssociationIdentifiers(), other.configurationPolicyAssociationIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetConfigurationPolicyAssociationsRequest").add("ConfigurationPolicyAssociationIdentifiers", this.hasConfigurationPolicyAssociationIdentifiers() ? this.configurationPolicyAssociationIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationPolicyAssociationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicyAssociationIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetConfigurationPolicyAssociationsRequest, T> g) {
        return obj -> g.apply((BatchGetConfigurationPolicyAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<ConfigurationPolicyAssociation> configurationPolicyAssociationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetConfigurationPolicyAssociationsRequest model) {
            super(model);
            this.configurationPolicyAssociationIdentifiers(model.configurationPolicyAssociationIdentifiers);
        }

        public final List<ConfigurationPolicyAssociation.Builder> getConfigurationPolicyAssociationIdentifiers() {
            List<ConfigurationPolicyAssociation.Builder> result = ConfigurationPolicyAssociationsListCopier.copyToBuilder(this.configurationPolicyAssociationIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationPolicyAssociationIdentifiers(Collection<ConfigurationPolicyAssociation.BuilderImpl> configurationPolicyAssociationIdentifiers) {
            this.configurationPolicyAssociationIdentifiers = ConfigurationPolicyAssociationsListCopier.copyFromBuilder(configurationPolicyAssociationIdentifiers);
        }

        @Override
        public final Builder configurationPolicyAssociationIdentifiers(Collection<ConfigurationPolicyAssociation> configurationPolicyAssociationIdentifiers) {
            this.configurationPolicyAssociationIdentifiers = ConfigurationPolicyAssociationsListCopier.copy(configurationPolicyAssociationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociationIdentifiers(ConfigurationPolicyAssociation ... configurationPolicyAssociationIdentifiers) {
            this.configurationPolicyAssociationIdentifiers(Arrays.asList(configurationPolicyAssociationIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociationIdentifiers(Consumer<ConfigurationPolicyAssociation.Builder> ... configurationPolicyAssociationIdentifiers) {
            this.configurationPolicyAssociationIdentifiers(Stream.of(configurationPolicyAssociationIdentifiers).map(c -> (ConfigurationPolicyAssociation)((ConfigurationPolicyAssociation.Builder)ConfigurationPolicyAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetConfigurationPolicyAssociationsRequest build() {
            return new BatchGetConfigurationPolicyAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetConfigurationPolicyAssociationsRequest> {
        public Builder configurationPolicyAssociationIdentifiers(Collection<ConfigurationPolicyAssociation> var1);

        public Builder configurationPolicyAssociationIdentifiers(ConfigurationPolicyAssociation ... var1);

        public Builder configurationPolicyAssociationIdentifiers(Consumer<ConfigurationPolicyAssociation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

