/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAutoScalingLaunchConfigurationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationDetails> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::associatePublicIpAddress)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build()}).build();
    private static final SdkField<List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::blockDeviceMappings)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLASSIC_LINK_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClassicLinkVpcId").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::classicLinkVpcId)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::classicLinkVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVpcId").build()}).build();
    private static final SdkField<List<String>> CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClassicLinkVpcSecurityGroups").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::classicLinkVpcSecurityGroups)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::classicLinkVpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::createdTime)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::ebsOptimized)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamInstanceProfile").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::iamInstanceProfile)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::iamInstanceProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::imageId)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails> INSTANCE_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMonitoring").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::instanceMonitoring)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::instanceMonitoring)).constructor(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMonitoring").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::instanceType)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::kernelId)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::keyName)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationName").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::launchConfigurationName)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<String> PLACEMENT_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementTenancy").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::placementTenancy)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::placementTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementTenancy").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::ramdiskId)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::securityGroups)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::spotPrice)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::userData)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()}).build();
    private static final SdkField<AwsAutoScalingLaunchConfigurationMetadataOptions> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(AwsAutoScalingLaunchConfigurationDetails.getter(AwsAutoScalingLaunchConfigurationDetails::metadataOptions)).setter(AwsAutoScalingLaunchConfigurationDetails.setter(Builder::metadataOptions)).constructor(AwsAutoScalingLaunchConfigurationMetadataOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, CLASSIC_LINK_VPC_ID_FIELD, CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD, CREATED_TIME_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_MONITORING_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, PLACEMENT_TENANCY_FIELD, RAMDISK_ID_FIELD, SECURITY_GROUPS_FIELD, SPOT_PRICE_FIELD, USER_DATA_FIELD, METADATA_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssociatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
            this.put("BlockDeviceMappings", BLOCK_DEVICE_MAPPINGS_FIELD);
            this.put("ClassicLinkVpcId", CLASSIC_LINK_VPC_ID_FIELD);
            this.put("ClassicLinkVpcSecurityGroups", CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
            this.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
            this.put("ImageId", IMAGE_ID_FIELD);
            this.put("InstanceMonitoring", INSTANCE_MONITORING_FIELD);
            this.put("InstanceType", INSTANCE_TYPE_FIELD);
            this.put("KernelId", KERNEL_ID_FIELD);
            this.put("KeyName", KEY_NAME_FIELD);
            this.put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
            this.put("PlacementTenancy", PLACEMENT_TENANCY_FIELD);
            this.put("RamdiskId", RAMDISK_ID_FIELD);
            this.put("SecurityGroups", SECURITY_GROUPS_FIELD);
            this.put("SpotPrice", SPOT_PRICE_FIELD);
            this.put("UserData", USER_DATA_FIELD);
            this.put("MetadataOptions", METADATA_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean associatePublicIpAddress;
    private final List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings;
    private final String classicLinkVpcId;
    private final List<String> classicLinkVpcSecurityGroups;
    private final String createdTime;
    private final Boolean ebsOptimized;
    private final String iamInstanceProfile;
    private final String imageId;
    private final AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final String launchConfigurationName;
    private final String placementTenancy;
    private final String ramdiskId;
    private final List<String> securityGroups;
    private final String spotPrice;
    private final String userData;
    private final AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions;

    private AwsAutoScalingLaunchConfigurationDetails(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.classicLinkVpcId = builder.classicLinkVpcId;
        this.classicLinkVpcSecurityGroups = builder.classicLinkVpcSecurityGroups;
        this.createdTime = builder.createdTime;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.placementTenancy = builder.placementTenancy;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroups = builder.securityGroups;
        this.spotPrice = builder.spotPrice;
        this.userData = builder.userData;
        this.metadataOptions = builder.metadataOptions;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final String classicLinkVpcId() {
        return this.classicLinkVpcId;
    }

    public final boolean hasClassicLinkVpcSecurityGroups() {
        return this.classicLinkVpcSecurityGroups != null && !(this.classicLinkVpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> classicLinkVpcSecurityGroups() {
        return this.classicLinkVpcSecurityGroups;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring() {
        return this.instanceMonitoring;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public final String placementTenancy() {
        return this.placementTenancy;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final String userData() {
        return this.userData;
    }

    public final AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions() {
        return this.metadataOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLinkVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassicLinkVpcSecurityGroups() ? this.classicLinkVpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementTenancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingLaunchConfigurationDetails)) {
            return false;
        }
        AwsAutoScalingLaunchConfigurationDetails other = (AwsAutoScalingLaunchConfigurationDetails)obj;
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.classicLinkVpcId(), other.classicLinkVpcId()) && this.hasClassicLinkVpcSecurityGroups() == other.hasClassicLinkVpcSecurityGroups() && Objects.equals(this.classicLinkVpcSecurityGroups(), other.classicLinkVpcSecurityGroups()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceMonitoring(), other.instanceMonitoring()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.placementTenancy(), other.placementTenancy()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.metadataOptions(), other.metadataOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAutoScalingLaunchConfigurationDetails").add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("ClassicLinkVpcId", (Object)this.classicLinkVpcId()).add("ClassicLinkVpcSecurityGroups", this.hasClassicLinkVpcSecurityGroups() ? this.classicLinkVpcSecurityGroups() : null).add("CreatedTime", (Object)this.createdTime()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceMonitoring", (Object)this.instanceMonitoring()).add("InstanceType", (Object)this.instanceType()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("PlacementTenancy", (Object)this.placementTenancy()).add("RamdiskId", (Object)this.ramdiskId()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SpotPrice", (Object)this.spotPrice()).add("UserData", (Object)this.userData()).add("MetadataOptions", (Object)this.metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "ClassicLinkVpcId": {
                return Optional.ofNullable(clazz.cast(this.classicLinkVpcId()));
            }
            case "ClassicLinkVpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.classicLinkVpcSecurityGroups()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceMonitoring": {
                return Optional.ofNullable(clazz.cast(this.instanceMonitoring()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "PlacementTenancy": {
                return Optional.ofNullable(clazz.cast(this.placementTenancy()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingLaunchConfigurationDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingLaunchConfigurationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String classicLinkVpcId;
        private List<String> classicLinkVpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String createdTime;
        private Boolean ebsOptimized;
        private String iamInstanceProfile;
        private String imageId;
        private AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private String launchConfigurationName;
        private String placementTenancy;
        private String ramdiskId;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String spotPrice;
        private String userData;
        private AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingLaunchConfigurationDetails model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.classicLinkVpcId(model.classicLinkVpcId);
            this.classicLinkVpcSecurityGroups(model.classicLinkVpcSecurityGroups);
            this.createdTime(model.createdTime);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceMonitoring(model.instanceMonitoring);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.launchConfigurationName(model.launchConfigurationName);
            this.placementTenancy(model.placementTenancy);
            this.ramdiskId(model.ramdiskId);
            this.securityGroups(model.securityGroups);
            this.spotPrice(model.spotPrice);
            this.userData(model.userData);
            this.metadataOptions(model.metadataOptions);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder> getBlockDeviceMappings() {
            List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder> result = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> blockDeviceMappings) {
            this.blockDeviceMappings = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails)((AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder)AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClassicLinkVpcId() {
            return this.classicLinkVpcId;
        }

        public final void setClassicLinkVpcId(String classicLinkVpcId) {
            this.classicLinkVpcId = classicLinkVpcId;
        }

        @Override
        public final Builder classicLinkVpcId(String classicLinkVpcId) {
            this.classicLinkVpcId = classicLinkVpcId;
            return this;
        }

        public final Collection<String> getClassicLinkVpcSecurityGroups() {
            if (this.classicLinkVpcSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.classicLinkVpcSecurityGroups;
        }

        public final void setClassicLinkVpcSecurityGroups(Collection<String> classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups = NonEmptyStringListCopier.copy(classicLinkVpcSecurityGroups);
        }

        @Override
        public final Builder classicLinkVpcSecurityGroups(Collection<String> classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups = NonEmptyStringListCopier.copy(classicLinkVpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVpcSecurityGroups(String ... classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups(Arrays.asList(classicLinkVpcSecurityGroups));
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder getInstanceMonitoring() {
            return this.instanceMonitoring != null ? this.instanceMonitoring.toBuilder() : null;
        }

        public final void setInstanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        @Override
        public final Builder instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final String getPlacementTenancy() {
            return this.placementTenancy;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final AwsAutoScalingLaunchConfigurationMetadataOptions.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public AwsAutoScalingLaunchConfigurationDetails build() {
            return new AwsAutoScalingLaunchConfigurationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationDetails> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder blockDeviceMappings(Collection<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails> var1);

        public Builder blockDeviceMappings(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails ... var1);

        public Builder blockDeviceMappings(Consumer<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.Builder> ... var1);

        public Builder classicLinkVpcId(String var1);

        public Builder classicLinkVpcSecurityGroups(Collection<String> var1);

        public Builder classicLinkVpcSecurityGroups(String ... var1);

        public Builder createdTime(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(String var1);

        public Builder imageId(String var1);

        public Builder instanceMonitoring(AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails var1);

        default public Builder instanceMonitoring(Consumer<AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder> instanceMonitoring) {
            return this.instanceMonitoring((AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails)((AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder)AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.builder().applyMutation(instanceMonitoring)).build());
        }

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder placementTenancy(String var1);

        public Builder ramdiskId(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder spotPrice(String var1);

        public Builder userData(String var1);

        public Builder metadataOptions(AwsAutoScalingLaunchConfigurationMetadataOptions var1);

        default public Builder metadataOptions(Consumer<AwsAutoScalingLaunchConfigurationMetadataOptions.Builder> metadataOptions) {
            return this.metadataOptions((AwsAutoScalingLaunchConfigurationMetadataOptions)((AwsAutoScalingLaunchConfigurationMetadataOptions.Builder)AwsAutoScalingLaunchConfigurationMetadataOptions.builder().applyMutation(metadataOptions)).build());
        }
    }
}

