/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.ActionRemoteIpDetails;
import software.amazon.awssdk.services.securityhub.model.AwsApiCallActionDomainDetails;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiCallAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiCallAction> {
    private static final SdkField<String> API_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Api").getter(AwsApiCallAction.getter(AwsApiCallAction::api)).setter(AwsApiCallAction.setter(Builder::api)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Api").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(AwsApiCallAction.getter(AwsApiCallAction::serviceName)).setter(AwsApiCallAction.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> CALLER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerType").getter(AwsApiCallAction.getter(AwsApiCallAction::callerType)).setter(AwsApiCallAction.setter(Builder::callerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerType").build()}).build();
    private static final SdkField<ActionRemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::remoteIpDetails)).setter(AwsApiCallAction.setter(Builder::remoteIpDetails)).constructor(ActionRemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpDetails").build()}).build();
    private static final SdkField<AwsApiCallActionDomainDetails> DOMAIN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::domainDetails)).setter(AwsApiCallAction.setter(Builder::domainDetails)).constructor(AwsApiCallActionDomainDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDetails").build()}).build();
    private static final SdkField<Map<String, String>> AFFECTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AffectedResources").getter(AwsApiCallAction.getter(AwsApiCallAction::affectedResources)).setter(AwsApiCallAction.setter(Builder::affectedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedResources").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FIRST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstSeen").getter(AwsApiCallAction.getter(AwsApiCallAction::firstSeen)).setter(AwsApiCallAction.setter(Builder::firstSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSeen").build()}).build();
    private static final SdkField<String> LAST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSeen").getter(AwsApiCallAction.getter(AwsApiCallAction::lastSeen)).setter(AwsApiCallAction.setter(Builder::lastSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeen").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD, SERVICE_NAME_FIELD, CALLER_TYPE_FIELD, REMOTE_IP_DETAILS_FIELD, DOMAIN_DETAILS_FIELD, AFFECTED_RESOURCES_FIELD, FIRST_SEEN_FIELD, LAST_SEEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Api", API_FIELD);
            this.put("ServiceName", SERVICE_NAME_FIELD);
            this.put("CallerType", CALLER_TYPE_FIELD);
            this.put("RemoteIpDetails", REMOTE_IP_DETAILS_FIELD);
            this.put("DomainDetails", DOMAIN_DETAILS_FIELD);
            this.put("AffectedResources", AFFECTED_RESOURCES_FIELD);
            this.put("FirstSeen", FIRST_SEEN_FIELD);
            this.put("LastSeen", LAST_SEEN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String api;
    private final String serviceName;
    private final String callerType;
    private final ActionRemoteIpDetails remoteIpDetails;
    private final AwsApiCallActionDomainDetails domainDetails;
    private final Map<String, String> affectedResources;
    private final String firstSeen;
    private final String lastSeen;

    private AwsApiCallAction(BuilderImpl builder) {
        this.api = builder.api;
        this.serviceName = builder.serviceName;
        this.callerType = builder.callerType;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.domainDetails = builder.domainDetails;
        this.affectedResources = builder.affectedResources;
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
    }

    public final String api() {
        return this.api;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String callerType() {
        return this.callerType;
    }

    public final ActionRemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public final AwsApiCallActionDomainDetails domainDetails() {
        return this.domainDetails;
    }

    public final boolean hasAffectedResources() {
        return this.affectedResources != null && !(this.affectedResources instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> affectedResources() {
        return this.affectedResources;
    }

    public final String firstSeen() {
        return this.firstSeen;
    }

    public final String lastSeen() {
        return this.lastSeen;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.api());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAffectedResources() ? this.affectedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeen());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiCallAction)) {
            return false;
        }
        AwsApiCallAction other = (AwsApiCallAction)obj;
        return Objects.equals(this.api(), other.api()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.callerType(), other.callerType()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.domainDetails(), other.domainDetails()) && this.hasAffectedResources() == other.hasAffectedResources() && Objects.equals(this.affectedResources(), other.affectedResources()) && Objects.equals(this.firstSeen(), other.firstSeen()) && Objects.equals(this.lastSeen(), other.lastSeen());
    }

    public final String toString() {
        return ToString.builder((String)"AwsApiCallAction").add("Api", (Object)this.api()).add("ServiceName", (Object)this.serviceName()).add("CallerType", (Object)this.callerType()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("DomainDetails", (Object)this.domainDetails()).add("AffectedResources", this.hasAffectedResources() ? this.affectedResources() : null).add("FirstSeen", (Object)this.firstSeen()).add("LastSeen", (Object)this.lastSeen()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Api": {
                return Optional.ofNullable(clazz.cast(this.api()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "CallerType": {
                return Optional.ofNullable(clazz.cast(this.callerType()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "DomainDetails": {
                return Optional.ofNullable(clazz.cast(this.domainDetails()));
            }
            case "AffectedResources": {
                return Optional.ofNullable(clazz.cast(this.affectedResources()));
            }
            case "FirstSeen": {
                return Optional.ofNullable(clazz.cast(this.firstSeen()));
            }
            case "LastSeen": {
                return Optional.ofNullable(clazz.cast(this.lastSeen()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiCallAction, T> g) {
        return obj -> g.apply((AwsApiCallAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String api;
        private String serviceName;
        private String callerType;
        private ActionRemoteIpDetails remoteIpDetails;
        private AwsApiCallActionDomainDetails domainDetails;
        private Map<String, String> affectedResources = DefaultSdkAutoConstructMap.getInstance();
        private String firstSeen;
        private String lastSeen;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiCallAction model) {
            this.api(model.api);
            this.serviceName(model.serviceName);
            this.callerType(model.callerType);
            this.remoteIpDetails(model.remoteIpDetails);
            this.domainDetails(model.domainDetails);
            this.affectedResources(model.affectedResources);
            this.firstSeen(model.firstSeen);
            this.lastSeen(model.lastSeen);
        }

        public final String getApi() {
            return this.api;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getCallerType() {
            return this.callerType;
        }

        public final void setCallerType(String callerType) {
            this.callerType = callerType;
        }

        @Override
        public final Builder callerType(String callerType) {
            this.callerType = callerType;
            return this;
        }

        public final ActionRemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(ActionRemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(ActionRemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final AwsApiCallActionDomainDetails.Builder getDomainDetails() {
            return this.domainDetails != null ? this.domainDetails.toBuilder() : null;
        }

        public final void setDomainDetails(AwsApiCallActionDomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        @Override
        public final Builder domainDetails(AwsApiCallActionDomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final Map<String, String> getAffectedResources() {
            if (this.affectedResources instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.affectedResources;
        }

        public final void setAffectedResources(Map<String, String> affectedResources) {
            this.affectedResources = FieldMapCopier.copy(affectedResources);
        }

        @Override
        public final Builder affectedResources(Map<String, String> affectedResources) {
            this.affectedResources = FieldMapCopier.copy(affectedResources);
            return this;
        }

        public final String getFirstSeen() {
            return this.firstSeen;
        }

        public final void setFirstSeen(String firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(String firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final String getLastSeen() {
            return this.lastSeen;
        }

        public final void setLastSeen(String lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(String lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public AwsApiCallAction build() {
            return new AwsApiCallAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiCallAction> {
        public Builder api(String var1);

        public Builder serviceName(String var1);

        public Builder callerType(String var1);

        public Builder remoteIpDetails(ActionRemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<ActionRemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((ActionRemoteIpDetails)((ActionRemoteIpDetails.Builder)ActionRemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder domainDetails(AwsApiCallActionDomainDetails var1);

        default public Builder domainDetails(Consumer<AwsApiCallActionDomainDetails.Builder> domainDetails) {
            return this.domainDetails((AwsApiCallActionDomainDetails)((AwsApiCallActionDomainDetails.Builder)AwsApiCallActionDomainDetails.builder().applyMutation(domainDetails)).build());
        }

        public Builder affectedResources(Map<String, String> var1);

        public Builder firstSeen(String var1);

        public Builder lastSeen(String var1);
    }
}

