/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesMetadata;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesMetadataListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationRulesResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListAutomationRulesResponse> {
    private static final SdkField<List<AutomationRulesMetadata>> AUTOMATION_RULES_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutomationRulesMetadata").getter(ListAutomationRulesResponse.getter(ListAutomationRulesResponse::automationRulesMetadata)).setter(ListAutomationRulesResponse.setter(Builder::automationRulesMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationRulesMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAutomationRulesResponse.getter(ListAutomationRulesResponse::nextToken)).setter(ListAutomationRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_RULES_METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<AutomationRulesMetadata> automationRulesMetadata;
    private final String nextToken;

    private ListAutomationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.automationRulesMetadata = builder.automationRulesMetadata;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutomationRulesMetadata() {
        return this.automationRulesMetadata != null && !(this.automationRulesMetadata instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesMetadata> automationRulesMetadata() {
        return this.automationRulesMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationRulesMetadata() ? this.automationRulesMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationRulesResponse)) {
            return false;
        }
        ListAutomationRulesResponse other = (ListAutomationRulesResponse)((Object)obj);
        return this.hasAutomationRulesMetadata() == other.hasAutomationRulesMetadata() && Objects.equals(this.automationRulesMetadata(), other.automationRulesMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationRulesResponse").add("AutomationRulesMetadata", this.hasAutomationRulesMetadata() ? this.automationRulesMetadata() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationRulesMetadata": {
                return Optional.ofNullable(clazz.cast(this.automationRulesMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationRulesResponse, T> g) {
        return obj -> g.apply((ListAutomationRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<AutomationRulesMetadata> automationRulesMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationRulesResponse model) {
            super(model);
            this.automationRulesMetadata(model.automationRulesMetadata);
            this.nextToken(model.nextToken);
        }

        public final List<AutomationRulesMetadata.Builder> getAutomationRulesMetadata() {
            List<AutomationRulesMetadata.Builder> result = AutomationRulesMetadataListCopier.copyToBuilder(this.automationRulesMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomationRulesMetadata(Collection<AutomationRulesMetadata.BuilderImpl> automationRulesMetadata) {
            this.automationRulesMetadata = AutomationRulesMetadataListCopier.copyFromBuilder(automationRulesMetadata);
        }

        @Override
        public final Builder automationRulesMetadata(Collection<AutomationRulesMetadata> automationRulesMetadata) {
            this.automationRulesMetadata = AutomationRulesMetadataListCopier.copy(automationRulesMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRulesMetadata(AutomationRulesMetadata ... automationRulesMetadata) {
            this.automationRulesMetadata(Arrays.asList(automationRulesMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRulesMetadata(Consumer<AutomationRulesMetadata.Builder> ... automationRulesMetadata) {
            this.automationRulesMetadata(Stream.of(automationRulesMetadata).map(c -> (AutomationRulesMetadata)((AutomationRulesMetadata.Builder)AutomationRulesMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationRulesResponse build() {
            return new ListAutomationRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationRulesResponse> {
        public Builder automationRulesMetadata(Collection<AutomationRulesMetadata> var1);

        public Builder automationRulesMetadata(AutomationRulesMetadata ... var1);

        public Builder automationRulesMetadata(Consumer<AutomationRulesMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

