/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdate;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdateSource;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryUpdatesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingHistoryRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingHistoryRecord> {
    private static final SdkField<AwsSecurityFindingIdentifier> FINDING_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindingIdentifier").getter(FindingHistoryRecord.getter(FindingHistoryRecord::findingIdentifier)).setter(FindingHistoryRecord.setter(Builder::findingIdentifier)).constructor(AwsSecurityFindingIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifier").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(FindingHistoryRecord.getter(FindingHistoryRecord::updateTime)).setter(FindingHistoryRecord.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> FINDING_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FindingCreated").getter(FindingHistoryRecord.getter(FindingHistoryRecord::findingCreated)).setter(FindingHistoryRecord.setter(Builder::findingCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingCreated").build()}).build();
    private static final SdkField<FindingHistoryUpdateSource> UPDATE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateSource").getter(FindingHistoryRecord.getter(FindingHistoryRecord::updateSource)).setter(FindingHistoryRecord.setter(Builder::updateSource)).constructor(FindingHistoryUpdateSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateSource").build()}).build();
    private static final SdkField<List<FindingHistoryUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(FindingHistoryRecord.getter(FindingHistoryRecord::updates)).setter(FindingHistoryRecord.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingHistoryUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(FindingHistoryRecord.getter(FindingHistoryRecord::nextToken)).setter(FindingHistoryRecord.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIER_FIELD, UPDATE_TIME_FIELD, FINDING_CREATED_FIELD, UPDATE_SOURCE_FIELD, UPDATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FindingIdentifier", FINDING_IDENTIFIER_FIELD);
            this.put("UpdateTime", UPDATE_TIME_FIELD);
            this.put("FindingCreated", FINDING_CREATED_FIELD);
            this.put("UpdateSource", UPDATE_SOURCE_FIELD);
            this.put("Updates", UPDATES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AwsSecurityFindingIdentifier findingIdentifier;
    private final Instant updateTime;
    private final Boolean findingCreated;
    private final FindingHistoryUpdateSource updateSource;
    private final List<FindingHistoryUpdate> updates;
    private final String nextToken;

    private FindingHistoryRecord(BuilderImpl builder) {
        this.findingIdentifier = builder.findingIdentifier;
        this.updateTime = builder.updateTime;
        this.findingCreated = builder.findingCreated;
        this.updateSource = builder.updateSource;
        this.updates = builder.updates;
        this.nextToken = builder.nextToken;
    }

    public final AwsSecurityFindingIdentifier findingIdentifier() {
        return this.findingIdentifier;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final Boolean findingCreated() {
        return this.findingCreated;
    }

    public final FindingHistoryUpdateSource updateSource() {
        return this.updateSource;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<FindingHistoryUpdate> updates() {
        return this.updates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingHistoryRecord)) {
            return false;
        }
        FindingHistoryRecord other = (FindingHistoryRecord)obj;
        return Objects.equals(this.findingIdentifier(), other.findingIdentifier()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.findingCreated(), other.findingCreated()) && Objects.equals(this.updateSource(), other.updateSource()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"FindingHistoryRecord").add("FindingIdentifier", (Object)this.findingIdentifier()).add("UpdateTime", (Object)this.updateTime()).add("FindingCreated", (Object)this.findingCreated()).add("UpdateSource", (Object)this.updateSource()).add("Updates", this.hasUpdates() ? this.updates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FindingIdentifier": {
                return Optional.ofNullable(clazz.cast(this.findingIdentifier()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "FindingCreated": {
                return Optional.ofNullable(clazz.cast(this.findingCreated()));
            }
            case "UpdateSource": {
                return Optional.ofNullable(clazz.cast(this.updateSource()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FindingHistoryRecord, T> g) {
        return obj -> g.apply((FindingHistoryRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsSecurityFindingIdentifier findingIdentifier;
        private Instant updateTime;
        private Boolean findingCreated;
        private FindingHistoryUpdateSource updateSource;
        private List<FindingHistoryUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingHistoryRecord model) {
            this.findingIdentifier(model.findingIdentifier);
            this.updateTime(model.updateTime);
            this.findingCreated(model.findingCreated);
            this.updateSource(model.updateSource);
            this.updates(model.updates);
            this.nextToken(model.nextToken);
        }

        public final AwsSecurityFindingIdentifier.Builder getFindingIdentifier() {
            return this.findingIdentifier != null ? this.findingIdentifier.toBuilder() : null;
        }

        public final void setFindingIdentifier(AwsSecurityFindingIdentifier.BuilderImpl findingIdentifier) {
            this.findingIdentifier = findingIdentifier != null ? findingIdentifier.build() : null;
        }

        @Override
        public final Builder findingIdentifier(AwsSecurityFindingIdentifier findingIdentifier) {
            this.findingIdentifier = findingIdentifier;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Boolean getFindingCreated() {
            return this.findingCreated;
        }

        public final void setFindingCreated(Boolean findingCreated) {
            this.findingCreated = findingCreated;
        }

        @Override
        public final Builder findingCreated(Boolean findingCreated) {
            this.findingCreated = findingCreated;
            return this;
        }

        public final FindingHistoryUpdateSource.Builder getUpdateSource() {
            return this.updateSource != null ? this.updateSource.toBuilder() : null;
        }

        public final void setUpdateSource(FindingHistoryUpdateSource.BuilderImpl updateSource) {
            this.updateSource = updateSource != null ? updateSource.build() : null;
        }

        @Override
        public final Builder updateSource(FindingHistoryUpdateSource updateSource) {
            this.updateSource = updateSource;
            return this;
        }

        public final List<FindingHistoryUpdate.Builder> getUpdates() {
            List<FindingHistoryUpdate.Builder> result = FindingHistoryUpdatesListCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<FindingHistoryUpdate.BuilderImpl> updates) {
            this.updates = FindingHistoryUpdatesListCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<FindingHistoryUpdate> updates) {
            this.updates = FindingHistoryUpdatesListCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(FindingHistoryUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<FindingHistoryUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (FindingHistoryUpdate)((FindingHistoryUpdate.Builder)FindingHistoryUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public FindingHistoryRecord build() {
            return new FindingHistoryRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingHistoryRecord> {
        public Builder findingIdentifier(AwsSecurityFindingIdentifier var1);

        default public Builder findingIdentifier(Consumer<AwsSecurityFindingIdentifier.Builder> findingIdentifier) {
            return this.findingIdentifier((AwsSecurityFindingIdentifier)((AwsSecurityFindingIdentifier.Builder)AwsSecurityFindingIdentifier.builder().applyMutation(findingIdentifier)).build());
        }

        public Builder updateTime(Instant var1);

        public Builder findingCreated(Boolean var1);

        public Builder updateSource(FindingHistoryUpdateSource var1);

        default public Builder updateSource(Consumer<FindingHistoryUpdateSource.Builder> updateSource) {
            return this.updateSource((FindingHistoryUpdateSource)((FindingHistoryUpdateSource.Builder)FindingHistoryUpdateSource.builder().applyMutation(updateSource)).build());
        }

        public Builder updates(Collection<FindingHistoryUpdate> var1);

        public Builder updates(FindingHistoryUpdate ... var1);

        public Builder updates(Consumer<FindingHistoryUpdate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

