/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ControlFindingGenerator;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityHubConfigurationRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateSecurityHubConfigurationRequest> {
    private static final SdkField<Boolean> AUTO_ENABLE_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnableControls").getter(UpdateSecurityHubConfigurationRequest.getter(UpdateSecurityHubConfigurationRequest::autoEnableControls)).setter(UpdateSecurityHubConfigurationRequest.setter(Builder::autoEnableControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnableControls").build()}).build();
    private static final SdkField<String> CONTROL_FINDING_GENERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlFindingGenerator").getter(UpdateSecurityHubConfigurationRequest.getter(UpdateSecurityHubConfigurationRequest::controlFindingGeneratorAsString)).setter(UpdateSecurityHubConfigurationRequest.setter(Builder::controlFindingGenerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlFindingGenerator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_CONTROLS_FIELD, CONTROL_FINDING_GENERATOR_FIELD));
    private final Boolean autoEnableControls;
    private final String controlFindingGenerator;

    private UpdateSecurityHubConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableControls = builder.autoEnableControls;
        this.controlFindingGenerator = builder.controlFindingGenerator;
    }

    public final Boolean autoEnableControls() {
        return this.autoEnableControls;
    }

    public final ControlFindingGenerator controlFindingGenerator() {
        return ControlFindingGenerator.fromValue(this.controlFindingGenerator);
    }

    public final String controlFindingGeneratorAsString() {
        return this.controlFindingGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableControls());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlFindingGeneratorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityHubConfigurationRequest)) {
            return false;
        }
        UpdateSecurityHubConfigurationRequest other = (UpdateSecurityHubConfigurationRequest)((Object)obj);
        return Objects.equals(this.autoEnableControls(), other.autoEnableControls()) && Objects.equals(this.controlFindingGeneratorAsString(), other.controlFindingGeneratorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityHubConfigurationRequest").add("AutoEnableControls", (Object)this.autoEnableControls()).add("ControlFindingGenerator", (Object)this.controlFindingGeneratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnableControls": {
                return Optional.ofNullable(clazz.cast(this.autoEnableControls()));
            }
            case "ControlFindingGenerator": {
                return Optional.ofNullable(clazz.cast(this.controlFindingGeneratorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityHubConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSecurityHubConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private Boolean autoEnableControls;
        private String controlFindingGenerator;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityHubConfigurationRequest model) {
            super(model);
            this.autoEnableControls(model.autoEnableControls);
            this.controlFindingGenerator(model.controlFindingGenerator);
        }

        public final Boolean getAutoEnableControls() {
            return this.autoEnableControls;
        }

        public final void setAutoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
        }

        @Override
        public final Builder autoEnableControls(Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        public final String getControlFindingGenerator() {
            return this.controlFindingGenerator;
        }

        public final void setControlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
        }

        @Override
        public final Builder controlFindingGenerator(String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
            return this;
        }

        @Override
        public final Builder controlFindingGenerator(ControlFindingGenerator controlFindingGenerator) {
            this.controlFindingGenerator(controlFindingGenerator == null ? null : controlFindingGenerator.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityHubConfigurationRequest build() {
            return new UpdateSecurityHubConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityHubConfigurationRequest> {
        public Builder autoEnableControls(Boolean var1);

        public Builder controlFindingGenerator(String var1);

        public Builder controlFindingGenerator(ControlFindingGenerator var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

