/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails;
import software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetListCopier;
import software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails;
import software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetListCopier;
import software.amazon.awssdk.services.securityhub.model.VpcInfoPeeringOptionsDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VpcPeeringConnectionVpcInfoDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VpcPeeringConnectionVpcInfoDetails> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::cidrBlock)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()}).build();
    private static final SdkField<List<VpcInfoCidrBlockSetDetails>> CIDR_BLOCK_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrBlockSet").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::cidrBlockSet)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::cidrBlockSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcInfoCidrBlockSetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VpcInfoIpv6CidrBlockSetDetails>> IPV6_CIDR_BLOCK_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrBlockSet").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::ipv6CidrBlockSet)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::ipv6CidrBlockSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcInfoIpv6CidrBlockSetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::ownerId)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<VpcInfoPeeringOptionsDetails> PEERING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PeeringOptions").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::peeringOptions)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::peeringOptions)).constructor(VpcInfoPeeringOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringOptions").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::region)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsEc2VpcPeeringConnectionVpcInfoDetails.getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::vpcId)).setter(AwsEc2VpcPeeringConnectionVpcInfoDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, CIDR_BLOCK_SET_FIELD, IPV6_CIDR_BLOCK_SET_FIELD, OWNER_ID_FIELD, PEERING_OPTIONS_FIELD, REGION_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidrBlock;
    private final List<VpcInfoCidrBlockSetDetails> cidrBlockSet;
    private final List<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet;
    private final String ownerId;
    private final VpcInfoPeeringOptionsDetails peeringOptions;
    private final String region;
    private final String vpcId;

    private AwsEc2VpcPeeringConnectionVpcInfoDetails(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.cidrBlockSet = builder.cidrBlockSet;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final boolean hasCidrBlockSet() {
        return this.cidrBlockSet != null && !(this.cidrBlockSet instanceof SdkAutoConstructList);
    }

    public final List<VpcInfoCidrBlockSetDetails> cidrBlockSet() {
        return this.cidrBlockSet;
    }

    public final boolean hasIpv6CidrBlockSet() {
        return this.ipv6CidrBlockSet != null && !(this.ipv6CidrBlockSet instanceof SdkAutoConstructList);
    }

    public final List<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet() {
        return this.ipv6CidrBlockSet;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final VpcInfoPeeringOptionsDetails peeringOptions() {
        return this.peeringOptions;
    }

    public final String region() {
        return this.region;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrBlockSet() ? this.cidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrBlockSet() ? this.ipv6CidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcPeeringConnectionVpcInfoDetails)) {
            return false;
        }
        AwsEc2VpcPeeringConnectionVpcInfoDetails other = (AwsEc2VpcPeeringConnectionVpcInfoDetails)obj;
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && this.hasCidrBlockSet() == other.hasCidrBlockSet() && Objects.equals(this.cidrBlockSet(), other.cidrBlockSet()) && this.hasIpv6CidrBlockSet() == other.hasIpv6CidrBlockSet() && Objects.equals(this.ipv6CidrBlockSet(), other.ipv6CidrBlockSet()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.peeringOptions(), other.peeringOptions()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VpcPeeringConnectionVpcInfoDetails").add("CidrBlock", (Object)this.cidrBlock()).add("CidrBlockSet", this.hasCidrBlockSet() ? this.cidrBlockSet() : null).add("Ipv6CidrBlockSet", this.hasIpv6CidrBlockSet() ? this.ipv6CidrBlockSet() : null).add("OwnerId", (Object)this.ownerId()).add("PeeringOptions", (Object)this.peeringOptions()).add("Region", (Object)this.region()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "CidrBlockSet": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockSet()));
            }
            case "Ipv6CidrBlockSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockSet()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PeeringOptions": {
                return Optional.ofNullable(clazz.cast(this.peeringOptions()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcPeeringConnectionVpcInfoDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcPeeringConnectionVpcInfoDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private List<VpcInfoCidrBlockSetDetails> cidrBlockSet = DefaultSdkAutoConstructList.getInstance();
        private List<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private VpcInfoPeeringOptionsDetails peeringOptions;
        private String region;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcPeeringConnectionVpcInfoDetails model) {
            this.cidrBlock(model.cidrBlock);
            this.cidrBlockSet(model.cidrBlockSet);
            this.ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            this.ownerId(model.ownerId);
            this.peeringOptions(model.peeringOptions);
            this.region(model.region);
            this.vpcId(model.vpcId);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final List<VpcInfoCidrBlockSetDetails.Builder> getCidrBlockSet() {
            List<VpcInfoCidrBlockSetDetails.Builder> result = VpcInfoCidrBlockSetListCopier.copyToBuilder(this.cidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockSet(Collection<VpcInfoCidrBlockSetDetails.BuilderImpl> cidrBlockSet) {
            this.cidrBlockSet = VpcInfoCidrBlockSetListCopier.copyFromBuilder(cidrBlockSet);
        }

        @Override
        public final Builder cidrBlockSet(Collection<VpcInfoCidrBlockSetDetails> cidrBlockSet) {
            this.cidrBlockSet = VpcInfoCidrBlockSetListCopier.copy(cidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(VpcInfoCidrBlockSetDetails ... cidrBlockSet) {
            this.cidrBlockSet(Arrays.asList(cidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(Consumer<VpcInfoCidrBlockSetDetails.Builder> ... cidrBlockSet) {
            this.cidrBlockSet(Stream.of(cidrBlockSet).map(c -> (VpcInfoCidrBlockSetDetails)((VpcInfoCidrBlockSetDetails.Builder)VpcInfoCidrBlockSetDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcInfoIpv6CidrBlockSetDetails.Builder> getIpv6CidrBlockSet() {
            List<VpcInfoIpv6CidrBlockSetDetails.Builder> result = VpcInfoIpv6CidrBlockSetListCopier.copyToBuilder(this.ipv6CidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockSet(Collection<VpcInfoIpv6CidrBlockSetDetails.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = VpcInfoIpv6CidrBlockSetListCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = VpcInfoIpv6CidrBlockSetListCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(VpcInfoIpv6CidrBlockSetDetails ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Consumer<VpcInfoIpv6CidrBlockSetDetails.Builder> ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Stream.of(ipv6CidrBlockSet).map(c -> (VpcInfoIpv6CidrBlockSetDetails)((VpcInfoIpv6CidrBlockSetDetails.Builder)VpcInfoIpv6CidrBlockSetDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final VpcInfoPeeringOptionsDetails.Builder getPeeringOptions() {
            return this.peeringOptions != null ? this.peeringOptions.toBuilder() : null;
        }

        public final void setPeeringOptions(VpcInfoPeeringOptionsDetails.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        @Override
        public final Builder peeringOptions(VpcInfoPeeringOptionsDetails peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public AwsEc2VpcPeeringConnectionVpcInfoDetails build() {
            return new AwsEc2VpcPeeringConnectionVpcInfoDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VpcPeeringConnectionVpcInfoDetails> {
        public Builder cidrBlock(String var1);

        public Builder cidrBlockSet(Collection<VpcInfoCidrBlockSetDetails> var1);

        public Builder cidrBlockSet(VpcInfoCidrBlockSetDetails ... var1);

        public Builder cidrBlockSet(Consumer<VpcInfoCidrBlockSetDetails.Builder> ... var1);

        public Builder ipv6CidrBlockSet(Collection<VpcInfoIpv6CidrBlockSetDetails> var1);

        public Builder ipv6CidrBlockSet(VpcInfoIpv6CidrBlockSetDetails ... var1);

        public Builder ipv6CidrBlockSet(Consumer<VpcInfoIpv6CidrBlockSetDetails.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder peeringOptions(VpcInfoPeeringOptionsDetails var1);

        default public Builder peeringOptions(Consumer<VpcInfoPeeringOptionsDetails.Builder> peeringOptions) {
            return this.peeringOptions((VpcInfoPeeringOptionsDetails)((VpcInfoPeeringOptionsDetails.Builder)VpcInfoPeeringOptionsDetails.builder().applyMutation(peeringOptions)).build());
        }

        public Builder region(String var1);

        public Builder vpcId(String var1);
    }
}

