/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesConfig;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesConfigListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule;
import software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAutomationRulesResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchGetAutomationRulesResponse> {
    private static final SdkField<List<AutomationRulesConfig>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(BatchGetAutomationRulesResponse.getter(BatchGetAutomationRulesResponse::rules)).setter(BatchGetAutomationRulesResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedAutomationRule>> UNPROCESSED_AUTOMATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAutomationRules").getter(BatchGetAutomationRulesResponse.getter(BatchGetAutomationRulesResponse::unprocessedAutomationRules)).setter(BatchGetAutomationRulesResponse.setter(Builder::unprocessedAutomationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAutomationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedAutomationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD, UNPROCESSED_AUTOMATION_RULES_FIELD));
    private final List<AutomationRulesConfig> rules;
    private final List<UnprocessedAutomationRule> unprocessedAutomationRules;

    private BatchGetAutomationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
        this.unprocessedAutomationRules = builder.unprocessedAutomationRules;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesConfig> rules() {
        return this.rules;
    }

    public final boolean hasUnprocessedAutomationRules() {
        return this.unprocessedAutomationRules != null && !(this.unprocessedAutomationRules instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedAutomationRule> unprocessedAutomationRules() {
        return this.unprocessedAutomationRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAutomationRules() ? this.unprocessedAutomationRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAutomationRulesResponse)) {
            return false;
        }
        BatchGetAutomationRulesResponse other = (BatchGetAutomationRulesResponse)((Object)obj);
        return this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasUnprocessedAutomationRules() == other.hasUnprocessedAutomationRules() && Objects.equals(this.unprocessedAutomationRules(), other.unprocessedAutomationRules());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAutomationRulesResponse").add("Rules", this.hasRules() ? this.rules() : null).add("UnprocessedAutomationRules", this.hasUnprocessedAutomationRules() ? this.unprocessedAutomationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "UnprocessedAutomationRules": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAutomationRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAutomationRulesResponse, T> g) {
        return obj -> g.apply((BatchGetAutomationRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<AutomationRulesConfig> rules = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedAutomationRule> unprocessedAutomationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAutomationRulesResponse model) {
            super(model);
            this.rules(model.rules);
            this.unprocessedAutomationRules(model.unprocessedAutomationRules);
        }

        public final List<AutomationRulesConfig.Builder> getRules() {
            List<AutomationRulesConfig.Builder> result = AutomationRulesConfigListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AutomationRulesConfig.BuilderImpl> rules) {
            this.rules = AutomationRulesConfigListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AutomationRulesConfig> rules) {
            this.rules = AutomationRulesConfigListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AutomationRulesConfig ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AutomationRulesConfig.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AutomationRulesConfig)((AutomationRulesConfig.Builder)AutomationRulesConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAutomationRule.Builder> getUnprocessedAutomationRules() {
            List<UnprocessedAutomationRule.Builder> result = UnprocessedAutomationRulesListCopier.copyToBuilder(this.unprocessedAutomationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAutomationRules(Collection<UnprocessedAutomationRule.BuilderImpl> unprocessedAutomationRules) {
            this.unprocessedAutomationRules = UnprocessedAutomationRulesListCopier.copyFromBuilder(unprocessedAutomationRules);
        }

        @Override
        public final Builder unprocessedAutomationRules(Collection<UnprocessedAutomationRule> unprocessedAutomationRules) {
            this.unprocessedAutomationRules = UnprocessedAutomationRulesListCopier.copy(unprocessedAutomationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAutomationRules(UnprocessedAutomationRule ... unprocessedAutomationRules) {
            this.unprocessedAutomationRules(Arrays.asList(unprocessedAutomationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAutomationRules(Consumer<UnprocessedAutomationRule.Builder> ... unprocessedAutomationRules) {
            this.unprocessedAutomationRules(Stream.of(unprocessedAutomationRules).map(c -> (UnprocessedAutomationRule)((UnprocessedAutomationRule.Builder)UnprocessedAutomationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAutomationRulesResponse build() {
            return new BatchGetAutomationRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAutomationRulesResponse> {
        public Builder rules(Collection<AutomationRulesConfig> var1);

        public Builder rules(AutomationRulesConfig ... var1);

        public Builder rules(Consumer<AutomationRulesConfig.Builder> ... var1);

        public Builder unprocessedAutomationRules(Collection<UnprocessedAutomationRule> var1);

        public Builder unprocessedAutomationRules(UnprocessedAutomationRule ... var1);

        public Builder unprocessedAutomationRules(Consumer<UnprocessedAutomationRule.Builder> ... var1);
    }
}

