/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.FindingAggregator;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse;

public class ListFindingAggregatorsIterable
implements SdkIterable<ListFindingAggregatorsResponse> {
    private final SecurityHubClient client;
    private final ListFindingAggregatorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingAggregatorsIterable(SecurityHubClient client, ListFindingAggregatorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFindingAggregatorsResponseFetcher();
    }

    public Iterator<ListFindingAggregatorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FindingAggregator> findingAggregators() {
        Function<ListFindingAggregatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingAggregators() != null) {
                return response.findingAggregators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFindingAggregatorsResponseFetcher
    implements SyncPageFetcher<ListFindingAggregatorsResponse> {
        private ListFindingAggregatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingAggregatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingAggregatorsResponse nextPage(ListFindingAggregatorsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingAggregatorsIterable.this.client.listFindingAggregators(ListFindingAggregatorsIterable.this.firstRequest);
            }
            return ListFindingAggregatorsIterable.this.client.listFindingAggregators((ListFindingAggregatorsRequest)((Object)ListFindingAggregatorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

