/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.VolumeMount;
import software.amazon.awssdk.services.securityhub.model.VolumeMountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDetails> {
    private static final SdkField<String> CONTAINER_RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerRuntime").getter(ContainerDetails.getter(ContainerDetails::containerRuntime)).setter(ContainerDetails.setter(Builder::containerRuntime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerRuntime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContainerDetails.getter(ContainerDetails::name)).setter(ContainerDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ContainerDetails.getter(ContainerDetails::imageId)).setter(ContainerDetails.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(ContainerDetails.getter(ContainerDetails::imageName)).setter(ContainerDetails.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchedAt").getter(ContainerDetails.getter(ContainerDetails::launchedAt)).setter(ContainerDetails.setter(Builder::launchedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()}).build();
    private static final SdkField<List<VolumeMount>> VOLUME_MOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VolumeMounts").getter(ContainerDetails.getter(ContainerDetails::volumeMounts)).setter(ContainerDetails.setter(Builder::volumeMounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeMounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeMount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Privileged").getter(ContainerDetails.getter(ContainerDetails::privileged)).setter(ContainerDetails.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privileged").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_RUNTIME_FIELD, NAME_FIELD, IMAGE_ID_FIELD, IMAGE_NAME_FIELD, LAUNCHED_AT_FIELD, VOLUME_MOUNTS_FIELD, PRIVILEGED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerRuntime;
    private final String name;
    private final String imageId;
    private final String imageName;
    private final String launchedAt;
    private final List<VolumeMount> volumeMounts;
    private final Boolean privileged;

    private ContainerDetails(BuilderImpl builder) {
        this.containerRuntime = builder.containerRuntime;
        this.name = builder.name;
        this.imageId = builder.imageId;
        this.imageName = builder.imageName;
        this.launchedAt = builder.launchedAt;
        this.volumeMounts = builder.volumeMounts;
        this.privileged = builder.privileged;
    }

    public final String containerRuntime() {
        return this.containerRuntime;
    }

    public final String name() {
        return this.name;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final String launchedAt() {
        return this.launchedAt;
    }

    public final boolean hasVolumeMounts() {
        return this.volumeMounts != null && !(this.volumeMounts instanceof SdkAutoConstructList);
    }

    public final List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRuntime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeMounts() ? this.volumeMounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetails)) {
            return false;
        }
        ContainerDetails other = (ContainerDetails)obj;
        return Objects.equals(this.containerRuntime(), other.containerRuntime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.launchedAt(), other.launchedAt()) && this.hasVolumeMounts() == other.hasVolumeMounts() && Objects.equals(this.volumeMounts(), other.volumeMounts()) && Objects.equals(this.privileged(), other.privileged());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDetails").add("ContainerRuntime", (Object)this.containerRuntime()).add("Name", (Object)this.name()).add("ImageId", (Object)this.imageId()).add("ImageName", (Object)this.imageName()).add("LaunchedAt", (Object)this.launchedAt()).add("VolumeMounts", this.hasVolumeMounts() ? this.volumeMounts() : null).add("Privileged", (Object)this.privileged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerRuntime": {
                return Optional.ofNullable(clazz.cast(this.containerRuntime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "LaunchedAt": {
                return Optional.ofNullable(clazz.cast(this.launchedAt()));
            }
            case "VolumeMounts": {
                return Optional.ofNullable(clazz.cast(this.volumeMounts()));
            }
            case "Privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDetails, T> g) {
        return obj -> g.apply((ContainerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerRuntime;
        private String name;
        private String imageId;
        private String imageName;
        private String launchedAt;
        private List<VolumeMount> volumeMounts = DefaultSdkAutoConstructList.getInstance();
        private Boolean privileged;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetails model) {
            this.containerRuntime(model.containerRuntime);
            this.name(model.name);
            this.imageId(model.imageId);
            this.imageName(model.imageName);
            this.launchedAt(model.launchedAt);
            this.volumeMounts(model.volumeMounts);
            this.privileged(model.privileged);
        }

        public final String getContainerRuntime() {
            return this.containerRuntime;
        }

        public final void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        @Override
        public final Builder containerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getLaunchedAt() {
            return this.launchedAt;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final List<VolumeMount.Builder> getVolumeMounts() {
            List<VolumeMount.Builder> result = VolumeMountListCopier.copyToBuilder(this.volumeMounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeMounts(Collection<VolumeMount.BuilderImpl> volumeMounts) {
            this.volumeMounts = VolumeMountListCopier.copyFromBuilder(volumeMounts);
        }

        @Override
        public final Builder volumeMounts(Collection<VolumeMount> volumeMounts) {
            this.volumeMounts = VolumeMountListCopier.copy(volumeMounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(VolumeMount ... volumeMounts) {
            this.volumeMounts(Arrays.asList(volumeMounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(Consumer<VolumeMount.Builder> ... volumeMounts) {
            this.volumeMounts(Stream.of(volumeMounts).map(c -> (VolumeMount)((VolumeMount.Builder)VolumeMount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public ContainerDetails build() {
            return new ContainerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDetails> {
        public Builder containerRuntime(String var1);

        public Builder name(String var1);

        public Builder imageId(String var1);

        public Builder imageName(String var1);

        public Builder launchedAt(String var1);

        public Builder volumeMounts(Collection<VolumeMount> var1);

        public Builder volumeMounts(VolumeMount ... var1);

        public Builder volumeMounts(Consumer<VolumeMount.Builder> ... var1);

        public Builder privileged(Boolean var1);
    }
}

