/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationPolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationPolicySummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ConfigurationPolicySummary.getter(ConfigurationPolicySummary::arn)).setter(ConfigurationPolicySummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigurationPolicySummary.getter(ConfigurationPolicySummary::id)).setter(ConfigurationPolicySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConfigurationPolicySummary.getter(ConfigurationPolicySummary::name)).setter(ConfigurationPolicySummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConfigurationPolicySummary.getter(ConfigurationPolicySummary::description)).setter(ConfigurationPolicySummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ConfigurationPolicySummary.getter(ConfigurationPolicySummary::updatedAt)).setter(ConfigurationPolicySummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> SERVICE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ServiceEnabled").getter(ConfigurationPolicySummary.getter(ConfigurationPolicySummary::serviceEnabled)).setter(ConfigurationPolicySummary.setter(Builder::serviceEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD, SERVICE_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String name;
    private final String description;
    private final Instant updatedAt;
    private final Boolean serviceEnabled;

    private ConfigurationPolicySummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
        this.serviceEnabled = builder.serviceEnabled;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Boolean serviceEnabled() {
        return this.serviceEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationPolicySummary)) {
            return false;
        }
        ConfigurationPolicySummary other = (ConfigurationPolicySummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.serviceEnabled(), other.serviceEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationPolicySummary").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("UpdatedAt", (Object)this.updatedAt()).add("ServiceEnabled", (Object)this.serviceEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "ServiceEnabled": {
                return Optional.ofNullable(clazz.cast(this.serviceEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationPolicySummary, T> g) {
        return obj -> g.apply((ConfigurationPolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String description;
        private Instant updatedAt;
        private Boolean serviceEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationPolicySummary model) {
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.updatedAt(model.updatedAt);
            this.serviceEnabled(model.serviceEnabled);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Boolean getServiceEnabled() {
            return this.serviceEnabled;
        }

        public final void setServiceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
        }

        @Override
        public final Builder serviceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
            return this;
        }

        public ConfigurationPolicySummary build() {
            return new ConfigurationPolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationPolicySummary> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder updatedAt(Instant var1);

        public Builder serviceEnabled(Boolean var1);
    }
}

