/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionOriginCustomOriginConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionOriginCustomOriginConfig> {
    private static final SdkField<Integer> HTTP_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPort").getter(AwsCloudFrontDistributionOriginCustomOriginConfig.getter(AwsCloudFrontDistributionOriginCustomOriginConfig::httpPort)).setter(AwsCloudFrontDistributionOriginCustomOriginConfig.setter(Builder::httpPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPort").build()}).build();
    private static final SdkField<Integer> HTTPS_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpsPort").getter(AwsCloudFrontDistributionOriginCustomOriginConfig.getter(AwsCloudFrontDistributionOriginCustomOriginConfig::httpsPort)).setter(AwsCloudFrontDistributionOriginCustomOriginConfig.setter(Builder::httpsPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpsPort").build()}).build();
    private static final SdkField<Integer> ORIGIN_KEEPALIVE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OriginKeepaliveTimeout").getter(AwsCloudFrontDistributionOriginCustomOriginConfig.getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originKeepaliveTimeout)).setter(AwsCloudFrontDistributionOriginCustomOriginConfig.setter(Builder::originKeepaliveTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginKeepaliveTimeout").build()}).build();
    private static final SdkField<String> ORIGIN_PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginProtocolPolicy").getter(AwsCloudFrontDistributionOriginCustomOriginConfig.getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originProtocolPolicy)).setter(AwsCloudFrontDistributionOriginCustomOriginConfig.setter(Builder::originProtocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginProtocolPolicy").build()}).build();
    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OriginReadTimeout").getter(AwsCloudFrontDistributionOriginCustomOriginConfig.getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originReadTimeout)).setter(AwsCloudFrontDistributionOriginCustomOriginConfig.setter(Builder::originReadTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout").build()}).build();
    private static final SdkField<AwsCloudFrontDistributionOriginSslProtocols> ORIGIN_SSL_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginSslProtocols").getter(AwsCloudFrontDistributionOriginCustomOriginConfig.getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originSslProtocols)).setter(AwsCloudFrontDistributionOriginCustomOriginConfig.setter(Builder::originSslProtocols)).constructor(AwsCloudFrontDistributionOriginSslProtocols::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSslProtocols").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_PORT_FIELD, HTTPS_PORT_FIELD, ORIGIN_KEEPALIVE_TIMEOUT_FIELD, ORIGIN_PROTOCOL_POLICY_FIELD, ORIGIN_READ_TIMEOUT_FIELD, ORIGIN_SSL_PROTOCOLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer httpPort;
    private final Integer httpsPort;
    private final Integer originKeepaliveTimeout;
    private final String originProtocolPolicy;
    private final Integer originReadTimeout;
    private final AwsCloudFrontDistributionOriginSslProtocols originSslProtocols;

    private AwsCloudFrontDistributionOriginCustomOriginConfig(BuilderImpl builder) {
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originReadTimeout = builder.originReadTimeout;
        this.originSslProtocols = builder.originSslProtocols;
    }

    public final Integer httpPort() {
        return this.httpPort;
    }

    public final Integer httpsPort() {
        return this.httpsPort;
    }

    public final Integer originKeepaliveTimeout() {
        return this.originKeepaliveTimeout;
    }

    public final String originProtocolPolicy() {
        return this.originProtocolPolicy;
    }

    public final Integer originReadTimeout() {
        return this.originReadTimeout;
    }

    public final AwsCloudFrontDistributionOriginSslProtocols originSslProtocols() {
        return this.originSslProtocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.originKeepaliveTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.originProtocolPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.originReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.originSslProtocols());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginCustomOriginConfig)) {
            return false;
        }
        AwsCloudFrontDistributionOriginCustomOriginConfig other = (AwsCloudFrontDistributionOriginCustomOriginConfig)obj;
        return Objects.equals(this.httpPort(), other.httpPort()) && Objects.equals(this.httpsPort(), other.httpsPort()) && Objects.equals(this.originKeepaliveTimeout(), other.originKeepaliveTimeout()) && Objects.equals(this.originProtocolPolicy(), other.originProtocolPolicy()) && Objects.equals(this.originReadTimeout(), other.originReadTimeout()) && Objects.equals(this.originSslProtocols(), other.originSslProtocols());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionOriginCustomOriginConfig").add("HttpPort", (Object)this.httpPort()).add("HttpsPort", (Object)this.httpsPort()).add("OriginKeepaliveTimeout", (Object)this.originKeepaliveTimeout()).add("OriginProtocolPolicy", (Object)this.originProtocolPolicy()).add("OriginReadTimeout", (Object)this.originReadTimeout()).add("OriginSslProtocols", (Object)this.originSslProtocols()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpPort": {
                return Optional.ofNullable(clazz.cast(this.httpPort()));
            }
            case "HttpsPort": {
                return Optional.ofNullable(clazz.cast(this.httpsPort()));
            }
            case "OriginKeepaliveTimeout": {
                return Optional.ofNullable(clazz.cast(this.originKeepaliveTimeout()));
            }
            case "OriginProtocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.originProtocolPolicy()));
            }
            case "OriginReadTimeout": {
                return Optional.ofNullable(clazz.cast(this.originReadTimeout()));
            }
            case "OriginSslProtocols": {
                return Optional.ofNullable(clazz.cast(this.originSslProtocols()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginCustomOriginConfig, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginCustomOriginConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer httpPort;
        private Integer httpsPort;
        private Integer originKeepaliveTimeout;
        private String originProtocolPolicy;
        private Integer originReadTimeout;
        private AwsCloudFrontDistributionOriginSslProtocols originSslProtocols;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginCustomOriginConfig model) {
            this.httpPort(model.httpPort);
            this.httpsPort(model.httpsPort);
            this.originKeepaliveTimeout(model.originKeepaliveTimeout);
            this.originProtocolPolicy(model.originProtocolPolicy);
            this.originReadTimeout(model.originReadTimeout);
            this.originSslProtocols(model.originSslProtocols);
        }

        public final Integer getHttpPort() {
            return this.httpPort;
        }

        public final void setHttpPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final Integer getHttpsPort() {
            return this.httpsPort;
        }

        public final void setHttpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return this.originKeepaliveTimeout;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        public final String getOriginProtocolPolicy() {
            return this.originProtocolPolicy;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        public final Integer getOriginReadTimeout() {
            return this.originReadTimeout;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final AwsCloudFrontDistributionOriginSslProtocols.Builder getOriginSslProtocols() {
            return this.originSslProtocols != null ? this.originSslProtocols.toBuilder() : null;
        }

        public final void setOriginSslProtocols(AwsCloudFrontDistributionOriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        @Override
        public final Builder originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        public AwsCloudFrontDistributionOriginCustomOriginConfig build() {
            return new AwsCloudFrontDistributionOriginCustomOriginConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionOriginCustomOriginConfig> {
        public Builder httpPort(Integer var1);

        public Builder httpsPort(Integer var1);

        public Builder originKeepaliveTimeout(Integer var1);

        public Builder originProtocolPolicy(String var1);

        public Builder originReadTimeout(Integer var1);

        public Builder originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols var1);

        default public Builder originSslProtocols(Consumer<AwsCloudFrontDistributionOriginSslProtocols.Builder> originSslProtocols) {
            return this.originSslProtocols((AwsCloudFrontDistributionOriginSslProtocols)((AwsCloudFrontDistributionOriginSslProtocols.Builder)AwsCloudFrontDistributionOriginSslProtocols.builder().applyMutation(originSslProtocols)).build());
        }
    }
}

