/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityControlProperty {
    PARAMETERS("Parameters"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityControlProperty> VALUE_MAP;
    private final String value;

    private SecurityControlProperty(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityControlProperty fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityControlProperty> knownValues() {
        EnumSet<SecurityControlProperty> knownValues = EnumSet.allOf(SecurityControlProperty.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityControlProperty.class, SecurityControlProperty::toString);
    }
}

