/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest;
import software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse;
import software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition;

public class ListSecurityControlDefinitionsPublisher
implements SdkPublisher<ListSecurityControlDefinitionsResponse> {
    private final SecurityHubAsyncClient client;
    private final ListSecurityControlDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityControlDefinitionsPublisher(SecurityHubAsyncClient client, ListSecurityControlDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityControlDefinitionsPublisher(SecurityHubAsyncClient client, ListSecurityControlDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityControlDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityControlDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityControlDefinition> securityControlDefinitions() {
        Function<ListSecurityControlDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityControlDefinitions() != null) {
                return response.securityControlDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityControlDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityControlDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListSecurityControlDefinitionsResponse> {
        private ListSecurityControlDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityControlDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityControlDefinitionsResponse> nextPage(ListSecurityControlDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityControlDefinitionsPublisher.this.client.listSecurityControlDefinitions(ListSecurityControlDefinitionsPublisher.this.firstRequest);
            }
            return ListSecurityControlDefinitionsPublisher.this.client.listSecurityControlDefinitions((ListSecurityControlDefinitionsRequest)((Object)ListSecurityControlDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

