/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilePaths
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilePaths> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilePath").getter(FilePaths.getter(FilePaths::filePath)).setter(FilePaths.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(FilePaths.getter(FilePaths::fileName)).setter(FilePaths.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(FilePaths.getter(FilePaths::resourceId)).setter(FilePaths.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(FilePaths.getter(FilePaths::hash)).setter(FilePaths.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, FILE_NAME_FIELD, RESOURCE_ID_FIELD, HASH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String fileName;
    private final String resourceId;
    private final String hash;

    private FilePaths(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.fileName = builder.fileName;
        this.resourceId = builder.resourceId;
        this.hash = builder.hash;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String hash() {
        return this.hash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilePaths)) {
            return false;
        }
        FilePaths other = (FilePaths)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.hash(), other.hash());
    }

    public final String toString() {
        return ToString.builder((String)"FilePaths").add("FilePath", (Object)this.filePath()).add("FileName", (Object)this.fileName()).add("ResourceId", (Object)this.resourceId()).add("Hash", (Object)this.hash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilePaths, T> g) {
        return obj -> g.apply((FilePaths)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private String fileName;
        private String resourceId;
        private String hash;

        private BuilderImpl() {
        }

        private BuilderImpl(FilePaths model) {
            this.filePath(model.filePath);
            this.fileName(model.fileName);
            this.resourceId(model.resourceId);
            this.hash(model.hash);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public FilePaths build() {
            return new FilePaths(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilePaths> {
        public Builder filePath(String var1);

        public Builder fileName(String var1);

        public Builder resourceId(String var1);

        public Builder hash(String var1);
    }
}

