/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;

public class ListEnabledProductsForImportPublisher
implements SdkPublisher<ListEnabledProductsForImportResponse> {
    private final SecurityHubAsyncClient client;
    private final ListEnabledProductsForImportRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnabledProductsForImportPublisher(SecurityHubAsyncClient client, ListEnabledProductsForImportRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnabledProductsForImportPublisher(SecurityHubAsyncClient client, ListEnabledProductsForImportRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnabledProductsForImportResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnabledProductsForImportResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> productSubscriptions() {
        Function<ListEnabledProductsForImportResponse, Iterator> getIterator = response -> {
            if (response != null && response.productSubscriptions() != null) {
                return response.productSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnabledProductsForImportResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnabledProductsForImportResponseFetcher
    implements AsyncPageFetcher<ListEnabledProductsForImportResponse> {
        private ListEnabledProductsForImportResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledProductsForImportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnabledProductsForImportResponse> nextPage(ListEnabledProductsForImportResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledProductsForImportPublisher.this.client.listEnabledProductsForImport(ListEnabledProductsForImportPublisher.this.firstRequest);
            }
            return ListEnabledProductsForImportPublisher.this.client.listEnabledProductsForImport((ListEnabledProductsForImportRequest)((Object)ListEnabledProductsForImportPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

