/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.IntegerListCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterValue> {
    private static final SdkField<Integer> INTEGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Integer").getter(ParameterValue.getter(ParameterValue::integer)).setter(ParameterValue.setter(Builder::integer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integer").build()}).build();
    private static final SdkField<List<Integer>> INTEGER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegerList").getter(ParameterValue.getter(ParameterValue::integerList)).setter(ParameterValue.setter(Builder::integerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> DOUBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Double").getter(ParameterValue.getter(ParameterValue::doubleValue)).setter(ParameterValue.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Double").build()}).build();
    private static final SdkField<String> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("String").getter(ParameterValue.getter(ParameterValue::string)).setter(ParameterValue.setter(Builder::string)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()}).build();
    private static final SdkField<List<String>> STRING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringList").getter(ParameterValue.getter(ParameterValue::stringList)).setter(ParameterValue.setter(Builder::stringList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> BOOLEAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Boolean").getter(ParameterValue.getter(ParameterValue::booleanValue)).setter(ParameterValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Boolean").build()}).build();
    private static final SdkField<String> ENUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enum").getter(ParameterValue.getter(ParameterValue::enumValue)).setter(ParameterValue.setter(Builder::enumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enum").build()}).build();
    private static final SdkField<List<String>> ENUM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnumList").getter(ParameterValue.getter(ParameterValue::enumList)).setter(ParameterValue.setter(Builder::enumList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnumList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_FIELD, INTEGER_LIST_FIELD, DOUBLE_FIELD, STRING_FIELD, STRING_LIST_FIELD, BOOLEAN_FIELD, ENUM_FIELD, ENUM_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer integer;
    private final List<Integer> integerList;
    private final Double doubleValue;
    private final String string;
    private final List<String> stringList;
    private final Boolean booleanValue;
    private final String enumValue;
    private final List<String> enumList;
    private final Type type;

    private ParameterValue(BuilderImpl builder) {
        this.integer = builder.integer;
        this.integerList = builder.integerList;
        this.doubleValue = builder.doubleValue;
        this.string = builder.string;
        this.stringList = builder.stringList;
        this.booleanValue = builder.booleanValue;
        this.enumValue = builder.enumValue;
        this.enumList = builder.enumList;
        this.type = builder.type;
    }

    public final Integer integer() {
        return this.integer;
    }

    public final boolean hasIntegerList() {
        return this.integerList != null && !(this.integerList instanceof SdkAutoConstructList);
    }

    public final List<Integer> integerList() {
        return this.integerList;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final String string() {
        return this.string;
    }

    public final boolean hasStringList() {
        return this.stringList != null && !(this.stringList instanceof SdkAutoConstructList);
    }

    public final List<String> stringList() {
        return this.stringList;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final String enumValue() {
        return this.enumValue;
    }

    public final boolean hasEnumList() {
        return this.enumList != null && !(this.enumList instanceof SdkAutoConstructList);
    }

    public final List<String> enumList() {
        return this.enumList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerList() ? this.integerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringList() ? this.stringList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnumList() ? this.enumList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterValue)) {
            return false;
        }
        ParameterValue other = (ParameterValue)obj;
        return Objects.equals(this.integer(), other.integer()) && this.hasIntegerList() == other.hasIntegerList() && Objects.equals(this.integerList(), other.integerList()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.string(), other.string()) && this.hasStringList() == other.hasStringList() && Objects.equals(this.stringList(), other.stringList()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.enumValue(), other.enumValue()) && this.hasEnumList() == other.hasEnumList() && Objects.equals(this.enumList(), other.enumList());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterValue").add("Integer", (Object)this.integer()).add("IntegerList", this.hasIntegerList() ? this.integerList() : null).add("Double", (Object)this.doubleValue()).add("String", (Object)this.string()).add("StringList", this.hasStringList() ? this.stringList() : null).add("Boolean", (Object)this.booleanValue()).add("Enum", (Object)this.enumValue()).add("EnumList", this.hasEnumList() ? this.enumList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Integer": {
                return Optional.ofNullable(clazz.cast(this.integer()));
            }
            case "IntegerList": {
                return Optional.ofNullable(clazz.cast(this.integerList()));
            }
            case "Double": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "String": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
            case "StringList": {
                return Optional.ofNullable(clazz.cast(this.stringList()));
            }
            case "Boolean": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "Enum": {
                return Optional.ofNullable(clazz.cast(this.enumValue()));
            }
            case "EnumList": {
                return Optional.ofNullable(clazz.cast(this.enumList()));
            }
        }
        return Optional.empty();
    }

    public static ParameterValue fromInteger(Integer integer) {
        return (ParameterValue)ParameterValue.builder().integer(integer).build();
    }

    public static ParameterValue fromIntegerList(List<Integer> integerList) {
        return (ParameterValue)ParameterValue.builder().integerList(integerList).build();
    }

    public static ParameterValue fromDoubleValue(Double doubleValue) {
        return (ParameterValue)ParameterValue.builder().doubleValue(doubleValue).build();
    }

    public static ParameterValue fromString(String string) {
        return (ParameterValue)ParameterValue.builder().string(string).build();
    }

    public static ParameterValue fromStringList(List<String> stringList) {
        return (ParameterValue)ParameterValue.builder().stringList(stringList).build();
    }

    public static ParameterValue fromBooleanValue(Boolean booleanValue) {
        return (ParameterValue)ParameterValue.builder().booleanValue(booleanValue).build();
    }

    public static ParameterValue fromEnumValue(String enumValue) {
        return (ParameterValue)ParameterValue.builder().enumValue(enumValue).build();
    }

    public static ParameterValue fromEnumList(List<String> enumList) {
        return (ParameterValue)ParameterValue.builder().enumList(enumList).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterValue, T> g) {
        return obj -> g.apply((ParameterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTEGER,
        INTEGER_LIST,
        DOUBLE,
        STRING,
        STRING_LIST,
        BOOLEAN,
        ENUM,
        ENUM_LIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Integer integer;
        private List<Integer> integerList = DefaultSdkAutoConstructList.getInstance();
        private Double doubleValue;
        private String string;
        private List<String> stringList = DefaultSdkAutoConstructList.getInstance();
        private Boolean booleanValue;
        private String enumValue;
        private List<String> enumList = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterValue model) {
            this.integer(model.integer);
            this.integerList(model.integerList);
            this.doubleValue(model.doubleValue);
            this.string(model.string);
            this.stringList(model.stringList);
            this.booleanValue(model.booleanValue);
            this.enumValue(model.enumValue);
            this.enumList(model.enumList);
        }

        public final Integer getInteger() {
            return this.integer;
        }

        public final void setInteger(Integer integer) {
            Integer oldValue = this.integer;
            this.integer = integer;
            this.handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
        }

        @Override
        public final Builder integer(Integer integer) {
            Integer oldValue = this.integer;
            this.integer = integer;
            this.handleUnionValueChange(Type.INTEGER, oldValue, this.integer);
            return this;
        }

        public final Collection<Integer> getIntegerList() {
            if (this.integerList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integerList;
        }

        public final void setIntegerList(Collection<Integer> integerList) {
            List<Integer> oldValue = this.integerList;
            this.integerList = IntegerListCopier.copy(integerList);
            this.handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
        }

        @Override
        public final Builder integerList(Collection<Integer> integerList) {
            List<Integer> oldValue = this.integerList;
            this.integerList = IntegerListCopier.copy(integerList);
            this.handleUnionValueChange(Type.INTEGER_LIST, oldValue, this.integerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerList(Integer ... integerList) {
            this.integerList(Arrays.asList(integerList));
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE, oldValue, this.doubleValue);
            return this;
        }

        public final String getString() {
            return this.string;
        }

        public final void setString(String string) {
            String oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(String string) {
            String oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final Collection<String> getStringList() {
            if (this.stringList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringList;
        }

        public final void setStringList(Collection<String> stringList) {
            List<String> oldValue = this.stringList;
            this.stringList = StringListCopier.copy(stringList);
            this.handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
        }

        @Override
        public final Builder stringList(Collection<String> stringList) {
            List<String> oldValue = this.stringList;
            this.stringList = StringListCopier.copy(stringList);
            this.handleUnionValueChange(Type.STRING_LIST, oldValue, this.stringList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringList(String ... stringList) {
            this.stringList(Arrays.asList(stringList));
            return this;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
            return this;
        }

        public final String getEnumValue() {
            return this.enumValue;
        }

        public final void setEnumValue(String enumValue) {
            String oldValue = this.enumValue;
            this.enumValue = enumValue;
            this.handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
        }

        @Override
        public final Builder enumValue(String enumValue) {
            String oldValue = this.enumValue;
            this.enumValue = enumValue;
            this.handleUnionValueChange(Type.ENUM, oldValue, this.enumValue);
            return this;
        }

        public final Collection<String> getEnumList() {
            if (this.enumList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enumList;
        }

        public final void setEnumList(Collection<String> enumList) {
            List<String> oldValue = this.enumList;
            this.enumList = StringListCopier.copy(enumList);
            this.handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
        }

        @Override
        public final Builder enumList(Collection<String> enumList) {
            List<String> oldValue = this.enumList;
            this.enumList = StringListCopier.copy(enumList);
            this.handleUnionValueChange(Type.ENUM_LIST, oldValue, this.enumList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumList(String ... enumList) {
            this.enumList(Arrays.asList(enumList));
            return this;
        }

        public ParameterValue build() {
            return new ParameterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterValue> {
        public Builder integer(Integer var1);

        public Builder integerList(Collection<Integer> var1);

        public Builder integerList(Integer ... var1);

        public Builder doubleValue(Double var1);

        public Builder string(String var1);

        public Builder stringList(Collection<String> var1);

        public Builder stringList(String ... var1);

        public Builder booleanValue(Boolean var1);

        public Builder enumValue(String var1);

        public Builder enumList(Collection<String> var1);

        public Builder enumList(String ... var1);
    }
}

