/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ActionTarget;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;

public class DescribeActionTargetsIterable
implements SdkIterable<DescribeActionTargetsResponse> {
    private final SecurityHubClient client;
    private final DescribeActionTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeActionTargetsIterable(SecurityHubClient client, DescribeActionTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeActionTargetsResponseFetcher();
    }

    public Iterator<DescribeActionTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionTarget> actionTargets() {
        Function<DescribeActionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionTargets() != null) {
                return response.actionTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeActionTargetsResponseFetcher
    implements SyncPageFetcher<DescribeActionTargetsResponse> {
        private DescribeActionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeActionTargetsResponse nextPage(DescribeActionTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActionTargetsIterable.this.client.describeActionTargets(DescribeActionTargetsIterable.this.firstRequest);
            }
            return DescribeActionTargetsIterable.this.client.describeActionTargets((DescribeActionTargetsRequest)((Object)DescribeActionTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

