/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicySummary;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesResponse;

public class ListConfigurationPoliciesIterable
implements SdkIterable<ListConfigurationPoliciesResponse> {
    private final SecurityHubClient client;
    private final ListConfigurationPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationPoliciesIterable(SecurityHubClient client, ListConfigurationPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationPoliciesResponseFetcher();
    }

    public Iterator<ListConfigurationPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationPolicySummary> configurationPolicySummaries() {
        Function<ListConfigurationPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationPolicySummaries() != null) {
                return response.configurationPolicySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationPoliciesResponseFetcher
    implements SyncPageFetcher<ListConfigurationPoliciesResponse> {
        private ListConfigurationPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationPoliciesResponse nextPage(ListConfigurationPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationPoliciesIterable.this.client.listConfigurationPolicies(ListConfigurationPoliciesIterable.this.firstRequest);
            }
            return ListConfigurationPoliciesIterable.this.client.listConfigurationPolicies((ListConfigurationPoliciesRequest)((Object)ListConfigurationPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

