/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2InstanceMetadataOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2InstanceMetadataOptions> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(AwsEc2InstanceMetadataOptions.getter(AwsEc2InstanceMetadataOptions::httpEndpoint)).setter(AwsEc2InstanceMetadataOptions.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()}).build();
    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpProtocolIpv6").getter(AwsEc2InstanceMetadataOptions.getter(AwsEc2InstanceMetadataOptions::httpProtocolIpv6)).setter(AwsEc2InstanceMetadataOptions.setter(Builder::httpProtocolIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpProtocolIpv6").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit").getter(AwsEc2InstanceMetadataOptions.getter(AwsEc2InstanceMetadataOptions::httpPutResponseHopLimit)).setter(AwsEc2InstanceMetadataOptions.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTokens").getter(AwsEc2InstanceMetadataOptions.getter(AwsEc2InstanceMetadataOptions::httpTokens)).setter(AwsEc2InstanceMetadataOptions.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()}).build();
    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMetadataTags").getter(AwsEc2InstanceMetadataOptions.getter(AwsEc2InstanceMetadataOptions::instanceMetadataTags)).setter(AwsEc2InstanceMetadataOptions.setter(Builder::instanceMetadataTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD, HTTP_PROTOCOL_IPV6_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_TOKENS_FIELD, INSTANCE_METADATA_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String httpEndpoint;
    private final String httpProtocolIpv6;
    private final Integer httpPutResponseHopLimit;
    private final String httpTokens;
    private final String instanceMetadataTags;

    private AwsEc2InstanceMetadataOptions(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpTokens = builder.httpTokens;
        this.instanceMetadataTags = builder.instanceMetadataTags;
    }

    public final String httpEndpoint() {
        return this.httpEndpoint;
    }

    public final String httpProtocolIpv6() {
        return this.httpProtocolIpv6;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final String httpTokens() {
        return this.httpTokens;
    }

    public final String instanceMetadataTags() {
        return this.instanceMetadataTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpProtocolIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataTags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceMetadataOptions)) {
            return false;
        }
        AwsEc2InstanceMetadataOptions other = (AwsEc2InstanceMetadataOptions)obj;
        return Objects.equals(this.httpEndpoint(), other.httpEndpoint()) && Objects.equals(this.httpProtocolIpv6(), other.httpProtocolIpv6()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpTokens(), other.httpTokens()) && Objects.equals(this.instanceMetadataTags(), other.instanceMetadataTags());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2InstanceMetadataOptions").add("HttpEndpoint", (Object)this.httpEndpoint()).add("HttpProtocolIpv6", (Object)this.httpProtocolIpv6()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpTokens", (Object)this.httpTokens()).add("InstanceMetadataTags", (Object)this.instanceMetadataTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpoint()));
            }
            case "HttpProtocolIpv6": {
                return Optional.ofNullable(clazz.cast(this.httpProtocolIpv6()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokens()));
            }
            case "InstanceMetadataTags": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceMetadataOptions, T> g) {
        return obj -> g.apply((AwsEc2InstanceMetadataOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpEndpoint;
        private String httpProtocolIpv6;
        private Integer httpPutResponseHopLimit;
        private String httpTokens;
        private String instanceMetadataTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceMetadataOptions model) {
            this.httpEndpoint(model.httpEndpoint);
            this.httpProtocolIpv6(model.httpProtocolIpv6);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpTokens(model.httpTokens);
            this.instanceMetadataTags(model.instanceMetadataTags);
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return this.httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        public final String getInstanceMetadataTags() {
            return this.instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        public AwsEc2InstanceMetadataOptions build() {
            return new AwsEc2InstanceMetadataOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2InstanceMetadataOptions> {
        public Builder httpEndpoint(String var1);

        public Builder httpProtocolIpv6(String var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpTokens(String var1);

        public Builder instanceMetadataTags(String var1);
    }
}

