/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2LaunchTemplateDataMetadataOptionsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2LaunchTemplateDataMetadataOptionsDetails> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpEndpoint)).setter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()}).build();
    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpProtocolIpv6").getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpProtocolIpv6)).setter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.setter(Builder::httpProtocolIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpProtocolIpv6").build()}).build();
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTokens").getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpTokens)).setter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit").getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpPutResponseHopLimit)).setter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMetadataTags").getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::instanceMetadataTags)).setter(AwsEc2LaunchTemplateDataMetadataOptionsDetails.setter(Builder::instanceMetadataTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD, HTTP_PROTOCOL_IPV6_FIELD, HTTP_TOKENS_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, INSTANCE_METADATA_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String httpEndpoint;
    private final String httpProtocolIpv6;
    private final String httpTokens;
    private final Integer httpPutResponseHopLimit;
    private final String instanceMetadataTags;

    private AwsEc2LaunchTemplateDataMetadataOptionsDetails(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.instanceMetadataTags = builder.instanceMetadataTags;
    }

    public final String httpEndpoint() {
        return this.httpEndpoint;
    }

    public final String httpProtocolIpv6() {
        return this.httpProtocolIpv6;
    }

    public final String httpTokens() {
        return this.httpTokens;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final String instanceMetadataTags() {
        return this.instanceMetadataTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpProtocolIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataTags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataMetadataOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataMetadataOptionsDetails other = (AwsEc2LaunchTemplateDataMetadataOptionsDetails)obj;
        return Objects.equals(this.httpEndpoint(), other.httpEndpoint()) && Objects.equals(this.httpProtocolIpv6(), other.httpProtocolIpv6()) && Objects.equals(this.httpTokens(), other.httpTokens()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.instanceMetadataTags(), other.instanceMetadataTags());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2LaunchTemplateDataMetadataOptionsDetails").add("HttpEndpoint", (Object)this.httpEndpoint()).add("HttpProtocolIpv6", (Object)this.httpProtocolIpv6()).add("HttpTokens", (Object)this.httpTokens()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("InstanceMetadataTags", (Object)this.instanceMetadataTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpoint()));
            }
            case "HttpProtocolIpv6": {
                return Optional.ofNullable(clazz.cast(this.httpProtocolIpv6()));
            }
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokens()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "InstanceMetadataTags": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataMetadataOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataMetadataOptionsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpEndpoint;
        private String httpProtocolIpv6;
        private String httpTokens;
        private Integer httpPutResponseHopLimit;
        private String instanceMetadataTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataMetadataOptionsDetails model) {
            this.httpEndpoint(model.httpEndpoint);
            this.httpProtocolIpv6(model.httpProtocolIpv6);
            this.httpTokens(model.httpTokens);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.instanceMetadataTags(model.instanceMetadataTags);
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return this.httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getInstanceMetadataTags() {
            return this.instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        public AwsEc2LaunchTemplateDataMetadataOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataMetadataOptionsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2LaunchTemplateDataMetadataOptionsDetails> {
        public Builder httpEndpoint(String var1);

        public Builder httpProtocolIpv6(String var1);

        public Builder httpTokens(String var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder instanceMetadataTags(String var1);
    }
}

