/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stateless rules and custom actions for a stateless rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRulesAndCustomActionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder, RuleGroupSourceStatelessRulesAndCustomActionsDetails> {
    private static final SdkField<List<RuleGroupSourceCustomActionsDetails>> CUSTOM_ACTIONS_FIELD = SdkField
            .<List<RuleGroupSourceCustomActionsDetails>> builder(MarshallingType.LIST)
            .memberName("CustomActions")
            .getter(getter(RuleGroupSourceStatelessRulesAndCustomActionsDetails::customActions))
            .setter(setter(Builder::customActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceCustomActionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceCustomActionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleGroupSourceStatelessRulesDetails>> STATELESS_RULES_FIELD = SdkField
            .<List<RuleGroupSourceStatelessRulesDetails>> builder(MarshallingType.LIST)
            .memberName("StatelessRules")
            .getter(getter(RuleGroupSourceStatelessRulesAndCustomActionsDetails::statelessRules))
            .setter(setter(Builder::statelessRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatelessRulesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatelessRulesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTIONS_FIELD,
            STATELESS_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RuleGroupSourceCustomActionsDetails> customActions;

    private final List<RuleGroupSourceStatelessRulesDetails> statelessRules;

    private RuleGroupSourceStatelessRulesAndCustomActionsDetails(BuilderImpl builder) {
        this.customActions = builder.customActions;
        this.statelessRules = builder.statelessRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomActions() {
        return customActions != null && !(customActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom actions for the rule group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomActions} method.
     * </p>
     * 
     * @return Custom actions for the rule group.
     */
    public final List<RuleGroupSourceCustomActionsDetails> customActions() {
        return customActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatelessRules() {
        return statelessRules != null && !(statelessRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Stateless rules for the rule group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessRules} method.
     * </p>
     * 
     * @return Stateless rules for the rule group.
     */
    public final List<RuleGroupSourceStatelessRulesDetails> statelessRules() {
        return statelessRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomActions() ? customActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessRules() ? statelessRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRulesAndCustomActionsDetails)) {
            return false;
        }
        RuleGroupSourceStatelessRulesAndCustomActionsDetails other = (RuleGroupSourceStatelessRulesAndCustomActionsDetails) obj;
        return hasCustomActions() == other.hasCustomActions() && Objects.equals(customActions(), other.customActions())
                && hasStatelessRules() == other.hasStatelessRules() && Objects.equals(statelessRules(), other.statelessRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRulesAndCustomActionsDetails")
                .add("CustomActions", hasCustomActions() ? customActions() : null)
                .add("StatelessRules", hasStatelessRules() ? statelessRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomActions":
            return Optional.ofNullable(clazz.cast(customActions()));
        case "StatelessRules":
            return Optional.ofNullable(clazz.cast(statelessRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRulesAndCustomActionsDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRulesAndCustomActionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRulesAndCustomActionsDetails> {
        /**
         * <p>
         * Custom actions for the rule group.
         * </p>
         * 
         * @param customActions
         *        Custom actions for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActions(Collection<RuleGroupSourceCustomActionsDetails> customActions);

        /**
         * <p>
         * Custom actions for the rule group.
         * </p>
         * 
         * @param customActions
         *        Custom actions for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActions(RuleGroupSourceCustomActionsDetails... customActions);

        /**
         * <p>
         * Custom actions for the rule group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #customActions(List<RuleGroupSourceCustomActionsDetails>)}.
         * 
         * @param customActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customActions(java.util.Collection<RuleGroupSourceCustomActionsDetails>)
         */
        Builder customActions(Consumer<RuleGroupSourceCustomActionsDetails.Builder>... customActions);

        /**
         * <p>
         * Stateless rules for the rule group.
         * </p>
         * 
         * @param statelessRules
         *        Stateless rules for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRules(Collection<RuleGroupSourceStatelessRulesDetails> statelessRules);

        /**
         * <p>
         * Stateless rules for the rule group.
         * </p>
         * 
         * @param statelessRules
         *        Stateless rules for the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRules(RuleGroupSourceStatelessRulesDetails... statelessRules);

        /**
         * <p>
         * Stateless rules for the rule group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #statelessRules(List<RuleGroupSourceStatelessRulesDetails>)}.
         * 
         * @param statelessRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRules(java.util.Collection<RuleGroupSourceStatelessRulesDetails>)
         */
        Builder statelessRules(Consumer<RuleGroupSourceStatelessRulesDetails.Builder>... statelessRules);
    }

    static final class BuilderImpl implements Builder {
        private List<RuleGroupSourceCustomActionsDetails> customActions = DefaultSdkAutoConstructList.getInstance();

        private List<RuleGroupSourceStatelessRulesDetails> statelessRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRulesAndCustomActionsDetails model) {
            customActions(model.customActions);
            statelessRules(model.statelessRules);
        }

        public final List<RuleGroupSourceCustomActionsDetails.Builder> getCustomActions() {
            List<RuleGroupSourceCustomActionsDetails.Builder> result = RuleGroupSourceCustomActionsListCopier
                    .copyToBuilder(this.customActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomActions(Collection<RuleGroupSourceCustomActionsDetails.BuilderImpl> customActions) {
            this.customActions = RuleGroupSourceCustomActionsListCopier.copyFromBuilder(customActions);
        }

        @Override
        public final Builder customActions(Collection<RuleGroupSourceCustomActionsDetails> customActions) {
            this.customActions = RuleGroupSourceCustomActionsListCopier.copy(customActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(RuleGroupSourceCustomActionsDetails... customActions) {
            customActions(Arrays.asList(customActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(Consumer<RuleGroupSourceCustomActionsDetails.Builder>... customActions) {
            customActions(Stream.of(customActions)
                    .map(c -> RuleGroupSourceCustomActionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupSourceStatelessRulesDetails.Builder> getStatelessRules() {
            List<RuleGroupSourceStatelessRulesDetails.Builder> result = RuleGroupSourceStatelessRulesListCopier
                    .copyToBuilder(this.statelessRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRules(Collection<RuleGroupSourceStatelessRulesDetails.BuilderImpl> statelessRules) {
            this.statelessRules = RuleGroupSourceStatelessRulesListCopier.copyFromBuilder(statelessRules);
        }

        @Override
        public final Builder statelessRules(Collection<RuleGroupSourceStatelessRulesDetails> statelessRules) {
            this.statelessRules = RuleGroupSourceStatelessRulesListCopier.copy(statelessRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRules(RuleGroupSourceStatelessRulesDetails... statelessRules) {
            statelessRules(Arrays.asList(statelessRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRules(Consumer<RuleGroupSourceStatelessRulesDetails.Builder>... statelessRules) {
            statelessRules(Stream.of(statelessRules)
                    .map(c -> RuleGroupSourceStatelessRulesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRulesAndCustomActionsDetails build() {
            return new RuleGroupSourceStatelessRulesAndCustomActionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
