/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about a member account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Member implements SdkPojo, Serializable, ToCopyableBuilder<Member.Builder, Member> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Member::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(Member::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> MASTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterId").getter(getter(Member::masterId)).setter(setter(Builder::masterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterId").build()).build();

    private static final SdkField<String> ADMINISTRATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdministratorId").getter(getter(Member::administratorId)).setter(setter(Builder::administratorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministratorId").build()).build();

    private static final SdkField<String> MEMBER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberStatus").getter(getter(Member::memberStatus)).setter(setter(Builder::memberStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberStatus").build()).build();

    private static final SdkField<Instant> INVITED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvitedAt")
            .getter(getter(Member::invitedAt))
            .setter(setter(Builder::invitedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(Member::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EMAIL_FIELD,
            MASTER_ID_FIELD, ADMINISTRATOR_ID_FIELD, MEMBER_STATUS_FIELD, INVITED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String email;

    private final String masterId;

    private final String administratorId;

    private final String memberStatus;

    private final Instant invitedAt;

    private final Instant updatedAt;

    private Member(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.email = builder.email;
        this.masterId = builder.masterId;
        this.administratorId = builder.administratorId;
        this.memberStatus = builder.memberStatus;
        this.invitedAt = builder.invitedAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the member account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The email address of the member account.
     * </p>
     * 
     * @return The email address of the member account.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * This is replaced by <code>AdministratorID</code>.
     * </p>
     * <p>
     * The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.
     * </p>
     * 
     * @return This is replaced by <code>AdministratorID</code>.</p>
     *         <p>
     *         The Amazon Web Services account ID of the Security Hub administrator account associated with this member
     *         account.
     * @deprecated This field is deprecated, use AdministratorId instead.
     */
    @Deprecated
    public final String masterId() {
        return masterId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Security Hub administrator account associated with this member account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Security Hub administrator account associated with this member
     *         account.
     */
    public final String administratorId() {
        return administratorId;
    }

    /**
     * <p>
     * The status of the relationship between the member account and its administrator account.
     * </p>
     * <p>
     * The status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Created</code> - Indicates that the administrator account added the member account, but has not yet invited
     * the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Invited</code> - Indicates that the administrator account invited the member account. The member account
     * has not yet responded to the invitation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Enabled</code> - Indicates that the member account is currently active. For manually invited member
     * accounts, indicates that the member account accepted the invitation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removed</code> - Indicates that the administrator account disassociated the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Resigned</code> - Indicates that the member account disassociated themselves from the administrator
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleted</code> - Indicates that the administrator account deleted the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccountSuspended</code> - Indicates that an organization account was suspended from Amazon Web Services at
     * the same time that the administrator account tried to enable the organization account as a member account.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the relationship between the member account and its administrator account. </p>
     *         <p>
     *         The status can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Created</code> - Indicates that the administrator account added the member account, but has not yet
     *         invited the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Invited</code> - Indicates that the administrator account invited the member account. The member
     *         account has not yet responded to the invitation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Enabled</code> - Indicates that the member account is currently active. For manually invited member
     *         accounts, indicates that the member account accepted the invitation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removed</code> - Indicates that the administrator account disassociated the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Resigned</code> - Indicates that the member account disassociated themselves from the administrator
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleted</code> - Indicates that the administrator account deleted the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccountSuspended</code> - Indicates that an organization account was suspended from Amazon Web
     *         Services at the same time that the administrator account tried to enable the organization account as a
     *         member account.
     *         </p>
     *         </li>
     */
    public final String memberStatus() {
        return memberStatus;
    }

    /**
     * <p>
     * A timestamp for the date and time when the invitation was sent to the member account.
     * </p>
     * 
     * @return A timestamp for the date and time when the invitation was sent to the member account.
     */
    public final Instant invitedAt() {
        return invitedAt;
    }

    /**
     * <p>
     * The timestamp for the date and time when the member account was updated.
     * </p>
     * 
     * @return The timestamp for the date and time when the member account was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(masterId());
        hashCode = 31 * hashCode + Objects.hashCode(administratorId());
        hashCode = 31 * hashCode + Objects.hashCode(memberStatus());
        hashCode = 31 * hashCode + Objects.hashCode(invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(email(), other.email())
                && Objects.equals(masterId(), other.masterId()) && Objects.equals(administratorId(), other.administratorId())
                && Objects.equals(memberStatus(), other.memberStatus()) && Objects.equals(invitedAt(), other.invitedAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Member").add("AccountId", accountId()).add("Email", email()).add("MasterId", masterId())
                .add("AdministratorId", administratorId()).add("MemberStatus", memberStatus()).add("InvitedAt", invitedAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "MasterId":
            return Optional.ofNullable(clazz.cast(masterId()));
        case "AdministratorId":
            return Optional.ofNullable(clazz.cast(administratorId()));
        case "MemberStatus":
            return Optional.ofNullable(clazz.cast(memberStatus()));
        case "InvitedAt":
            return Optional.ofNullable(clazz.cast(invitedAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Member> {
        /**
         * <p>
         * The Amazon Web Services account ID of the member account.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The email address of the member account.
         * </p>
         * 
         * @param email
         *        The email address of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * This is replaced by <code>AdministratorID</code>.
         * </p>
         * <p>
         * The Amazon Web Services account ID of the Security Hub administrator account associated with this member
         * account.
         * </p>
         * 
         * @param masterId
         *        This is replaced by <code>AdministratorID</code>.</p>
         *        <p>
         *        The Amazon Web Services account ID of the Security Hub administrator account associated with this
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated, use AdministratorId instead.
         */
        @Deprecated
        Builder masterId(String masterId);

        /**
         * <p>
         * The Amazon Web Services account ID of the Security Hub administrator account associated with this member
         * account.
         * </p>
         * 
         * @param administratorId
         *        The Amazon Web Services account ID of the Security Hub administrator account associated with this
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administratorId(String administratorId);

        /**
         * <p>
         * The status of the relationship between the member account and its administrator account.
         * </p>
         * <p>
         * The status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code> - Indicates that the administrator account added the member account, but has not yet
         * invited the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Invited</code> - Indicates that the administrator account invited the member account. The member
         * account has not yet responded to the invitation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Enabled</code> - Indicates that the member account is currently active. For manually invited member
         * accounts, indicates that the member account accepted the invitation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removed</code> - Indicates that the administrator account disassociated the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Resigned</code> - Indicates that the member account disassociated themselves from the administrator
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleted</code> - Indicates that the administrator account deleted the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccountSuspended</code> - Indicates that an organization account was suspended from Amazon Web Services
         * at the same time that the administrator account tried to enable the organization account as a member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param memberStatus
         *        The status of the relationship between the member account and its administrator account. </p>
         *        <p>
         *        The status can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code> - Indicates that the administrator account added the member account, but has not
         *        yet invited the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Invited</code> - Indicates that the administrator account invited the member account. The member
         *        account has not yet responded to the invitation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Enabled</code> - Indicates that the member account is currently active. For manually invited
         *        member accounts, indicates that the member account accepted the invitation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removed</code> - Indicates that the administrator account disassociated the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Resigned</code> - Indicates that the member account disassociated themselves from the
         *        administrator account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleted</code> - Indicates that the administrator account deleted the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccountSuspended</code> - Indicates that an organization account was suspended from Amazon Web
         *        Services at the same time that the administrator account tried to enable the organization account as a
         *        member account.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberStatus(String memberStatus);

        /**
         * <p>
         * A timestamp for the date and time when the invitation was sent to the member account.
         * </p>
         * 
         * @param invitedAt
         *        A timestamp for the date and time when the invitation was sent to the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedAt(Instant invitedAt);

        /**
         * <p>
         * The timestamp for the date and time when the member account was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp for the date and time when the member account was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String email;

        private String masterId;

        private String administratorId;

        private String memberStatus;

        private Instant invitedAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            accountId(model.accountId);
            email(model.email);
            masterId(model.masterId);
            administratorId(model.administratorId);
            memberStatus(model.memberStatus);
            invitedAt(model.invitedAt);
            updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        @Deprecated
        public final String getMasterId() {
            return masterId;
        }

        @Deprecated
        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        @Override
        @Deprecated
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final String getAdministratorId() {
            return administratorId;
        }

        public final void setAdministratorId(String administratorId) {
            this.administratorId = administratorId;
        }

        @Override
        public final Builder administratorId(String administratorId) {
            this.administratorId = administratorId;
            return this;
        }

        public final String getMemberStatus() {
            return memberStatus;
        }

        public final void setMemberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
        }

        @Override
        public final Builder memberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
            return this;
        }

        public final Instant getInvitedAt() {
            return invitedAt;
        }

        public final void setInvitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
        }

        @Override
        public final Builder invitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Member build() {
            return new Member(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
