/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<GetFindingsRequest.Builder, GetFindingsRequest> {
    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField
            .<AwsSecurityFindingFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(GetFindingsRequest::filters)).setter(setter(Builder::filters))
            .constructor(AwsSecurityFindingFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<SortCriterion>> SORT_CRITERIA_FIELD = SdkField
            .<List<SortCriterion>> builder(MarshallingType.LIST)
            .memberName("SortCriteria")
            .getter(getter(GetFindingsRequest::sortCriteria))
            .setter(setter(Builder::sortCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortCriterion> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortCriterion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFindingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetFindingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            SORT_CRITERIA_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final AwsSecurityFindingFilters filters;

    private final List<SortCriterion> sortCriteria;

    private final String nextToken;

    private final Integer maxResults;

    private GetFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.sortCriteria = builder.sortCriteria;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The finding attributes used to define a condition to filter the returned findings.
     * </p>
     * <p>
     * You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.
     * </p>
     * <p>
     * Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding based
     * on its workflow status, use <code>WorkflowStatus</code>.
     * </p>
     * 
     * @return The finding attributes used to define a condition to filter the returned findings.</p>
     *         <p>
     *         You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter
     *         values.
     *         </p>
     *         <p>
     *         Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a
     *         finding based on its workflow status, use <code>WorkflowStatus</code>.
     */
    public final AwsSecurityFindingFilters filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortCriteria() {
        return sortCriteria != null && !(sortCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The finding attributes used to sort the list of returned findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortCriteria} method.
     * </p>
     * 
     * @return The finding attributes used to sort the list of returned findings.
     */
    public final List<SortCriterion> sortCriteria() {
        return sortCriteria;
    }

    /**
     * <p>
     * The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set the
     * value of this parameter to <code>NULL</code>.
     * </p>
     * <p>
     * For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value
     * returned from the previous response.
     * </p>
     * 
     * @return The token that is required for pagination. On your first call to the <code>GetFindings</code> operation,
     *         set the value of this parameter to <code>NULL</code>.</p>
     *         <p>
     *         For subsequent calls to the operation, to continue listing data, set the value of this parameter to the
     *         value returned from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of findings to return.
     * </p>
     * 
     * @return The maximum number of findings to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortCriteria() ? sortCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsRequest)) {
            return false;
        }
        GetFindingsRequest other = (GetFindingsRequest) obj;
        return Objects.equals(filters(), other.filters()) && hasSortCriteria() == other.hasSortCriteria()
                && Objects.equals(sortCriteria(), other.sortCriteria()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingsRequest").add("Filters", filters())
                .add("SortCriteria", hasSortCriteria() ? sortCriteria() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsRequest, T> g) {
        return obj -> g.apply((GetFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingsRequest> {
        /**
         * <p>
         * The finding attributes used to define a condition to filter the returned findings.
         * </p>
         * <p>
         * You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.
         * </p>
         * <p>
         * Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding
         * based on its workflow status, use <code>WorkflowStatus</code>.
         * </p>
         * 
         * @param filters
         *        The finding attributes used to define a condition to filter the returned findings.</p>
         *        <p>
         *        You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter
         *        values.
         *        </p>
         *        <p>
         *        Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a
         *        finding based on its workflow status, use <code>WorkflowStatus</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AwsSecurityFindingFilters filters);

        /**
         * <p>
         * The finding attributes used to define a condition to filter the returned findings.
         * </p>
         * <p>
         * You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.
         * </p>
         * <p>
         * Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding
         * based on its workflow status, use <code>WorkflowStatus</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsSecurityFindingFilters.Builder}
         * avoiding the need to create one manually via {@link AwsSecurityFindingFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSecurityFindingFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(AwsSecurityFindingFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link AwsSecurityFindingFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(AwsSecurityFindingFilters)
         */
        default Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return filters(AwsSecurityFindingFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The finding attributes used to sort the list of returned findings.
         * </p>
         * 
         * @param sortCriteria
         *        The finding attributes used to sort the list of returned findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Collection<SortCriterion> sortCriteria);

        /**
         * <p>
         * The finding attributes used to sort the list of returned findings.
         * </p>
         * 
         * @param sortCriteria
         *        The finding attributes used to sort the list of returned findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SortCriterion... sortCriteria);

        /**
         * <p>
         * The finding attributes used to sort the list of returned findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.SortCriterion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.SortCriterion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.SortCriterion.Builder#build()} is called immediately
         * and its result is passed to {@link #sortCriteria(List<SortCriterion>)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.SortCriterion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(java.util.Collection<SortCriterion>)
         */
        Builder sortCriteria(Consumer<SortCriterion.Builder>... sortCriteria);

        /**
         * <p>
         * The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set
         * the value of this parameter to <code>NULL</code>.
         * </p>
         * <p>
         * For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value
         * returned from the previous response.
         * </p>
         * 
         * @param nextToken
         *        The token that is required for pagination. On your first call to the <code>GetFindings</code>
         *        operation, set the value of this parameter to <code>NULL</code>.</p>
         *        <p>
         *        For subsequent calls to the operation, to continue listing data, set the value of this parameter to
         *        the value returned from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of findings to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of findings to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private AwsSecurityFindingFilters filters;

        private List<SortCriterion> sortCriteria = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsRequest model) {
            super(model);
            filters(model.filters);
            sortCriteria(model.sortCriteria);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final List<SortCriterion.Builder> getSortCriteria() {
            List<SortCriterion.Builder> result = SortCriteriaCopier.copyToBuilder(this.sortCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortCriteria(Collection<SortCriterion.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copyFromBuilder(sortCriteria);
        }

        @Override
        public final Builder sortCriteria(Collection<SortCriterion> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(SortCriterion... sortCriteria) {
            sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<SortCriterion.Builder>... sortCriteria) {
            sortCriteria(Stream.of(sortCriteria).map(c -> SortCriterion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsRequest build() {
            return new GetFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
