/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingHistoryRequest extends SecurityHubRequest implements
        ToCopyableBuilder<GetFindingHistoryRequest.Builder, GetFindingHistoryRequest> {
    private static final SdkField<AwsSecurityFindingIdentifier> FINDING_IDENTIFIER_FIELD = SdkField
            .<AwsSecurityFindingIdentifier> builder(MarshallingType.SDK_POJO).memberName("FindingIdentifier")
            .getter(getter(GetFindingHistoryRequest::findingIdentifier)).setter(setter(Builder::findingIdentifier))
            .constructor(AwsSecurityFindingIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifier").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(GetFindingHistoryRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(GetFindingHistoryRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFindingHistoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetFindingHistoryRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIER_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final AwsSecurityFindingIdentifier findingIdentifier;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final Integer maxResults;

    private GetFindingHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.findingIdentifier = builder.findingIdentifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns the value of the FindingIdentifier property for this object.
     * 
     * @return The value of the FindingIdentifier property for this object.
     */
    public final AwsSecurityFindingIdentifier findingIdentifier() {
        return findingIdentifier;
    }

    /**
     * <p>
     * An ISO 8601-formatted timestamp that indicates the start time of the requested finding history. A correctly
     * formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces, and date and time
     * should be separated by <code>T</code>. For more information, see <a
     * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
     * </p>
     * <p>
     * If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns finding
     * history for the specified time period. If you provide a value for <code>StartTime</code> but not for
     * <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the time at which
     * the API is called. If you provide a value for <code>EndTime</code> but not for <code>StartTime</code>, Security
     * Hub returns finding history from the <a href=
     * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
     * >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
     * <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt
     * timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is
     * limited to 100 results, and the maximum time period is limited to 90 days.
     * </p>
     * 
     * @return An ISO 8601-formatted timestamp that indicates the start time of the requested finding history. A
     *         correctly formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces,
     *         and date and time should be separated by <code>T</code>. For more information, see <a
     *         href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>.</p>
     *         <p>
     *         If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns
     *         finding history for the specified time period. If you provide a value for <code>StartTime</code> but not
     *         for <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the
     *         time at which the API is called. If you provide a value for <code>EndTime</code> but not for
     *         <code>StartTime</code>, Security Hub returns finding history from the <a href=
     *         "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
     *         >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
     *         <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt
     *         timestamp of the finding to the time at which the API is called. In all of these scenarios, the response
     *         is limited to 100 results, and the maximum time period is limited to 90 days.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * An ISO 8601-formatted timestamp that indicates the end time of the requested finding history. A correctly
     * formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces, and date and time
     * should be separated by <code>T</code>. For more information, see <a
     * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
     * </p>
     * <p>
     * If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns finding
     * history for the specified time period. If you provide a value for <code>StartTime</code> but not for
     * <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the time at which
     * the API is called. If you provide a value for <code>EndTime</code> but not for <code>StartTime</code>, Security
     * Hub returns finding history from the <a href=
     * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
     * >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
     * <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt
     * timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is
     * limited to 100 results, and the maximum time period is limited to 90 days.
     * </p>
     * 
     * @return An ISO 8601-formatted timestamp that indicates the end time of the requested finding history. A correctly
     *         formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces, and date and
     *         time should be separated by <code>T</code>. For more information, see <a
     *         href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>.</p>
     *         <p>
     *         If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns
     *         finding history for the specified time period. If you provide a value for <code>StartTime</code> but not
     *         for <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the
     *         time at which the API is called. If you provide a value for <code>EndTime</code> but not for
     *         <code>StartTime</code>, Security Hub returns finding history from the <a href=
     *         "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
     *         >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
     *         <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt
     *         timestamp of the finding to the time at which the API is called. In all of these scenarios, the response
     *         is limited to 100 results, and the maximum time period is limited to 90 days.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A token for pagination purposes. Provide <code>NULL</code> as the initial value. In subsequent requests, provide
     * the token included in the response to get up to an additional 100 results of finding history. If you don’t
     * provide <code>NextToken</code>, Security Hub returns up to 100 results of finding history for each request.
     * </p>
     * 
     * @return A token for pagination purposes. Provide <code>NULL</code> as the initial value. In subsequent requests,
     *         provide the token included in the response to get up to an additional 100 results of finding history. If
     *         you don’t provide <code>NextToken</code>, Security Hub returns up to 100 results of finding history for
     *         each request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100 results of
     * finding history.
     * </p>
     * 
     * @return The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100
     *         results of finding history.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingHistoryRequest)) {
            return false;
        }
        GetFindingHistoryRequest other = (GetFindingHistoryRequest) obj;
        return Objects.equals(findingIdentifier(), other.findingIdentifier()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingHistoryRequest").add("FindingIdentifier", findingIdentifier())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingIdentifier":
            return Optional.ofNullable(clazz.cast(findingIdentifier()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingHistoryRequest, T> g) {
        return obj -> g.apply((GetFindingHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingHistoryRequest> {
        /**
         * Sets the value of the FindingIdentifier property for this object.
         *
         * @param findingIdentifier
         *        The new value for the FindingIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifier(AwsSecurityFindingIdentifier findingIdentifier);

        /**
         * Sets the value of the FindingIdentifier property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AwsSecurityFindingIdentifier.Builder}
         * avoiding the need to create one manually via {@link AwsSecurityFindingIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSecurityFindingIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #findingIdentifier(AwsSecurityFindingIdentifier)}.
         * 
         * @param findingIdentifier
         *        a consumer that will call methods on {@link AwsSecurityFindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifier(AwsSecurityFindingIdentifier)
         */
        default Builder findingIdentifier(Consumer<AwsSecurityFindingIdentifier.Builder> findingIdentifier) {
            return findingIdentifier(AwsSecurityFindingIdentifier.builder().applyMutation(findingIdentifier).build());
        }

        /**
         * <p>
         * An ISO 8601-formatted timestamp that indicates the start time of the requested finding history. A correctly
         * formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces, and date and
         * time should be separated by <code>T</code>. For more information, see <a
         * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         * Format</a>.
         * </p>
         * <p>
         * If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns finding
         * history for the specified time period. If you provide a value for <code>StartTime</code> but not for
         * <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the time at
         * which the API is called. If you provide a value for <code>EndTime</code> but not for <code>StartTime</code>,
         * Security Hub returns finding history from the <a href=
         * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
         * >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
         * <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt
         * timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is
         * limited to 100 results, and the maximum time period is limited to 90 days.
         * </p>
         * 
         * @param startTime
         *        An ISO 8601-formatted timestamp that indicates the start time of the requested finding history. A
         *        correctly formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces,
         *        and date and time should be separated by <code>T</code>. For more information, see <a
         *        href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>.</p>
         *        <p>
         *        If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns
         *        finding history for the specified time period. If you provide a value for <code>StartTime</code> but
         *        not for <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to
         *        the time at which the API is called. If you provide a value for <code>EndTime</code> but not for
         *        <code>StartTime</code>, Security Hub returns finding history from the <a href=
         *        "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
         *        >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
         *        <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the
         *        CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios,
         *        the response is limited to 100 results, and the maximum time period is limited to 90 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * An ISO 8601-formatted timestamp that indicates the end time of the requested finding history. A correctly
         * formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces, and date and
         * time should be separated by <code>T</code>. For more information, see <a
         * href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         * Format</a>.
         * </p>
         * <p>
         * If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns finding
         * history for the specified time period. If you provide a value for <code>StartTime</code> but not for
         * <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to the time at
         * which the API is called. If you provide a value for <code>EndTime</code> but not for <code>StartTime</code>,
         * Security Hub returns finding history from the <a href=
         * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
         * >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
         * <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the CreatedAt
         * timestamp of the finding to the time at which the API is called. In all of these scenarios, the response is
         * limited to 100 results, and the maximum time period is limited to 90 days.
         * </p>
         * 
         * @param endTime
         *        An ISO 8601-formatted timestamp that indicates the end time of the requested finding history. A
         *        correctly formatted example is <code>2020-05-21T20:16:34.724Z</code>. The value cannot contain spaces,
         *        and date and time should be separated by <code>T</code>. For more information, see <a
         *        href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>.</p>
         *        <p>
         *        If you provide values for both <code>StartTime</code> and <code>EndTime</code>, Security Hub returns
         *        finding history for the specified time period. If you provide a value for <code>StartTime</code> but
         *        not for <code>EndTime</code>, Security Hub returns finding history from the <code>StartTime</code> to
         *        the time at which the API is called. If you provide a value for <code>EndTime</code> but not for
         *        <code>StartTime</code>, Security Hub returns finding history from the <a href=
         *        "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt"
         *        >CreatedAt</a> timestamp of the finding to the <code>EndTime</code>. If you provide neither
         *        <code>StartTime</code> nor <code>EndTime</code>, Security Hub returns finding history from the
         *        CreatedAt timestamp of the finding to the time at which the API is called. In all of these scenarios,
         *        the response is limited to 100 results, and the maximum time period is limited to 90 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A token for pagination purposes. Provide <code>NULL</code> as the initial value. In subsequent requests,
         * provide the token included in the response to get up to an additional 100 results of finding history. If you
         * don’t provide <code>NextToken</code>, Security Hub returns up to 100 results of finding history for each
         * request.
         * </p>
         * 
         * @param nextToken
         *        A token for pagination purposes. Provide <code>NULL</code> as the initial value. In subsequent
         *        requests, provide the token included in the response to get up to an additional 100 results of finding
         *        history. If you don’t provide <code>NextToken</code>, Security Hub returns up to 100 results of
         *        finding history for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100 results
         * of finding history.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned. If you don’t provide it, Security Hub returns up to 100
         *        results of finding history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private AwsSecurityFindingIdentifier findingIdentifier;

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingHistoryRequest model) {
            super(model);
            findingIdentifier(model.findingIdentifier);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final AwsSecurityFindingIdentifier.Builder getFindingIdentifier() {
            return findingIdentifier != null ? findingIdentifier.toBuilder() : null;
        }

        public final void setFindingIdentifier(AwsSecurityFindingIdentifier.BuilderImpl findingIdentifier) {
            this.findingIdentifier = findingIdentifier != null ? findingIdentifier.build() : null;
        }

        @Override
        public final Builder findingIdentifier(AwsSecurityFindingIdentifier findingIdentifier) {
            this.findingIdentifier = findingIdentifier;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingHistoryRequest build() {
            return new GetFindingHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
